/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.workbench.shell;

import com.google.inject.Injector;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.miowb.common.FileSaveDialog;
import net.miowb.common.MioEMFFactory;
import net.miowb.common.MioEMFHelper;
import net.miowb.common.MioHelpers;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.miocontract.MiocontractFactory;
import net.miowb.model.miocontract.ModalIOContract;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.common.PrettyPrinting;
import net.miowb.workbench.diagrams.DiagramManager;
import net.miowb.workbench.operations.IMioOperations;
import net.miowb.workbench.operations.OperationManager;
import net.miowb.workbench.operations.contracts.ContractHelpers;
import net.miowb.workbench.shell.FSP2MIO;
import net.miowb.workbench.shell.MessageManager;
import net.miowb.workbench.shell.MioCommandLineObserver;
import net.miowb.xtext.MyMioWbLanguageStandaloneSetup;
import net.miowb.xtext.myMioWbLanguage.ActionLabelVerySimple;
import net.miowb.xtext.myMioWbLanguage.Assignment;
import net.miowb.xtext.myMioWbLanguage.AutomatonDef;
import net.miowb.xtext.myMioWbLanguage.BinaryCheck;
import net.miowb.xtext.myMioWbLanguage.Composition;
import net.miowb.xtext.myMioWbLanguage.Conjunction;
import net.miowb.xtext.myMioWbLanguage.ContractDef;
import net.miowb.xtext.myMioWbLanguage.Disjunction;
import net.miowb.xtext.myMioWbLanguage.Interface;
import net.miowb.xtext.myMioWbLanguage.ListOfStatements;
import net.miowb.xtext.myMioWbLanguage.MaxEnv;
import net.miowb.xtext.myMioWbLanguage.Normalize;
import net.miowb.xtext.myMioWbLanguage.Print;
import net.miowb.xtext.myMioWbLanguage.Quotient;
import net.miowb.xtext.myMioWbLanguage.Save;
import net.miowb.xtext.myMioWbLanguage.Specification;
import net.miowb.xtext.myMioWbLanguage.State;
import net.miowb.xtext.myMioWbLanguage.Statement;
import net.miowb.xtext.myMioWbLanguage.TerminalInterface;
import net.miowb.xtext.myMioWbLanguage.Transition;
import net.miowb.xtext.myMioWbLanguage.Weakening;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;

public class MioCommandLine {
    private static MioCommandLine fInstance;
    private Map<String, ModalIOAutomaton> fListOfDeclaredMIOs = new LinkedHashMap<String, ModalIOAutomaton>();
    private Map<String, ModalIOContract> fListOfDeclaredMIOContracts = new LinkedHashMap<String, ModalIOContract>();
    private IMioOperations fOps = OperationManager.getOperations();
    private boolean busy = false;
    private List<MioCommandLineObserver> fObservers = new ArrayList<MioCommandLineObserver>();
    private boolean fVerboseMode = false;
    private ModalIOAutomaton fresultAutomaton;
    private List<ModalIOAutomaton> mio_to_save = new ArrayList<ModalIOAutomaton>();
    private List<ModalIOContract> contract_to_save = new ArrayList<ModalIOContract>();

    public Object execute(String cmd) {
        Resource resource;
        block4: {
            try {
                XtextResourceSet resourceSet = this.initializeResourceSet();
                resource = resourceSet.createResource(URI.createURI((String)"dummy:/example.miotxt"));
                ByteArrayInputStream in = new ByteArrayInputStream(cmd.getBytes());
                resource.load((InputStream)in, resourceSet.getLoadOptions());
                if (resource.getErrors() == null || resource.getErrors().size() <= 0) break block4;
                for (Resource.Diagnostic d : resource.getErrors()) {
                    MessageManager.addError(d.getMessage());
                }
                return null;
            }
            catch (IOException iOException) {
                MessageManager.addError("Error while parsing.");
                return null;
            }
        }
        ListOfStatements model = (ListOfStatements)resource.getContents().get(0);
        this.executeListOfStatements(model);
        return this.fresultAutomaton;
    }

    private XtextResourceSet initializeResourceSet() {
        Injector injector = new MyMioWbLanguageStandaloneSetup().createInjectorAndDoEMFRegistration();
        XtextResourceSet resourceSet = (XtextResourceSet)injector.getInstance(XtextResourceSet.class);
        resourceSet.addLoadOption((Object)XtextResource.OPTION_RESOLVE_ALL, (Object)Boolean.TRUE);
        return resourceSet;
    }

    private void executeListOfStatements(ListOfStatements root) {
        if (root == null || root.getStatements() == null || root.getStatements().size() == 0) {
            MessageManager.add("Nothing to process");
            return;
        }
        EList statements = root.getStatements();
        while (statements.size() > 0) {
            Statement s = (Statement)statements.remove(0);
            try {
                this.executeStatement(s);
            }
            catch (MioException e) {
                MessageManager.addError(e.getMessage());
                break;
            }
        }
    }

    private void executeStatement(Statement s) throws MioException {
        if (s instanceof Specification) {
            FSP2MIO translator = new FSP2MIO();
            Specification spec = (Specification)s;
            List<ModalIOAutomaton> mios = translator.translate(spec);
            if (mios != null) {
                for (ModalIOAutomaton mio : mios) {
                    this.fListOfDeclaredMIOs.put(mio.getName(), mio);
                    this.fresultAutomaton = mio;
                }
            }
            return;
        }
        if (s instanceof AutomatonDef) {
            AutomatonDef d = (AutomatonDef)s;
            this.fListOfDeclaredMIOs.put(d.getName(), this.buildMIOfromDef(d));
            MessageManager.add("MIO " + d.getName() + " registered .");
            return;
        }
        if (s instanceof ContractDef) {
            ContractDef d = (ContractDef)s;
            this.fListOfDeclaredMIOContracts.put(d.getContractname(), this.buildContractfromDef(d));
            MessageManager.add("Modal contract " + d.getContractname() + " registered.");
            return;
        }
        if (s instanceof BinaryCheck) {
            BinaryCheck chk = (BinaryCheck)s;
            EObject left = this.buildEObjectfromProcess(chk.getLeft());
            EObject right = this.buildEObjectfromProcess(chk.getRight());
            if (left == null || right == null) {
                throw new MioException();
            }
            if (this.areEObjectsMios(left, right)) {
                this.doMIOBinaryCheck((ModalIOAutomaton)left, (ModalIOAutomaton)right, chk);
                return;
            }
            if (this.areEObjectsContracts(left, right)) {
                this.doContractBinaryCheck((ModalIOContract)left, (ModalIOContract)right, chk);
                return;
            }
            throw new MioException("Incompatible types in binary check!");
        }
        if (s instanceof Assignment) {
            Assignment a = (Assignment)s;
            a.getId();
            EObject term = this.buildEObjectfromProcess(a.getIntf());
            if (term instanceof ModalIOAutomaton) {
                ModalIOAutomaton mio = MioHelpers.copy((ModalIOAutomaton)((ModalIOAutomaton)term));
                mio.setName(a.getId());
                this.fListOfDeclaredMIOs.put(a.getId(), mio);
                MessageManager.add(String.valueOf(a.getId()) + " := " + ((ModalIOAutomaton)term).getName());
            } else if (term instanceof ModalIOContract) {
                ModalIOContract contr = (ModalIOContract)term;
                contr.setName(a.getId());
                ((ModalIOAutomaton)contr.getEnvironments().get(0)).setName(String.valueOf(a.getId()) + ".env");
                ((ModalIOAutomaton)contr.getSpecifications().get(0)).setName(String.valueOf(a.getId()) + ".spec");
                this.fListOfDeclaredMIOContracts.put(a.getId(), contr);
                MessageManager.add(String.valueOf(a.getId()) + " := " + ((ModalIOContract)term).getName());
            }
            return;
        }
        if (s instanceof net.miowb.xtext.myMioWbLanguage.List) {
            String resultMessage = "MIOs:\n";
            for (String mio : this.fListOfDeclaredMIOs.keySet()) {
                resultMessage = String.valueOf(resultMessage) + "  " + mio + "\n";
            }
            if (resultMessage.length() > 0) {
                resultMessage = resultMessage.substring(0, resultMessage.length() - 1);
            }
            MessageManager.add(resultMessage);
            resultMessage = "Modal contracts:\n";
            for (String mio : this.fListOfDeclaredMIOContracts.keySet()) {
                resultMessage = String.valueOf(resultMessage) + "  " + mio + "\n";
            }
            if (resultMessage.length() > 0) {
                resultMessage = resultMessage.substring(0, resultMessage.length() - 1);
            }
            MessageManager.add(resultMessage);
            return;
        }
        if (s instanceof Print) {
            Print p = (Print)s;
            ModalIOAutomaton m = this.fListOfDeclaredMIOs.get(p.getId());
            if (m == null) {
                ModalIOContract c = this.fListOfDeclaredMIOContracts.get(p.getId());
                if (c != null) {
                    MessageManager.add("Environment: \n" + PrettyPrinting.pp((ModalIOAutomaton)c.getEnvironments().get(0)));
                    MessageManager.add("Specification: \n" + PrettyPrinting.pp((ModalIOAutomaton)c.getSpecifications().get(0)));
                }
            } else {
                MessageManager.add(PrettyPrinting.pp(m));
            }
            return;
        }
        if (s instanceof Save) {
            Save save = (Save)s;
            EObject saveObj = (EObject)this.fListOfDeclaredMIOs.get(save.getId());
            if (saveObj != null && saveObj instanceof ModalIOAutomaton) {
                this.doMioSave((ModalIOAutomaton)saveObj);
                return;
            }
            saveObj = (EObject)this.fListOfDeclaredMIOContracts.get(save.getId());
            if (saveObj != null && saveObj instanceof ModalIOContract) {
                this.doContractSave((ModalIOContract)saveObj);
                return;
            }
            throw new MioException(String.valueOf(save.getId()) + " unkown!");
        }
    }

    private void doMIOBinaryCheck(ModalIOAutomaton mleft, ModalIOAutomaton mright, BinaryCheck chk) throws MioException {
        if (chk.getRel().equals("<=")) {
            this.fOps.checkStrongModalRefinement(mright, mleft, true, true);
            return;
        }
        if (chk.getRel().equals("<=*")) {
            this.fOps.checkWeakModalRefinement(mright, mleft, true, true);
            return;
        }
        if (chk.getRel().equals("equiv<=")) {
            this.fOps.checkStrongModalRefinement(mleft, mright, true, true);
            this.fOps.checkStrongModalRefinement(mright, mleft, true, true);
            return;
        }
        if (chk.getRel().equals("equiv<=*")) {
            this.fOps.checkWeakModalRefinement(mleft, mright, true, true);
            this.fOps.checkWeakModalRefinement(mright, mleft, true, true);
            return;
        }
        if (chk.getRel().equals("->")) {
            this.fOps.checkStrongEnvironmentCorrectness(mleft, mright);
            return;
        }
        if (chk.getRel().equals("->*")) {
            this.fOps.checkWeakEnvironmentCorrectness(mleft, mright);
            return;
        }
        if (chk.getRel().equals("<-->")) {
            this.fOps.checkStrongEnvironmentCorrectness(mleft, mright);
            this.fOps.checkStrongEnvironmentCorrectness(mright, mleft);
            return;
        }
        if (chk.getRel().equals("<-->*")) {
            this.fOps.checkWeakEnvironmentCorrectness(mleft, mright);
            this.fOps.checkWeakEnvironmentCorrectness(mright, mleft);
            return;
        }
    }

    private void doContractBinaryCheck(ModalIOContract cleft, ModalIOContract cright, BinaryCheck chk) throws MioException {
        if (chk.getRel().equals("<=")) {
            this.fOps.checkStrongModalContractRefinement(cright, cleft);
            return;
        }
        if (chk.getRel().equals("equiv<=")) {
            this.fOps.checkStrongModalContractRefinement(cright, cleft);
            this.fOps.checkStrongModalContractRefinement(cleft, cright);
            return;
        }
    }

    private void doMioSave(ModalIOAutomaton mio) {
        this.mio_to_save.clear();
        this.mio_to_save.add(mio);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                FileSaveDialog d = new FileSaveDialog(shell, "Saving", "Save it");
                d.open();
                Object[] o = d.getResult();
                if (o != null && o[0] != null && o[0] instanceof IFile) {
                    IFile f = (IFile)d.getResult()[0];
                    try {
                        ModalIOAutomaton mio = (ModalIOAutomaton)MioCommandLine.this.mio_to_save.remove(0);
                        EObject diagram = DiagramManager.getDiagrams().get(0).getDiagram(mio);
                        MioEMFHelper.store((IFile)f, (ModalIOAutomaton)mio, (EObject)diagram);
                        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        MessageDialog.openError((Shell)shell, (String)"Error while saving Mio", (String)("Could not save " + MioCommandLine.this.mio_to_save));
                    }
                }
            }
        });
        MessageManager.add("MIO saved.");
    }

    private void doContractSave(ModalIOContract c) {
        this.contract_to_save.clear();
        this.contract_to_save.add(c);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                FileSaveDialog d = new FileSaveDialog(shell, "Saving", "Save it");
                d.open();
                Object[] o = d.getResult();
                if (o != null && o[0] != null && o[0] instanceof IFile) {
                    IFile f = (IFile)d.getResult()[0];
                    try {
                        ModalIOContract cont = (ModalIOContract)MioCommandLine.this.contract_to_save.remove(0);
                        ModalIOAutomaton env = (ModalIOAutomaton)cont.getEnvironments().get(0);
                        ModalIOAutomaton spec = (ModalIOAutomaton)cont.getSpecifications().get(0);
                        EObject envDiagram = DiagramManager.getDiagrams().get(0).getDiagram(env);
                        EObject specDiagram = DiagramManager.getDiagrams().get(0).getDiagram(spec);
                        IPath cPath = f.getFullPath().removeFileExtension();
                        IFile envmio = ResourcesPlugin.getWorkspace().getRoot().getFile(cPath.removeLastSegments(1).append(String.valueOf(cPath.lastSegment()) + "_env").addFileExtension("mio"));
                        IFile specmio = ResourcesPlugin.getWorkspace().getRoot().getFile(cPath.removeLastSegments(1).append(String.valueOf(cPath.lastSegment()) + "_spec").addFileExtension("mio"));
                        MioEMFHelper.store((IFile)envmio, (ModalIOAutomaton)env, (EObject)envDiagram);
                        MioEMFHelper.store((IFile)specmio, (ModalIOAutomaton)spec, (EObject)specDiagram);
                        MioEMFHelper.store((IFile)f, (ModalIOContract)cont);
                        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        MessageDialog.openError((Shell)shell, (String)"Error while saving Mio", (String)("Could not save " + MioCommandLine.this.mio_to_save));
                    }
                }
            }
        });
        MessageManager.add("MIO Contract saved.");
    }

    private ModalIOAutomaton buildMIOfromDef(AutomatonDef def) throws MioException {
        net.miowb.model.mio.State to;
        net.miowb.model.mio.State from;
        Action action;
        InputAction act;
        ModalIOAutomaton newMio = MioEMFFactory.createAutomaton((String)def.getName());
        HashMap<String, InputAction> actions = new HashMap<String, InputAction>();
        if (def.getInputs() != null && def.getInputs().size() > 0) {
            for (ActionLabelVerySimple a : def.getInputs()) {
                act = MioEMFFactory.createInput((String)a.getName());
                newMio.getInputs().add((Object)act);
                actions.put(a.getName(), act);
            }
        }
        if (def.getOutputs() != null && def.getOutputs().size() > 0) {
            for (ActionLabelVerySimple output : def.getOutputs()) {
                act = MioEMFFactory.createOutput((String)output.getName());
                newMio.getOutputs().add((Object)act);
                actions.put(output.getName(), act);
            }
        }
        if (def.getInternals() != null && def.getInternals().size() > 0) {
            for (ActionLabelVerySimple internal : def.getInternals()) {
                act = MioEMFFactory.createInternal((String)internal.getName());
                newMio.getInternals().add((Object)act);
                actions.put(internal.getName(), act);
            }
        }
        if (def.getComms() != null && def.getComms().size() > 0) {
            for (ActionLabelVerySimple comm : def.getComms()) {
                act = MioEMFFactory.createCommunication((String)comm.getName());
                newMio.getCommunications().add((Object)act);
                actions.put(comm.getName(), act);
            }
        }
        HashMap<State, net.miowb.model.mio.State> stateMap = new HashMap<State, net.miowb.model.mio.State>();
        if (def.getStates() != null && def.getStates().size() > 0) {
            for (State s : def.getStates()) {
                net.miowb.model.mio.State state = MioEMFFactory.createState((ModalIOAutomaton)newMio, (String)s.getName());
                stateMap.put(s, state);
            }
        }
        if (def.getStart() != null) {
            net.miowb.model.mio.State state = (net.miowb.model.mio.State)stateMap.get(def.getStart());
            if (state == null) {
                throw new MioException("No start state found while parsing MIO " + def.getName());
            }
            newMio.setStart(state);
        }
        if (def.getMayTransitions() != null && def.getMayTransitions().size() > 0) {
            for (Transition t : def.getMayTransitions()) {
                for (ActionLabelVerySimple act2 : t.getActions()) {
                    MayTransition may = MioEMFFactory.createMayTransition();
                    action = (Action)actions.get(act2.getName());
                    from = (net.miowb.model.mio.State)stateMap.get(t.getFrom());
                    to = (net.miowb.model.mio.State)stateMap.get(t.getTo());
                    if (action == null) {
                        throw new MioException("The action " + act2 + "was not found while parsing MIO " + def.getName());
                    }
                    if (from == null) {
                        throw new MioException("The state " + t.getFrom() + " was not found while parsing MIO " + def.getName());
                    }
                    if (to == null) {
                        throw new MioException("The state " + t.getTo() + " was not found while parsing MIO " + def.getName());
                    }
                    may.setAction(action);
                    may.setFrom(from);
                    may.setTo(to);
                    newMio.getMayTransitions().add((Object)may);
                }
            }
        }
        if (def.getMustTransitions() != null && def.getMustTransitions().size() > 0) {
            for (Transition t : def.getMustTransitions()) {
                for (ActionLabelVerySimple act2 : t.getActions()) {
                    MustTransition must = MioEMFFactory.createMustTransition();
                    action = (Action)actions.get(act2.getName());
                    from = (net.miowb.model.mio.State)stateMap.get(t.getFrom());
                    to = (net.miowb.model.mio.State)stateMap.get(t.getTo());
                    if (action == null) {
                        throw new MioException("The action " + act2 + "was not found while parsing MIO " + def.getName());
                    }
                    if (from == null) {
                        throw new MioException("The state " + t.getFrom() + " was not found while parsing MIO " + def.getName());
                    }
                    if (to == null) {
                        throw new MioException("The state " + t.getTo() + " was not found while parsing MIO " + def.getName());
                    }
                    must.setAction(action);
                    must.setFrom(from);
                    must.setTo(to);
                    newMio.getMustTransitions().add((Object)must);
                }
            }
        }
        return newMio;
    }

    private ModalIOContract buildContractfromDef(ContractDef def) throws MioException {
        ModalIOContract newContract = MiocontractFactory.eINSTANCE.createModalIOContract();
        newContract.setName(def.getContractname());
        ModalIOAutomaton envMio = (ModalIOAutomaton)this.buildEObjectfromProcess(def.getAssume());
        if (envMio == null) {
            throw new MioException("The automaton " + def.getAssume() + " was not found while parsing Contract " + def.getContractname());
        }
        newContract.getEnvironments().add((Object)MioHelpers.copy((ModalIOAutomaton)envMio));
        ModalIOAutomaton specMio = (ModalIOAutomaton)this.buildEObjectfromProcess(def.getGuarantee());
        if (specMio == null) {
            throw new MioException("The automaton " + def.getGuarantee() + " was not found while parsing Contract " + def.getContractname());
        }
        newContract.getSpecifications().add((Object)MioHelpers.copy((ModalIOAutomaton)specMio));
        return ContractHelpers.getReducedContract(newContract);
    }

    private EObject buildEObjectfromProcess(Interface intf) throws MioException {
        if (intf instanceof TerminalInterface) {
            return this.buildEObjectfromTerminalInterface((TerminalInterface)intf);
        }
        if (intf instanceof Disjunction) {
            return this.buildEObjectfromDisjunction((Disjunction)intf);
        }
        if (intf instanceof Conjunction) {
            return this.buildEObjectfromConjunction((Conjunction)intf);
        }
        if (intf instanceof Composition) {
            return this.buildEObjectfromComposition((Composition)intf);
        }
        if (intf instanceof Weakening) {
            return this.buildEObjectfromWeakening((Weakening)intf);
        }
        if (intf instanceof Quotient) {
            return this.buildEObjectfromQuotient((Quotient)intf);
        }
        if (intf instanceof MaxEnv) {
            return this.buildEObjectfromMaxEnv((MaxEnv)intf);
        }
        if (intf instanceof Normalize) {
            return this.buildEObjectfromNormalize((Normalize)intf);
        }
        throw new MioException("Unknown Interface type encountered");
    }

    private EObject buildEObjectfromNormalize(Normalize intf) throws MioException {
        EObject contract = this.buildEObjectfromProcess(intf.getContract());
        if (contract instanceof ModalIOContract) {
            return this.fOps.normalize((ModalIOContract)contract);
        }
        throw new MioException("Normalization must be applied to a contract!");
    }

    private EObject buildEObjectfromMaxEnv(MaxEnv intf) throws MioException {
        EObject env;
        EObject spec = this.buildEObjectfromProcess(intf.getSpec());
        if (this.areEObjectsMios(spec, env = this.buildEObjectfromProcess(intf.getEnv()))) {
            return this.fOps.computeMaxStrongCorrectEnvironment((ModalIOAutomaton)spec, (ModalIOAutomaton)env);
        }
        throw new MioException("Incompatible terminal types for MaxEnv-operation:" + spec.getClass() + "," + env.getClass());
    }

    private boolean areEObjectsMios(EObject left, EObject right) {
        return left instanceof ModalIOAutomaton && right instanceof ModalIOAutomaton;
    }

    private boolean areEObjectsContracts(EObject left, EObject right) {
        return left instanceof ModalIOContract && right instanceof ModalIOContract;
    }

    private EObject buildEObjectfromDisjunction(Disjunction disjunction) throws MioException {
        EObject right;
        EObject left = this.buildEObjectfromProcess(disjunction.getLeft());
        if (this.areEObjectsMios(left, right = this.buildEObjectfromProcess(disjunction.getRight()))) {
            return this.doMIODisjunction((ModalIOAutomaton)left, (ModalIOAutomaton)right);
        }
        if (this.areEObjectsContracts(left, right)) {
            return this.doContractDisjunction((ModalIOContract)left, (ModalIOContract)right);
        }
        throw new MioException("Incompatible terminal types:" + left.getClass() + "," + right.getClass());
    }

    private ModalIOAutomaton doMIODisjunction(ModalIOAutomaton left, ModalIOAutomaton right) throws MioException {
        return this.fOps.disjoin(left, right);
    }

    private ModalIOContract doContractDisjunction(ModalIOContract left, ModalIOContract right) throws MioException {
        return this.fOps.disjoin(left, right);
    }

    private EObject buildEObjectfromConjunction(Conjunction conjunction) throws MioException {
        EObject right;
        EObject left = this.buildEObjectfromProcess(conjunction.getLeft());
        if (this.areEObjectsMios(left, right = this.buildEObjectfromProcess(conjunction.getRight()))) {
            return this.doMIOConjunction((ModalIOAutomaton)left, (ModalIOAutomaton)right);
        }
        if (this.areEObjectsContracts(left, right)) {
            return this.doContractConjunction((ModalIOContract)left, (ModalIOContract)right);
        }
        throw new MioException("Incompatible terminal types:" + left.getClass() + "," + right.getClass());
    }

    private ModalIOAutomaton doMIOConjunction(ModalIOAutomaton left, ModalIOAutomaton right) throws MioException {
        return this.fOps.conjoin(left, right);
    }

    private ModalIOContract doContractConjunction(ModalIOContract left, ModalIOContract right) throws MioException {
        return this.fOps.conjoin(left, right);
    }

    private EObject buildEObjectfromComposition(Composition comp) throws MioException {
        EObject right;
        EObject left = this.buildEObjectfromProcess(comp.getLeft());
        if (this.areEObjectsMios(left, right = this.buildEObjectfromProcess(comp.getRight()))) {
            return this.doMIOComposition((ModalIOAutomaton)left, (ModalIOAutomaton)right, comp.getOp());
        }
        if (this.areEObjectsContracts(left, right)) {
            return this.doContractComposition((ModalIOContract)left, (ModalIOContract)right);
        }
        throw new MioException("Incompatible terminal types:" + left.getClass() + "," + right.getClass());
    }

    private ModalIOAutomaton doMIOComposition(ModalIOAutomaton left, ModalIOAutomaton right, String op) throws MioException {
        ModalIOAutomaton r = null;
        ArrayList<ModalIOAutomaton> list = new ArrayList<ModalIOAutomaton>(2);
        list.add(left);
        list.add(right);
        if (left.isMTS() && right.isMTS()) {
            MessageManager.addVerbose("WARNING: Using MTS composition because there are only communication actions");
            r = this.fOps.composeMTS(list);
        } else if (op.equals("||")) {
            r = this.fOps.compose(list);
        } else if (op.equals("||opt")) {
            r = this.fOps.composeOptimistic_WRT_StrongOutputCompatibility(list);
        } else {
            throw new MioException(String.valueOf(op) + "unknown.");
        }
        return r;
    }

    private ModalIOContract doContractComposition(ModalIOContract left, ModalIOContract right) throws MioException {
        return this.fOps.compose(left, right);
    }

    private EObject buildEObjectfromTerminalInterface(TerminalInterface ti) throws MioException {
        EObject term = (EObject)this.fListOfDeclaredMIOs.get(ti.getId());
        if (term == null) {
            term = (EObject)this.fListOfDeclaredMIOContracts.get(ti.getId());
            if (term == null) {
                throw new MioException("MIO " + ti.getId() + " not found.");
            }
            if (ti.getConpart() != null && ti.getConpart().equals("spec")) {
                term = (EObject)((ModalIOContract)term).getSpecifications().get(0);
            } else if (ti.getConpart() != null && ti.getConpart().equals("env")) {
                term = (EObject)((ModalIOContract)term).getEnvironments().get(0);
            }
        }
        return term;
    }

    private EObject buildEObjectfromWeakening(Weakening w) throws MioException {
        EObject right;
        EObject left = this.buildEObjectfromProcess(w.getLeft());
        if (this.areEObjectsMios(left, right = this.buildEObjectfromProcess(w.getRight()))) {
            return this.doMIOWeakening((ModalIOAutomaton)left, (ModalIOAutomaton)right);
        }
        if (this.areEObjectsContracts(left, right)) {
            throw new MioException("Weakening is not defined on Contracts");
        }
        throw new MioException("Incompatible terminal types:" + left.getClass() + "," + right.getClass());
    }

    private ModalIOAutomaton doMIOWeakening(ModalIOAutomaton left, ModalIOAutomaton right) throws MioException {
        return this.fOps.weaken(left, right);
    }

    private EObject buildEObjectfromQuotient(Quotient q) throws MioException {
        EObject right;
        EObject left = this.buildEObjectfromProcess(q.getLeft());
        if (this.areEObjectsMios(left, right = this.buildEObjectfromProcess(q.getRight()))) {
            return this.doMIOQuotient((ModalIOAutomaton)left, (ModalIOAutomaton)right);
        }
        if (this.areEObjectsContracts(left, right)) {
            throw new MioException("Quotient is not defined on Contracts");
        }
        throw new MioException("Incompatible terminal types:" + left.getClass() + "," + right.getClass());
    }

    private ModalIOAutomaton doMIOQuotient(ModalIOAutomaton left, ModalIOAutomaton right) throws MioException {
        ModalIOAutomaton r = null;
        if (left.isMTS() && right.isMTS()) {
            MessageManager.addVerbose("WARNING: Using MTS quotient because there are only communication actions");
            r = this.fOps.quotientMTS(left, right);
        } else {
            r = this.fOps.quotient(left, right);
        }
        return r;
    }

    public static MioCommandLine getInstance() {
        if (fInstance == null) {
            fInstance = new MioCommandLine();
        }
        return fInstance;
    }

    public Map<String, ModalIOAutomaton> getListOfDeclaredMios() {
        return this.fListOfDeclaredMIOs;
    }

    public void put(String input, ModalIOAutomaton m) {
        this.fListOfDeclaredMIOs.put(input, m);
    }

    public ModalIOAutomaton get(String id) {
        return this.fListOfDeclaredMIOs.get(id);
    }

    public ModalIOAutomaton getAssumption(String id) {
        return (ModalIOAutomaton)this.fListOfDeclaredMIOContracts.get(id).getEnvironments().get(0);
    }

    public ModalIOAutomaton getGuarantee(String id) {
        return (ModalIOAutomaton)this.fListOfDeclaredMIOContracts.get(id).getSpecifications().get(0);
    }

    public ModalIOAutomaton getMIOforView() {
        return this.fresultAutomaton;
    }

    public ModalIOContract getContract(String id) {
        return this.fListOfDeclaredMIOContracts.get(id);
    }

    public void put(String input, ModalIOContract c) {
        this.fListOfDeclaredMIOContracts.put(input, c);
    }

    public boolean isfVerboseMode() {
        return this.fVerboseMode;
    }

    public void setfVerboseMode(boolean fVerboseMode) {
        this.fVerboseMode = fVerboseMode;
    }

    public void resetVariables() {
        this.fListOfDeclaredMIOs.clear();
        this.fListOfDeclaredMIOContracts.clear();
    }

    public void execute(IFile file) {
        this.setBusy(true);
        XtextResourceSet resourceSet = this.initializeResourceSet();
        Resource resource = resourceSet.getResource(URI.createFileURI((String)file.getLocation().toString()), true);
        EObject eobject = (EObject)resource.getContents().get(0);
        this.executeListOfStatements((ListOfStatements)eobject);
        this.setBusy(false);
    }

    public void registerMIO(ModalIOAutomaton mio) {
        if (!this.busy) {
            this.setBusy(true);
            MessageManager.add("");
            this.put(mio.getName(), mio);
            MessageManager.add("MIO " + mio.getName() + " stored.");
            this.setBusy(false);
        }
    }

    public void registerContract(ModalIOContract contract) {
        if (!this.busy) {
            this.setBusy(true);
            MessageManager.add("");
            this.put(contract.getName(), contract);
            MessageManager.add("Modal contract " + contract.getName() + " registered.");
            this.setBusy(false);
        }
    }

    public void setBusy(Boolean b) {
        this.busy = b;
        this.notifyObservers();
    }

    public Boolean isBusy() {
        return this.busy;
    }

    public void addObserver(MioCommandLineObserver obs) {
        this.fObservers.add(obs);
    }

    private void notifyObservers() {
        for (MioCommandLineObserver o : this.fObservers) {
            o.refresh();
        }
    }
}

