/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.workbench.shell;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.miowb.workbench.shell.Message;
import net.miowb.workbench.shell.MioCommandLineObserver;

public class MessageManager {
    private static ConcurrentLinkedQueue<Message> fMessages = new ConcurrentLinkedQueue();
    private static List<MioCommandLineObserver> fObservers = new ArrayList<MioCommandLineObserver>();
    private static Boolean fEnabled = true;
    private static Boolean fSendToShell = true;

    public static void add(String s) {
        if (fEnabled.booleanValue()) {
            fMessages.add(new Message(s, Message.MessageType.NORMAL));
            MessageManager.notifyObservers();
        }
    }

    public static void addError(String s) {
        if (fEnabled.booleanValue()) {
            fMessages.add(new Message(s, Message.MessageType.ERROR));
            MessageManager.notifyObservers();
        }
    }

    public static void addWarning(String s) {
        if (fEnabled.booleanValue()) {
            fMessages.add(new Message(s, Message.MessageType.WARNING));
            MessageManager.notifyObservers();
        }
    }

    public static void addVerbose(String s) {
        if (fEnabled.booleanValue()) {
            fMessages.add(new Message(s, Message.MessageType.VERBOSE));
            MessageManager.notifyObservers();
        }
    }

    public static ConcurrentLinkedQueue<Message> getMessages() {
        return fMessages;
    }

    public static void addObserver(MioCommandLineObserver obs) {
        fObservers.add(obs);
    }

    private static void notifyObservers() {
        if (fSendToShell.booleanValue()) {
            for (MioCommandLineObserver o : fObservers) {
                o.refresh();
            }
        }
    }

    public static Boolean getEnabled() {
        return fEnabled;
    }

    public static void setEnabled(Boolean fEnabled) {
        MessageManager.fEnabled = fEnabled;
    }

    public static void setSendToShell(boolean b) {
        fSendToShell = b;
    }

    public static String getMessagesAsString() {
        Message m;
        String result = "";
        while ((m = MessageManager.getMessages().poll()) != null) {
            if (m.getType().equals((Object)Message.MessageType.VERBOSE)) continue;
            result = String.valueOf(result) + "\n" + m.toString();
        }
        return result;
    }
}

