/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.workbench.shell;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.miowb.common.MioEMFFactory;
import net.miowb.common.MioHelpers;
import net.miowb.common.SignatureHelper;
import net.miowb.model.mio.InternalAction;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.xtext.myMioWbLanguage.ActionLabelSimple;
import net.miowb.xtext.myMioWbLanguage.Choice;
import net.miowb.xtext.myMioWbLanguage.ComplexActionLabel;
import net.miowb.xtext.myMioWbLanguage.GlobalProcess;
import net.miowb.xtext.myMioWbLanguage.Input;
import net.miowb.xtext.myMioWbLanguage.LocalProcess;
import net.miowb.xtext.myMioWbLanguage.LocalProcessReference;
import net.miowb.xtext.myMioWbLanguage.Output;
import net.miowb.xtext.myMioWbLanguage.ProcessBody;
import net.miowb.xtext.myMioWbLanguage.ProcessBodyChoices;
import net.miowb.xtext.myMioWbLanguage.Specification;
import net.miowb.xtext.myMioWbLanguage.Stop;
import org.eclipse.emf.common.util.EList;

public class FSP2MIO {
    private int counter = 0;
    private Map<String, Object> fStateToProcess = new HashMap<String, Object>();
    private Map<Object, String> fProcessToStartState = new HashMap<Object, String>();

    public List<ModalIOAutomaton> translate(Specification spec) {
        ArrayList<ModalIOAutomaton> result = new ArrayList<ModalIOAutomaton>();
        for (GlobalProcess proc : spec.getPrimitiveProcesses()) {
            ModalIOAutomaton mio = this.translate(proc.getBody());
            this.fProcessToStartState.put(proc, mio.getStart().getLabel());
            for (LocalProcess lproc : proc.getLocalProcesses()) {
                ModalIOAutomaton localmio = this.translate(lproc.getBody());
                this.fProcessToStartState.put(lproc, localmio.getStart().getLabel());
                mio = this.add(mio, localmio);
            }
            mio.getName();
            this.link(mio);
            mio.setName(proc.getName());
            MioHelpers.renameStates((ModalIOAutomaton)mio);
            result.add(mio);
        }
        return result;
    }

    private ModalIOAutomaton add(ModalIOAutomaton mio1, ModalIOAutomaton mio2) {
        MustTransition must;
        MayTransition may;
        ModalIOAutomaton mio = MioEMFFactory.createAutomaton((String)"");
        List conflicts = SignatureHelper.calculateConflictingActionsForConjunction((ModalIOAutomaton)mio1, (ModalIOAutomaton)mio2);
        if (conflicts.size() > 0) {
            return null;
        }
        for (InternalAction a : mio1.getInternals()) {
            MioEMFFactory.createInternal((ModalIOAutomaton)mio, (String)a.getLabel());
        }
        for (InternalAction a : mio2.getInternals()) {
            if (SignatureHelper.contains((ModalIOAutomaton)mio, (String)a.getLabel())) continue;
            MioEMFFactory.createInternal((ModalIOAutomaton)mio, (String)a.getLabel());
        }
        for (InternalAction a : mio1.getInputs()) {
            MioEMFFactory.createInput((ModalIOAutomaton)mio, (String)a.getLabel());
        }
        for (InternalAction a : mio2.getInputs()) {
            if (SignatureHelper.contains((ModalIOAutomaton)mio, (String)a.getLabel())) continue;
            MioEMFFactory.createInput((ModalIOAutomaton)mio, (String)a.getLabel());
        }
        for (InternalAction a : mio1.getOutputs()) {
            MioEMFFactory.createOutput((ModalIOAutomaton)mio, (String)a.getLabel());
        }
        for (InternalAction a : mio2.getOutputs()) {
            if (SignatureHelper.contains((ModalIOAutomaton)mio, (String)a.getLabel())) continue;
            MioEMFFactory.createOutput((ModalIOAutomaton)mio, (String)a.getLabel());
        }
        for (State s : mio1.getStates()) {
            MioEMFFactory.createState((ModalIOAutomaton)mio, (String)s.getLabel());
        }
        for (State s : mio2.getStates()) {
            MioEMFFactory.createState((ModalIOAutomaton)mio, (String)s.getLabel());
        }
        for (MayTransition t : mio1.getMayTransitions()) {
            may = MioEMFFactory.createMayTransition();
            may.setAction(SignatureHelper.getAction((ModalIOAutomaton)mio, (String)t.getAction().getLabel()));
            may.setFrom(this.getState(mio, t.getFrom()));
            may.setTo(this.getState(mio, t.getTo()));
            may.setAutomaton(mio);
        }
        for (MayTransition t : mio2.getMayTransitions()) {
            may = MioEMFFactory.createMayTransition();
            may.setAction(SignatureHelper.getAction((ModalIOAutomaton)mio, (String)t.getAction().getLabel()));
            may.setFrom(this.getState(mio, t.getFrom()));
            may.setTo(this.getState(mio, t.getTo()));
            may.setAutomaton(mio);
        }
        for (MayTransition t : mio1.getMustTransitions()) {
            must = MioEMFFactory.createMustTransition();
            must.setAction(SignatureHelper.getAction((ModalIOAutomaton)mio, (String)t.getAction().getLabel()));
            must.setFrom(this.getState(mio, t.getFrom()));
            must.setTo(this.getState(mio, t.getTo()));
            must.setAutomaton(mio);
        }
        for (MayTransition t : mio2.getMustTransitions()) {
            must = MioEMFFactory.createMustTransition();
            must.setAction(SignatureHelper.getAction((ModalIOAutomaton)mio, (String)t.getAction().getLabel()));
            must.setFrom(this.getState(mio, t.getFrom()));
            must.setTo(this.getState(mio, t.getTo()));
            must.setAutomaton(mio);
        }
        mio.setStart(this.getState(mio, mio1.getStart()));
        return mio;
    }

    private State getState(ModalIOAutomaton mio, State state) {
        return SignatureHelper.getStateByString((ModalIOAutomaton)mio, (String)state.getLabel());
    }

    private State getState(ModalIOAutomaton mio, String label) {
        return SignatureHelper.getStateByString((ModalIOAutomaton)mio, (String)label);
    }

    private void link(ModalIOAutomaton mio) {
        for (String s : this.fStateToProcess.keySet()) {
            State oldstate = this.getState(mio, s);
            State newstate = this.getState(mio, this.fProcessToStartState.get(this.fStateToProcess.get(s)));
            for (Transition t : mio.getTransitions()) {
                if (t.getTo() == oldstate) {
                    t.setTo(newstate);
                }
                if (t.getFrom() != oldstate) continue;
                t.setFrom(newstate);
            }
            if (mio.getStart() == oldstate) {
                mio.setStart(newstate);
            }
            mio.getStates().remove((Object)oldstate);
        }
    }

    private ModalIOAutomaton translate(ProcessBody body) {
        if (body instanceof Stop) {
            ModalIOAutomaton mio = MioEMFFactory.createAutomaton((String)"");
            State s0 = MioEMFFactory.createState((ModalIOAutomaton)mio, (String)this.getNextStateName());
            mio.setStart(s0);
            return mio;
        }
        if (body instanceof LocalProcessReference) {
            LocalProcessReference cfr_ignored_0 = (LocalProcessReference)body;
            ModalIOAutomaton mio = MioEMFFactory.createAutomaton((String)"");
            State s0 = MioEMFFactory.createState((ModalIOAutomaton)mio, (String)this.getNextStateName());
            mio.setStart(s0);
            this.fStateToProcess.put(s0.getLabel(), ((LocalProcessReference)body).getName());
            return mio;
        }
        if (body instanceof ProcessBodyChoices) {
            ProcessBodyChoices choices = (ProcessBodyChoices)body;
            ArrayList<ModalIOAutomaton> mios = new ArrayList<ModalIOAutomaton>();
            for (Choice choice : choices.getChoices()) {
                ModalIOAutomaton mio = this.translate(choice);
                mios.add(mio);
            }
            return this.mergeChoices(mios);
        }
        return null;
    }

    private ModalIOAutomaton mergeChoices(List<ModalIOAutomaton> mios) {
        ModalIOAutomaton mio = mios.get(0);
        int i = 1;
        while (i < mios.size()) {
            ModalIOAutomaton next = mios.get(i);
            mio = this.merge(mio, next);
            ++i;
        }
        return mio;
    }

    private ModalIOAutomaton merge(ModalIOAutomaton mio1, ModalIOAutomaton mio2) {
        ModalIOAutomaton mio = this.add(mio1, mio2);
        for (Transition t : mio.getTransitions()) {
            if (t.getFrom() == this.getState(mio, mio2.getStart())) {
                t.setFrom(mio.getStart());
            }
            if (t.getTo() != this.getState(mio, mio2.getStart())) continue;
            t.setTo(mio.getStart());
        }
        mio.getStates().remove((Object)this.getState(mio, mio2.getStart()));
        return mio;
    }

    private String getNextStateName() {
        return "s" + ++this.counter;
    }

    private ModalIOAutomaton translate(Choice choice) {
        EList labels = choice.getComplexActionLabels();
        ProcessBody next = choice.getBody();
        ModalIOAutomaton mio = this.translate(next);
        ListIterator it = labels.listIterator(labels.size());
        ListIterator modalities = choice.getModality().listIterator(choice.getModality().size());
        while (it.hasPrevious()) {
            ComplexActionLabel l = (ComplexActionLabel)it.previous();
            String m = (String)modalities.previous();
            ActionLabelSimple slabel = (ActionLabelSimple)l.getActionLabels().get(0);
            State s = MioEMFFactory.createState((ModalIOAutomaton)mio, (String)this.getNextStateName());
            Object t = m.equals("->") ? MioEMFFactory.createMustTransition((ModalIOAutomaton)mio) : MioEMFFactory.createMayTransition((ModalIOAutomaton)mio);
            Object action = SignatureHelper.getAction((ModalIOAutomaton)mio, (String)slabel.getName());
            if (action == null) {
                action = slabel.getModifier() != null && slabel.getModifier() instanceof Input ? MioEMFFactory.createInput((ModalIOAutomaton)mio, (String)slabel.getName()) : (slabel.getModifier() != null && slabel.getModifier() instanceof Output ? MioEMFFactory.createOutput((ModalIOAutomaton)mio, (String)slabel.getName()) : MioEMFFactory.createInternal((ModalIOAutomaton)mio, (String)slabel.getName()));
            }
            t.setAction(action);
            t.setFrom(s);
            t.setTo(mio.getStart());
            mio.setStart(s);
        }
        return mio;
    }
}

