/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.workbench.operations.result;

import java.util.List;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.workbench.operations.result.AbstractOperationResult;
import net.miowb.workbench.shell.Message;

public class ConjunctionResult
extends AbstractOperationResult {
    private ResultType fResultType;
    private ModalIOAutomaton fAutomaton;
    private List<Action> fProblematicActions;

    public ConjunctionResult(ResultType type, List<Action> problemActions, List<Message> mes) {
        super(mes);
        this.fResultType = type;
        this.fProblematicActions = problemActions;
        this.fAutomaton = null;
    }

    public ConjunctionResult(ResultType type, ModalIOAutomaton automaton) {
        this.fResultType = type;
        this.fAutomaton = automaton;
        this.fProblematicActions = null;
    }

    public ConjunctionResult(ResultType type, List<Message> mes) {
        super(mes);
        this.fResultType = type;
        this.fAutomaton = null;
        this.fProblematicActions = null;
    }

    public ResultType getResultType() {
        return this.fResultType;
    }

    public ModalIOAutomaton getAutomaton() {
        return this.fAutomaton;
    }

    public List<Action> getProblematicActions() {
        return this.fProblematicActions;
    }

    public String getActionsAsString() {
        StringBuilder b = new StringBuilder();
        for (Action a : this.fProblematicActions) {
            b.append(a.getLabel());
            b.append(",");
        }
        if (this.fProblematicActions.size() > 0) {
            b.deleteCharAt(b.length() - 1);
        }
        return b.toString();
    }

    public static enum ResultType {
        SUCCESS,
        PROBLEM_ACTIONS,
        INCONSISTENT,
        MISMATCHING_ACTIONS,
        NON_DETERMINISTIC;

    }
}

