/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.workbench.operations.result;

import java.util.ArrayList;
import java.util.List;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.OutputAction;
import net.miowb.workbench.operations.model.SingleActionPath;
import net.miowb.workbench.operations.model.StatePair;
import net.miowb.workbench.operations.result.AbstractOperationResult;
import net.miowb.workbench.shell.Message;

public class CompatibilityResult
extends AbstractOperationResult {
    private ResultType fType;
    private CompatibilityType fCompType;
    private ModalIOAutomaton s1;
    private ModalIOAutomaton s2;
    private OutputAction fProblematicOutputAction;
    private StatePair fProblematicStatePair;
    private List<String> fIncomposableActions = new ArrayList<String>();
    private SingleActionPath fProblemPath;
    private List<StatePair> fResultingStates = new ArrayList<StatePair>();

    public CompatibilityResult(ResultType type, List<Message> mes, CompatibilityType comptype, ModalIOAutomaton mio1, ModalIOAutomaton mio2) {
        super(mes);
        this.fType = type;
        this.fCompType = comptype;
        this.s1 = mio1;
        this.s2 = mio2;
    }

    public CompatibilityResult(ResultType type, CompatibilityType comptype, ModalIOAutomaton mio1, ModalIOAutomaton mio2) {
        this.fType = type;
        this.fCompType = comptype;
        this.s1 = mio1;
        this.s2 = mio2;
    }

    public void setfType(ResultType fType) {
        this.fType = fType;
    }

    public void setProblematicOutputAction(OutputAction output) {
        this.fProblematicOutputAction = output;
    }

    public void setProblematicStatePair(StatePair statepair) {
        this.fProblematicStatePair = statepair;
    }

    public void setProblemPath(SingleActionPath singleActionPath) {
        this.fProblemPath = singleActionPath;
    }

    public List<String> getIncomposableActions() {
        return this.fIncomposableActions;
    }

    public void addIncomposableActions(String action) {
        this.fIncomposableActions.add(action);
    }

    public void addResultingState(StatePair sp) {
        this.fResultingStates.add(sp);
    }

    public void setResultingStates(List<StatePair> sp) {
        this.fResultingStates = sp;
    }

    public List<StatePair> getResultingStates() {
        return this.fResultingStates;
    }

    public OutputAction getProblematicOutputAction() {
        return this.fProblematicOutputAction;
    }

    public StatePair getProblematicStatePair() {
        return this.fProblematicStatePair;
    }

    public SingleActionPath getProblemPath() {
        return this.fProblemPath;
    }

    public ResultType getResultType() {
        return this.fType;
    }

    public boolean areCompatible() {
        return this.fType.equals((Object)ResultType.SUCCESS);
    }

    public List<Message> prettyprint() {
        ArrayList<Message> result = new ArrayList<Message>();
        result.addAll(this.fMessages);
        String compatible_type = "";
        switch (this.fCompType) {
            case STRONG: {
                compatible_type = "strongly compatible";
                break;
            }
            case WEAK: {
                compatible_type = "weakly compatible";
                break;
            }
            case STRONG_FRIENDLY: {
                compatible_type = "strongly compatible for a helpful environment";
                break;
            }
            case STRICT_OBSERVATIONAL: {
                compatible_type = "strict observationally compatible";
                break;
            }
            case ULTRAWEAK: {
                compatible_type = "ultra-weakly compatible";
            }
        }
        switch (this.fType) {
            case SUCCESS: {
                result.add(new Message(String.valueOf(this.s1.getName()) + " and " + this.s2.getName() + " are " + compatible_type + ".", Message.MessageType.NORMAL));
                break;
            }
            case ERROR: {
                result.add(new Message(String.valueOf(this.s1.getName()) + " and " + this.s2.getName() + " are not " + compatible_type + ".", Message.MessageType.ERROR));
                if (this.fProblematicStatePair != null) break;
                result.add(new Message("In state " + this.fProblematicStatePair.getLabel() + " there is " + this.fProblematicStatePair.getProblematicPath().toNiceString() + " but in the other automaton there is no corresponding must-transition.", Message.MessageType.ERROR));
                break;
            }
        }
        return result;
    }

    public void setfCompMode(CompatibilityType fCompType) {
        this.fCompType = fCompType;
    }

    public CompatibilityType getfCompMode() {
        return this.fCompType;
    }

    public static enum CompatibilityType {
        STRONG,
        WEAK,
        ULTRAWEAK,
        STRONG_FRIENDLY,
        STRICT_OBSERVATIONAL;

    }

    public static enum ResultType {
        SUCCESS,
        ERROR,
        MISMATCHING_ACTIONS;

    }
}

