/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.workbench.operations.model;

import java.util.Set;
import net.miowb.model.mio.State;

public class WeakeningState {
    private Set<State> fEnvironmentStates;
    private State fState;

    public WeakeningState(Set<State> envStates, State s) {
        this.fEnvironmentStates = envStates;
        this.fState = s;
    }

    public Set<State> getEnvStates() {
        return this.fEnvironmentStates;
    }

    public State getState() {
        return this.fState;
    }

    public String getLabel() {
        String r = "({";
        for (State p : this.fEnvironmentStates) {
            r = String.valueOf(r) + p.getLabel() + ",";
        }
        r = r.substring(0, r.length() - 1);
        r = String.valueOf(r) + "}," + this.fState.getLabel() + ")";
        return r;
    }

    public String toString() {
        return this.getLabel();
    }

    public boolean matchWith(WeakeningState w) {
        return this.matchWith(w.getEnvStates(), w.getState());
    }

    public boolean matchWith(Set<State> envStates, State to) {
        boolean found;
        if (envStates.size() != this.fEnvironmentStates.size()) {
            return false;
        }
        for (State s : envStates) {
            found = false;
            for (State f : this.fEnvironmentStates) {
                if (!s.getLabel().equals(f.getLabel())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        for (State s : this.fEnvironmentStates) {
            found = false;
            for (State f : envStates) {
                if (!s.getLabel().equals(f.getLabel())) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return this.fState.getLabel().equals(to.getLabel());
    }
}

