/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.workbench.operations.model;

import java.util.ArrayList;
import java.util.List;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.State;
import net.miowb.workbench.common.MioException;

public class StateList {
    private List<State> fStates;

    public StateList() {
        this.fStates = new ArrayList<State>();
    }

    public StateList(List<State> s) {
        this.fStates = s;
    }

    public List<State> getStates() {
        return this.fStates;
    }

    public String getLabel() {
        return this.toString();
    }

    public int getSize() {
        return this.fStates.size();
    }

    public State get(int i) {
        return this.fStates.get(i);
    }

    public StateList exchange(int i, State to) {
        ArrayList<State> l = new ArrayList<State>();
        int j = 0;
        while (j < this.fStates.size()) {
            if (i == j) {
                l.add(to);
            } else {
                l.add(this.fStates.get(j));
            }
            ++j;
        }
        return new StateList(l);
    }

    public int getIndex(ModalIOAutomaton mio) throws MioException {
        for (State s : this.fStates) {
            if (!mio.getStates().contains((Object)s)) continue;
            return this.fStates.indexOf(s);
        }
        throw new MioException("Error in StateList.");
    }

    public boolean matches(StateList sl) {
        if (sl.getStates().size() != this.fStates.size()) {
            return false;
        }
        int i = 0;
        while (i < this.fStates.size()) {
            if (!this.fStates.get(i).getLabel().equals(sl.getStates().get(i).getLabel())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        String result = "(";
        for (State s : this.fStates) {
            result = String.valueOf(result) + s.getLabel() + ",";
        }
        return String.valueOf(result.substring(0, result.length() - 1)) + ")";
    }
}

