/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.workbench.operations.model;

import java.util.ArrayList;
import java.util.List;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.workbench.common.PrettyPrinting;
import org.eclipse.emf.common.util.EList;

public class SingleActionPath {
    private State fFrom;
    private State fTo;
    private Action fAction;
    private List<Transition> fTransitions = new ArrayList<Transition>();

    public static SingleActionPath convertOne(Transition transition) {
        SingleActionPath path = new SingleActionPath();
        path.setFrom(transition.getFrom());
        path.setTo(transition.getTo());
        path.setAction(transition.getAction());
        path.addTransition(transition);
        return path;
    }

    public static List<SingleActionPath> convertEach(EList<Transition> transitionList) {
        ArrayList<SingleActionPath> paths = new ArrayList<SingleActionPath>();
        for (Transition transition : transitionList) {
            SingleActionPath path = new SingleActionPath();
            path.setFrom(transition.getFrom());
            path.setTo(transition.getTo());
            path.setAction(transition.getAction());
            path.addTransition(transition);
            paths.add(path);
        }
        return paths;
    }

    public static SingleActionPath convertAll(List<Transition> transitionList) {
        if (transitionList.isEmpty()) {
            throw new RuntimeException("Invalid assumption: PathToTarget is null?");
        }
        Action action = null;
        int i = transitionList.size() - 1;
        while (i >= 0) {
            Transition transition = transitionList.get(i);
            if (!transition.getAction().isInternal()) {
                action = transition.getAction();
                break;
            }
            --i;
        }
        if (action == null) {
            action = transitionList.get(0).getAction();
        }
        SingleActionPath path = new SingleActionPath();
        path.setFrom(transitionList.get(0).getFrom());
        path.setTo(transitionList.get(transitionList.size() - 1).getTo());
        path.setAction(action);
        path.addAllTransitions(transitionList);
        return path;
    }

    private SingleActionPath() {
    }

    public boolean isMay() {
        return this.fTransitions.get(0).isMay();
    }

    public boolean isSameAs(SingleActionPath other) {
        if (this.fTransitions.size() != other.fTransitions.size()) {
            return false;
        }
        int i = 0;
        while (i < this.fTransitions.size()) {
            if (!this.fTransitions.get(i).equals(other.fTransitions.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void addTransition(Transition transition) {
        this.fTransitions.add(transition);
    }

    private void addAllTransitions(List<Transition> transitions) {
        this.fTransitions.addAll(transitions);
    }

    public State getFrom() {
        return this.fFrom;
    }

    public void setFrom(State start) {
        this.fFrom = start;
    }

    public State getTo() {
        return this.fTo;
    }

    public void setTo(State end) {
        this.fTo = end;
    }

    public Action getAction() {
        return this.fAction;
    }

    public void setAction(Action action) {
        this.fAction = action;
    }

    public List<Transition> getTransitions() {
        return this.fTransitions;
    }

    public Transition getRelevantTransition() {
        for (Transition t : this.getTransitions()) {
            if (t.getAction().isInternal()) continue;
            return t;
        }
        return this.getTransitions().get(0);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Path with action " + this.fAction.getLabel() + ": ");
        for (Transition t : this.fTransitions) {
            b.append(String.valueOf(t.getFrom().getLabel()) + "->(" + t.getAction().getLabel() + ")->" + t.getTo().getLabel() + ",");
        }
        if (!this.fTransitions.isEmpty()) {
            b.deleteCharAt(b.length() - 1);
        }
        return b.toString();
    }

    public String toNiceString() {
        StringBuilder b = new StringBuilder();
        for (Transition t : this.fTransitions) {
            b.append(String.valueOf(t.getFrom().getLabel()) + "--" + PrettyPrinting.pp(t.getAction()) + "-->" + t.getTo().getLabel() + ",");
        }
        if (!this.fTransitions.isEmpty()) {
            b.deleteCharAt(b.length() - 1);
        }
        return b.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.fAction == null ? 0 : this.fAction.hashCode());
        result = 31 * result + (this.fFrom == null ? 0 : this.fFrom.hashCode());
        result = 31 * result + (this.fTo == null ? 0 : this.fTo.hashCode());
        result = 31 * result + (this.fTransitions == null ? 0 : this.fTransitions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SingleActionPath other = (SingleActionPath)obj;
        if (this.fAction == null ? other.fAction != null : !this.fAction.equals(other.fAction)) {
            return false;
        }
        if (this.fFrom == null ? other.fFrom != null : !this.fFrom.equals(other.fFrom)) {
            return false;
        }
        if (this.fTo == null ? other.fTo != null : !this.fTo.equals(other.fTo)) {
            return false;
        }
        return !(this.fTransitions == null ? other.fTransitions != null : !this.fTransitions.equals(other.fTransitions));
    }

    public boolean containsTransition(Transition t) {
        for (Transition tt : this.fTransitions) {
            if (!tt.equals(t)) continue;
            return true;
        }
        return false;
    }
}

