/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.workbench.operations.model;

import java.util.ArrayList;
import java.util.List;
import net.miowb.workbench.operations.model.SingleActionPath;
import net.miowb.workbench.operations.model.StatePair;

public class SetOfStatePairs {
    private List<StatePair> fStatePairs;
    private boolean fIsProblematic;
    private SingleActionPath fProblematicPath;

    public SetOfStatePairs() {
        this.fStatePairs = new ArrayList<StatePair>();
    }

    public SetOfStatePairs(List<StatePair> l) {
        this.fStatePairs = l;
    }

    public boolean contains(StatePair p) {
        return this.fStatePairs.contains(p);
    }

    public void add(StatePair p) {
        this.fStatePairs.add(p);
    }

    public void addall(SetOfStatePairs s) {
        for (StatePair p : s.getStatePairs()) {
            if (this.fStatePairs.contains(p)) continue;
            this.fStatePairs.add(p);
        }
    }

    public List<StatePair> getStatePairs() {
        return this.fStatePairs;
    }

    public String getLabel() {
        String r = "{";
        for (StatePair p : this.fStatePairs) {
            r = String.valueOf(r) + "(" + p.getS1().getLabel() + "," + p.getS2().getLabel() + "),";
        }
        if (!r.equals("{")) {
            r = r.substring(0, r.length() - 1);
        }
        return String.valueOf(r) + "}";
    }

    public String toString() {
        return this.getLabel();
    }

    public void setIsProblem(boolean problem) {
        this.fIsProblematic = problem;
    }

    public boolean isProblematic() {
        return this.fIsProblematic;
    }

    public void setProblematicPath(SingleActionPath thePathToCheck) {
        this.fProblematicPath = thePathToCheck;
    }

    public SingleActionPath getProblematicPath() {
        return this.fProblematicPath;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SetOfStatePairs)) {
            return false;
        }
        SetOfStatePairs o = (SetOfStatePairs)obj;
        if (this.getStatePairs().size() != o.getStatePairs().size()) {
            return false;
        }
        for (StatePair s : this.getStatePairs()) {
            if (o.getStatePairs().contains(s)) continue;
            return false;
        }
        for (StatePair s : o.getStatePairs()) {
            if (this.getStatePairs().contains(s)) continue;
            return false;
        }
        return true;
    }
}

