/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.workbench.operations.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.miowb.model.mio.Transition;
import net.miowb.workbench.operations.model.SingleActionPath;
import net.miowb.workbench.operations.model.StatePair;

public class RefinementRelation {
    private Set<StatePair> fStatePairs = new LinkedHashSet<StatePair>();
    private Map<StatePair, List<SingleActionPath>> fRequiredPaths = new LinkedHashMap<StatePair, List<SingleActionPath>>();
    private Map<StatePair, Map<SingleActionPath, List<SingleActionPath>>> fProvidedPaths = new LinkedHashMap<StatePair, Map<SingleActionPath, List<SingleActionPath>>>();

    public void addPair(StatePair pair) {
        this.fStatePairs.add(pair);
    }

    public void addRequired(StatePair pair, SingleActionPath requiredPath) {
        List<SingleActionPath> list = this.fRequiredPaths.get(pair);
        if (list == null) {
            list = new ArrayList<SingleActionPath>();
            this.fRequiredPaths.put(pair, list);
        }
        list.add(requiredPath);
    }

    public void addProvided(StatePair pair, SingleActionPath requiredPath, List<SingleActionPath> providedPaths) {
        List<SingleActionPath> list;
        Map<SingleActionPath, List<SingleActionPath>> map = this.fProvidedPaths.get(pair);
        if (map == null) {
            map = new LinkedHashMap<SingleActionPath, List<SingleActionPath>>();
            this.fProvidedPaths.put(pair, map);
        }
        if ((list = map.get(requiredPath)) == null) {
            list = new ArrayList<SingleActionPath>();
            map.put(requiredPath, list);
        }
        list.addAll(providedPaths);
    }

    public Set<StatePair> getStatePairs() {
        return this.fStatePairs;
    }

    public StatePair getPairWithoutProvided() {
        for (StatePair sPair : this.fStatePairs) {
            Map<SingleActionPath, List<SingleActionPath>> map = this.fProvidedPaths.get(sPair);
            if (map != null && !map.isEmpty()) continue;
            return sPair;
        }
        return null;
    }

    public List<SingleActionPath> getRequiredWithoutProvided() {
        for (StatePair sPair : this.fStatePairs) {
            Map<SingleActionPath, List<SingleActionPath>> map = this.fProvidedPaths.get(sPair);
            if (map != null && !map.isEmpty()) continue;
            return this.fRequiredPaths.get(sPair);
        }
        return null;
    }

    public Set<Transition> getFlattenedTransitions() {
        LinkedHashSet<Transition> s = new LinkedHashSet<Transition>();
        for (StatePair pair : this.fStatePairs) {
            Map<SingleActionPath, List<SingleActionPath>> map;
            List<SingleActionPath> list = this.fRequiredPaths.get(pair);
            if (list != null && !list.isEmpty()) {
                for (SingleActionPath singleActionPath : list) {
                    s.addAll(singleActionPath.getTransitions());
                }
            }
            if ((map = this.fProvidedPaths.get(pair)) == null || map.isEmpty()) continue;
            for (List<SingleActionPath> singleActionPath : map.values()) {
                for (SingleActionPath singleActionPath2 : singleActionPath) {
                    s.addAll(singleActionPath2.getTransitions());
                }
            }
        }
        return s;
    }

    public Set<SingleActionPath> getInvolvements(Transition t) {
        LinkedHashSet<SingleActionPath> allPaths = new LinkedHashSet<SingleActionPath>();
        for (StatePair pair : this.fStatePairs) {
            List<SingleActionPath> list = this.fRequiredPaths.get(pair);
            if (list == null) continue;
            for (SingleActionPath singleActionPath : list) {
                if (!singleActionPath.containsTransition(t)) continue;
                allPaths.add(singleActionPath);
                List<SingleActionPath> list2 = this.fProvidedPaths.get(pair).get(singleActionPath);
                if (list2 == null) continue;
                for (SingleActionPath singleActionPath2 : list2) {
                    allPaths.add(singleActionPath2);
                }
            }
        }
        return allPaths;
    }
}

