/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.workbench.operations.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.miowb.model.mio.Action;
import net.miowb.workbench.operations.model.PairTransition;
import net.miowb.workbench.operations.model.StatePair;

public class PairBasedAutomaton {
    private Set<Action> fInputs;
    private Set<Action> fOutputs;
    private Set<Action> fInternals;
    private List<StatePair> fStates;
    private List<PairTransition> fTransitions;
    private StatePair fStartPair;

    public void addInputs(Set<Action> newIns) {
        this.fInputs = newIns;
    }

    public void addOutputs(Set<Action> newOuts) {
        this.fOutputs = newOuts;
    }

    public void addInternals(Set<Action> newInternals) {
        this.fInternals = newInternals;
    }

    public void addStates(List<StatePair> newStates) {
        this.fStates = newStates;
    }

    public void addTransitions(List<PairTransition> newTransitions) {
        this.fTransitions = newTransitions;
    }

    public void setStart(StatePair newStartPair) {
        this.fStartPair = newStartPair;
    }

    public StatePair getStartPair() {
        return this.fStartPair;
    }

    public List<StatePair> getStates() {
        return this.fStates;
    }

    public Set<Action> getInputs() {
        return this.fInputs;
    }

    public Set<Action> getInternals() {
        return this.fInternals;
    }

    public Set<Action> getOutputs() {
        return this.fOutputs;
    }

    public List<PairTransition> getTransitions() {
        return this.fTransitions;
    }

    public List<PairTransition> getTransitionsStartingFrom(StatePair statePair1) {
        ArrayList<PairTransition> transes = new ArrayList<PairTransition>();
        for (PairTransition trans : this.fTransitions) {
            if (!trans.getFrom().equals(statePair1)) continue;
            transes.add(trans);
        }
        return transes;
    }

    public void prune() {
        ArrayList<StatePair> toCheck = new ArrayList<StatePair>();
        toCheck.add(this.getStartPair());
        ArrayList<StatePair> newList = new ArrayList<StatePair>();
        while (!toCheck.isEmpty()) {
            ArrayList<StatePair> newToCheck = new ArrayList<StatePair>();
            for (StatePair statePair : toCheck) {
                if (newList.contains(statePair)) continue;
                newList.add(statePair);
                List<PairTransition> transitionsStartingFrom = this.getTransitionsStartingFrom(statePair);
                for (PairTransition pairTransition : transitionsStartingFrom) {
                    newToCheck.add(pairTransition.getTo());
                }
            }
            toCheck = newToCheck;
        }
        this.fStates = newList;
        Iterator<PairTransition> i = this.fTransitions.iterator();
        while (i.hasNext()) {
            PairTransition pairTrans = i.next();
            if (this.fStates.contains(pairTrans.getFrom()) && this.fStates.contains(pairTrans.getTo())) continue;
            i.remove();
        }
    }
}

