/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.workbench.operations.contracts;

import java.util.Collection;
import java.util.LinkedList;
import net.miowb.common.MioHelpers;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.miocontract.MiocontractFactory;
import net.miowb.model.miocontract.ModalIOContract;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.OperationManager;
import net.miowb.workbench.operations.result.CompatibilityResult;

public class ContractHelpers {
    public static ModalIOContract getReducedContract(ModalIOContract c) throws MioException {
        ModalIOAutomaton result;
        ModalIOAutomaton a2;
        ModalIOAutomaton a1;
        if (c.getEnvironments().size() == 0 || c.getSpecifications().size() == 0) {
            throw new MioException("Contract needs at least one specification and environment");
        }
        LinkedList<ModalIOAutomaton> specs = new LinkedList<ModalIOAutomaton>((Collection<ModalIOAutomaton>)c.getSpecifications());
        LinkedList<ModalIOAutomaton> envs = new LinkedList<ModalIOAutomaton>((Collection<ModalIOAutomaton>)c.getEnvironments());
        while (specs.size() > 1) {
            a1 = (ModalIOAutomaton)specs.remove();
            result = OperationManager.conjoin(a1, a2 = (ModalIOAutomaton)specs.remove());
            if (result == null) {
                throw new MioException("Problems during conjunction of " + a1.getName() + " and " + a2.getName());
            }
            specs.addFirst(result);
        }
        while (envs.size() > 1) {
            a1 = (ModalIOAutomaton)envs.remove();
            result = OperationManager.conjoin(a1, a2 = (ModalIOAutomaton)envs.remove());
            if (result == null) {
                throw new MioException("Problems during conjunction of " + a1.getName() + " and " + a2.getName());
            }
            envs.addFirst(result);
        }
        ModalIOAutomaton env = MioHelpers.copy((ModalIOAutomaton)((ModalIOAutomaton)envs.remove()));
        ModalIOAutomaton spec = MioHelpers.copy((ModalIOAutomaton)((ModalIOAutomaton)specs.remove()));
        CompatibilityResult comp = OperationManager.getOperations().checkStrongEnvironmentCorrectness(spec, env);
        switch (comp.getResultType()) {
            case ERROR: {
                throw new MioException("Assumption is not a strongly correct environment of guarantee.");
            }
            case MISMATCHING_ACTIONS: {
                throw new MioException("Assumpion and guarantee are not composable.");
            }
        }
        ModalIOContract cr = MiocontractFactory.eINSTANCE.createModalIOContract();
        cr.setName(c.getName());
        env.setName(String.valueOf(c.getName()) + ".env");
        spec.setName(String.valueOf(c.getName()) + ".spec");
        cr.getEnvironments().add((Object)env);
        cr.getSpecifications().add((Object)spec);
        return cr;
    }
}

