/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.workbench.operations;

import java.util.ArrayList;
import java.util.List;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.workbench.MioWorkbenchPlugin;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.IMioBinaryCompatibilityOperation;
import net.miowb.workbench.operations.IMioOperation;
import net.miowb.workbench.operations.IMioOperations;
import net.miowb.workbench.operations.IMioRefinementOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;

public class OperationManager {
    private static final String REFINEMENT_EXTENSION_POINT = "net.miowb.workbench.refinement";
    private static final String COMPATIBILITY_EXTENSION_POINT = "net.miowb.workbench.compatibility";
    private static final String OPERATIONS_EXTENSION_POINT = "net.miowb.workbench.operations";
    private static List<IMioRefinementOperation> fRefinements = new ArrayList<IMioRefinementOperation>();
    private static List<IMioBinaryCompatibilityOperation> fCompatibility = new ArrayList<IMioBinaryCompatibilityOperation>();
    public static IMioOperations fOperations;
    private static boolean fIsInitialized;

    static {
        fIsInitialized = false;
    }

    public static void initialize() {
        OperationManager.loadExtensions(REFINEMENT_EXTENSION_POINT);
        OperationManager.loadExtensions(COMPATIBILITY_EXTENSION_POINT);
        OperationManager.loadExtensions(OPERATIONS_EXTENSION_POINT);
        fIsInitialized = true;
    }

    private static void loadExtensions(String extensionPointID) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointID);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (REFINEMENT_EXTENSION_POINT.equals(extensionPointID)) {
                    OperationManager.loadMioOperation(elements[j], fRefinements, IMioRefinementOperation.class);
                }
                if (COMPATIBILITY_EXTENSION_POINT.equals(extensionPointID)) {
                    OperationManager.loadMioOperation(elements[j], fCompatibility, IMioBinaryCompatibilityOperation.class);
                }
                if (OPERATIONS_EXTENSION_POINT.equals(extensionPointID)) {
                    OperationManager.loadMioOperations(elements[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    public static <T extends IMioOperation> void loadMioOperations(IConfigurationElement e) {
        IContributor contributor;
        String clazz = e.getAttribute("class");
        if (!OperationManager.checkEmpty(clazz, contributor = e.getContributor(), "Mio Operation Class")) {
            return;
        }
        try {
            Object c = e.createExecutableExtension("class");
            if (IMioOperations.class.isAssignableFrom(c.getClass())) {
                fOperations = (IMioOperations)IMioOperations.class.cast(c);
            } else {
                MioWorkbenchPlugin.logWarning("Sorry, Mio operation class " + clazz + " could not be loaded. The implementing class could not be cast to the target.");
            }
        }
        catch (CoreException e1) {
            MioWorkbenchPlugin.logError(e1);
            MioWorkbenchPlugin.logWarning("Sorry, Mio operation class " + clazz + " could not be loaded. The implementing class could not be instantiated.");
            return;
        }
    }

    public static <T extends IMioOperation> void loadMioOperation(IConfigurationElement e, List<T> listToFill, Class<T> classOfList) {
        IContributor contributor;
        String clazz = e.getAttribute("class");
        if (!OperationManager.checkEmpty(clazz, contributor = e.getContributor(), "Mio Operation Class")) {
            return;
        }
        try {
            Object c = e.createExecutableExtension("class");
            if (classOfList.isAssignableFrom(c.getClass())) {
                listToFill.add((IMioOperation)classOfList.cast(c));
            } else {
                MioWorkbenchPlugin.logWarning("Sorry, Mio operation class " + clazz + " could not be loaded. The implementing class could not be cast to the target.");
            }
        }
        catch (CoreException e1) {
            MioWorkbenchPlugin.logError(e1);
            MioWorkbenchPlugin.logWarning("Sorry, Mio operation class " + clazz + " could not be loaded. The implementing class could not be instantiated.");
            return;
        }
    }

    private static boolean checkEmpty(String value, IContributor contributor, String string) {
        if (value == null || value.isEmpty()) {
            MioWorkbenchPlugin.logWarning("Error reading Sensoria Core extension information from plugin.xml files - required attribute is missing: " + string + " (contributor: " + contributor.getName() + ").");
            return false;
        }
        return true;
    }

    public static List<IMioRefinementOperation> getRefinements() {
        if (!fIsInitialized) {
            OperationManager.initialize();
        }
        return fRefinements;
    }

    public static IMioRefinementOperation getRefinement(String name) throws MioException {
        if (!fIsInitialized) {
            OperationManager.initialize();
        }
        for (IMioRefinementOperation op : fRefinements) {
            if (!op.getName().equals(name)) continue;
            return op;
        }
        throw new MioException(String.valueOf(name) + " not found!");
    }

    public static List<IMioBinaryCompatibilityOperation> getCompatibilities() {
        if (!fIsInitialized) {
            OperationManager.initialize();
        }
        return fCompatibility;
    }

    public static IMioBinaryCompatibilityOperation getCompatibility(String name) throws MioException {
        if (!fIsInitialized) {
            OperationManager.initialize();
        }
        for (IMioBinaryCompatibilityOperation op : fCompatibility) {
            if (!op.getName().equals(name)) continue;
            return op;
        }
        throw new MioException(String.valueOf(name) + " not found!");
    }

    public static IMioOperations getOperations() {
        if (!fIsInitialized) {
            OperationManager.initialize();
        }
        return fOperations;
    }

    public static ModalIOAutomaton conjoin(ModalIOAutomaton left, ModalIOAutomaton right) throws MioException {
        IMioOperations ops = OperationManager.getOperations();
        return ops.conjoin(left, right);
    }

    public static ModalIOAutomaton weaken(ModalIOAutomaton env, ModalIOAutomaton spec) throws MioException {
        IMioOperations ops = OperationManager.getOperations();
        return ops.weaken(env, spec);
    }
}

