/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.workbench.diagrams;

import java.util.ArrayList;
import java.util.List;
import net.miowb.workbench.MioWorkbenchPlugin;
import net.miowb.workbench.diagrams.IMioDiagrams;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.RegistryFactory;

public class DiagramManager {
    private static final String DIAGRAM_EXTENSION_POINT = "net.miowb.workbench.diagram";
    private static List<IMioDiagrams> fDiagrams = new ArrayList<IMioDiagrams>();
    private static boolean fIsInitialized = false;

    public static void initialize() {
        DiagramManager.loadExtensions(DIAGRAM_EXTENSION_POINT);
        fIsInitialized = true;
    }

    private static void loadExtensions(String extensionPointID) {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(extensionPointID);
        IExtension[] extensions = extensionPoint.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                if (DIAGRAM_EXTENSION_POINT.equals(extensionPointID)) {
                    DiagramManager.loadMioOperation(elements[j], fDiagrams, IMioDiagrams.class);
                }
                ++j;
            }
            ++i;
        }
    }

    public static <T extends IMioDiagrams> void loadMioOperation(IConfigurationElement e, List<T> listToFill, Class<T> classOfList) {
        IContributor contributor;
        String clazz = e.getAttribute("class");
        if (!DiagramManager.checkEmpty(clazz, contributor = e.getContributor(), "Mio Operation Class")) {
            return;
        }
        try {
            Object c = e.createExecutableExtension("class");
            if (classOfList.isAssignableFrom(c.getClass())) {
                listToFill.add((IMioDiagrams)classOfList.cast(c));
            } else {
                MioWorkbenchPlugin.logWarning("Sorry, Mio operation class " + clazz + " could not be loaded. The implementing class could not be cast to the target.");
            }
        }
        catch (CoreException e1) {
            MioWorkbenchPlugin.logError(e1);
            MioWorkbenchPlugin.logWarning("Sorry, Mio operation class " + clazz + " could not be loaded. The implementing class could not be instantiated.");
            return;
        }
    }

    private static boolean checkEmpty(String value, IContributor contributor, String string) {
        if (value == null || value.isEmpty()) {
            MioWorkbenchPlugin.logWarning("Error reading Sensoria Core extension information from plugin.xml files - required attribute is missing: " + string + " (contributor: " + contributor.getName() + ").");
            return false;
        }
        return true;
    }

    public static List<IMioDiagrams> getDiagrams() {
        if (!fIsInitialized) {
            DiagramManager.initialize();
        }
        return fDiagrams;
    }
}

