/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.workbench.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.OutputAction;
import net.miowb.model.mio.State;
import net.miowb.workbench.operations.model.RefinementRelation;
import net.miowb.workbench.operations.model.SingleActionPath;
import net.miowb.workbench.operations.model.StatePair;

public class PrettyPrinting {
    public static String pp(Action a) {
        String postfix = "";
        if (a instanceof InputAction) {
            postfix = "?";
        }
        if (a instanceof OutputAction) {
            postfix = "!";
        }
        return String.valueOf(a.getLabel()) + postfix;
    }

    public static String pp(List<Action> act) {
        String result = "";
        for (Action a : act) {
            result = String.valueOf(result) + "  " + PrettyPrinting.pp(a) + "\n";
        }
        return result;
    }

    public static String pp(ModalIOAutomaton m) {
        String result = "Name: " + m.getName() + "\nActions:\n";
        result = String.valueOf(result) + PrettyPrinting.pp(m.getActions());
        result = String.valueOf(result) + "States: ";
        for (State s : m.getStates()) {
            result = String.valueOf(result) + s.getLabel() + " ";
        }
        result = String.valueOf(result) + "\n";
        result = String.valueOf(result) + "Initial state: " + (m.getStart() == null ? "" : m.getStart().getLabel()) + "\n";
        result = String.valueOf(result) + "Transitions:\n";
        for (MayTransition t : m.getMayTransitions()) {
            result = String.valueOf(result) + "  May " + PrettyPrinting.pp(t.getAction()) + " : " + t.getFrom().getLabel() + " ---> " + t.getTo().getLabel() + "\n";
        }
        for (MayTransition t : m.getMustTransitions()) {
            result = String.valueOf(result) + "  Must " + PrettyPrinting.pp(t.getAction()) + " : " + t.getFrom().getLabel() + " ---> " + t.getTo().getLabel() + "\n";
        }
        if (result.endsWith("\n")) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static String ws(int i) {
        if (i >= 0) {
            String result = "";
            int j = 0;
            while (j == i) {
                result = String.valueOf(result) + " ";
                ++j;
            }
            return result;
        }
        return "";
    }

    public static String pp(RefinementRelation rel) {
        String resultMessage = "{";
        ArrayList<StatePair> sortedlist = new ArrayList<StatePair>(rel.getStatePairs());
        Collections.reverse(sortedlist);
        for (StatePair p : sortedlist) {
            p.switchStates();
            resultMessage = String.valueOf(resultMessage) + p.getLabel() + ",";
        }
        if (resultMessage.endsWith(",")) {
            resultMessage = resultMessage.substring(0, resultMessage.length() - 1);
        }
        resultMessage = String.valueOf(resultMessage) + "}";
        return resultMessage;
    }

    public static String pp(SingleActionPath path) {
        return path.toNiceString();
    }

    public static String ppstates(List<State> l) {
        String resultMessage = "{";
        for (State s : l) {
            resultMessage = String.valueOf(resultMessage) + s.getLabel() + ",";
        }
        if (resultMessage.endsWith(",")) {
            resultMessage = resultMessage.substring(0, resultMessage.length() - 1);
        }
        resultMessage = String.valueOf(resultMessage) + "}";
        return resultMessage;
    }

    public static String ppSetOfSwitchedStatePairs(Set<StatePair> set) {
        String resultMessage = "{";
        for (StatePair s : set) {
            resultMessage = String.valueOf(resultMessage) + "(" + s.getS2().getLabel() + "," + s.getS1().getLabel() + "),";
        }
        if (resultMessage.endsWith(",")) {
            resultMessage = resultMessage.substring(0, resultMessage.length() - 1);
        }
        resultMessage = String.valueOf(resultMessage) + "}";
        return resultMessage;
    }

    public static String ppListOfMios(List<ModalIOAutomaton> mios) {
        return PrettyPrinting.ppMIOs(mios);
    }

    private static String removeLastChar(String s) {
        return s.substring(0, s.length() - 1);
    }

    public static String ppMIOs(List<ModalIOAutomaton> mios) {
        String result = "[ ";
        for (ModalIOAutomaton mio : mios) {
            result = String.valueOf(result) + mio.getName() + " , ";
        }
        return String.valueOf(PrettyPrinting.removeLastChar(PrettyPrinting.removeLastChar(result))) + "]";
    }
}

