/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.miowb.common.MioEMFFactory;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.CommunicationAction;
import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.InternalAction;
import net.miowb.model.mio.MioFactory;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.OutputAction;
import net.miowb.model.mio.State;

public class SignatureHelper {
    public static List<String> calculateConflictingActionsForComposition(ModalIOAutomaton t1, ModalIOAutomaton t2) {
        List<String> Act1 = SignatureHelper.getLabels(t1.getActions(), ActionType.ANY);
        List<String> Act2 = SignatureHelper.getLabels(t2.getActions(), ActionType.ANY);
        ArrayList<String> intersection = new ArrayList<String>();
        for (String a : Act1) {
            if (!Act2.contains(a)) continue;
            intersection.add(a);
        }
        ArrayList<String> conflictingActionLabels = new ArrayList<String>();
        for (String a : intersection) {
            if (SignatureHelper.getAction(t1, a) instanceof InputAction && SignatureHelper.getAction(t2, a) instanceof OutputAction || SignatureHelper.getAction(t1, a) instanceof OutputAction && SignatureHelper.getAction(t2, a) instanceof InputAction) continue;
            conflictingActionLabels.add(a);
        }
        return conflictingActionLabels;
    }

    public static Map<String, Action> addNewActions(ModalIOAutomaton mio, List<String> new_inputs, List<String> new_outputs, List<String> new_internals, List<String> new_communications) {
        HashMap<String, Action> map = new HashMap<String, Action>();
        for (String a : new_inputs) {
            InputAction new_input_action = MioEMFFactory.createInput(mio, a);
            map.put(a, (Action)new_input_action);
        }
        for (String a : new_outputs) {
            OutputAction new_output_action = MioEMFFactory.createOutput(mio, a);
            map.put(a, (Action)new_output_action);
        }
        for (String a : new_internals) {
            InternalAction new_internal_action = MioEMFFactory.createInternal(mio, a);
            map.put(a, (Action)new_internal_action);
        }
        for (String a : new_communications) {
            CommunicationAction new_communication_action = MioEMFFactory.createCommunication(mio, a);
            map.put(a, (Action)new_communication_action);
        }
        return map;
    }

    public static boolean isActionOf(ModalIOAutomaton mio, String label) {
        for (Action a : mio.getActions()) {
            if (!a.getLabel().equals(label)) continue;
            return true;
        }
        return false;
    }

    public static List<String> calculateConflictingActionsForConjunction(ModalIOAutomaton mio1, ModalIOAutomaton mio2) {
        List<String> Act1 = SignatureHelper.getLabels(mio1.getActions(), ActionType.ANY);
        List<String> Act2 = SignatureHelper.getLabels(mio2.getActions(), ActionType.ANY);
        ArrayList<String> intersection = new ArrayList<String>();
        for (String a : Act1) {
            if (!Act2.contains(a)) continue;
            intersection.add(a);
        }
        ArrayList<String> conflictingActionLabels = new ArrayList<String>();
        for (String a : intersection) {
            if (!(SignatureHelper.getAction(mio1, a).isInput() && !SignatureHelper.getAction(mio2, a).isInput() || SignatureHelper.getAction(mio1, a).isOutput() && !SignatureHelper.getAction(mio2, a).isOutput()) && (!SignatureHelper.getAction(mio1, a).isCommunication() || SignatureHelper.getAction(mio2, a).isCommunication())) continue;
            conflictingActionLabels.add(a);
        }
        return conflictingActionLabels;
    }

    public static List<String> getSetOfLabels(Collection<? extends Action> c) {
        ArrayList<String> result = new ArrayList<String>();
        for (Action action : c) {
            result.add(action.getLabel());
        }
        return result;
    }

    public static boolean contains(ModalIOAutomaton s, Action a) {
        return SignatureHelper.getSetOfLabels(s.getActions()).contains(a.getLabel());
    }

    public static boolean contains(ModalIOAutomaton s, String l) {
        return SignatureHelper.getSetOfLabels(s.getActions()).contains(l);
    }

    public static Action signature_isSupersetOf(ModalIOAutomaton concreteMio, ModalIOAutomaton abstractMio) {
        for (InputAction inp : concreteMio.getInputs()) {
            if (!SignatureHelper.isOutputActionOf(abstractMio, inp.getLabel()) && !SignatureHelper.isInternalActionOf(abstractMio, inp.getLabel())) continue;
            return inp;
        }
        for (OutputAction outp : concreteMio.getOutputs()) {
            if (!SignatureHelper.isInputActionOf(abstractMio, outp.getLabel()) && !SignatureHelper.isInternalActionOf(abstractMio, outp.getLabel())) continue;
            return outp;
        }
        for (InternalAction internal : concreteMio.getInternals()) {
            if (!SignatureHelper.isInputActionOf(abstractMio, internal.getLabel()) && !SignatureHelper.isOutputActionOf(abstractMio, internal.getLabel())) continue;
            return internal;
        }
        return null;
    }

    private static boolean isOutputActionOf(ModalIOAutomaton abstractMio, String label) {
        for (OutputAction act : abstractMio.getOutputs()) {
            if (!act.getLabel().equals(label)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInputActionOf(ModalIOAutomaton abstractMio, String label) {
        for (InputAction act : abstractMio.getInputs()) {
            if (!act.getLabel().equals(label)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInternalActionOf(ModalIOAutomaton abstractMio, String label) {
        for (InternalAction act : abstractMio.getInternals()) {
            if (!act.getLabel().equals(label)) continue;
            return true;
        }
        return false;
    }

    public static List<Action> actions_notInRHS(ModalIOAutomaton implementation, ModalIOAutomaton protocol) {
        ArrayList<Action> actions = new ArrayList<Action>();
        for (Action a : implementation.getActions()) {
            if (SignatureHelper.contains(protocol, a.getLabel())) continue;
            actions.add(a);
        }
        return actions;
    }

    public static Map<Action, Action> copyActionAlphabet(ModalIOAutomaton source, ModalIOAutomaton target) {
        LinkedHashMap<Action, Action> map = new LinkedHashMap<Action, Action>();
        for (Action action : source.getActions()) {
            InputAction newAction = null;
            if (action instanceof InputAction) {
                newAction = MioFactory.eINSTANCE.createInputAction();
                target.getInputs().add((Object)newAction);
            }
            if (action instanceof OutputAction) {
                newAction = MioFactory.eINSTANCE.createOutputAction();
                target.getOutputs().add((Object)((OutputAction)newAction));
            }
            if (action instanceof InternalAction) {
                newAction = MioFactory.eINSTANCE.createInternalAction();
                target.getInternals().add((Object)((InternalAction)newAction));
            }
            if (action instanceof CommunicationAction) {
                newAction = MioFactory.eINSTANCE.createCommunicationAction();
                target.getCommunications().add((Object)((CommunicationAction)newAction));
            }
            newAction.setLabel(action.getLabel());
            map.put(action, (Action)newAction);
        }
        return map;
    }

    public static Map<Action, Action> sensitiveCopyActionAlphabet(ModalIOAutomaton source, ModalIOAutomaton target) {
        LinkedHashMap<Action, Action> map = new LinkedHashMap<Action, Action>();
        for (Action action : source.getActions()) {
            InputAction newAction = null;
            if (action instanceof InputAction && !SignatureHelper.contains(target, action)) {
                newAction = MioFactory.eINSTANCE.createInputAction();
                target.getInputs().add((Object)newAction);
            }
            if (action instanceof OutputAction && !SignatureHelper.contains(target, action)) {
                newAction = MioFactory.eINSTANCE.createOutputAction();
                target.getOutputs().add((Object)((OutputAction)newAction));
            }
            if (action instanceof InternalAction && !SignatureHelper.contains(target, action)) {
                newAction = MioFactory.eINSTANCE.createInternalAction();
                target.getInternals().add((Object)((InternalAction)newAction));
            }
            if (action instanceof CommunicationAction && !SignatureHelper.contains(target, action)) {
                newAction = MioFactory.eINSTANCE.createCommunicationAction();
                target.getCommunications().add((Object)((CommunicationAction)newAction));
            }
            newAction.setLabel(action.getLabel());
            map.put(action, (Action)newAction);
        }
        return map;
    }

    public static List<String> getLabels(List<Action> actions, ActionType type) {
        ArrayList<String> result = new ArrayList<String>();
        for (Action a : actions) {
            if (type == ActionType.ANY) {
                result.add(a.getLabel());
                continue;
            }
            if (type == ActionType.EXTERNAL && (a instanceof InputAction || a instanceof OutputAction)) {
                result.add(a.getLabel());
                continue;
            }
            if (type == ActionType.INPUT && a instanceof InputAction) {
                result.add(a.getLabel());
                continue;
            }
            if (type == ActionType.OUTPUT && a instanceof OutputAction) {
                result.add(a.getLabel());
                continue;
            }
            if (type == ActionType.INTERNAL && a instanceof InternalAction) {
                result.add(a.getLabel());
                continue;
            }
            if (type != ActionType.COMMUNICATION || !(a instanceof CommunicationAction)) continue;
            result.add(a.getLabel());
        }
        return result;
    }

    public static String prettyPringActions(List<Action> actions) {
        String result = "";
        for (String s : SignatureHelper.getLabels(actions, ActionType.INPUT)) {
            result = String.valueOf(result) + s + "? ";
        }
        for (String s : SignatureHelper.getLabels(actions, ActionType.OUTPUT)) {
            result = String.valueOf(result) + s + "! ";
        }
        for (String s : SignatureHelper.getLabels(actions, ActionType.INTERNAL)) {
            result = String.valueOf(result) + s + "; ";
        }
        return result;
    }

    public static Action getAction(ModalIOAutomaton m, String label) {
        for (Action a : m.getActions()) {
            if (!a.getLabel().equals(label)) continue;
            return a;
        }
        return null;
    }

    public static Action getAction(Collection<? extends Action> actions, String label) {
        for (Action action : actions) {
            if (!action.getLabel().equals(label)) continue;
            return action;
        }
        return null;
    }

    public static String getActionTypeString(ModalIOAutomaton m, String s) {
        for (Action a : m.getActions()) {
            if (!a.getLabel().equals(s)) continue;
            if (a instanceof InputAction) {
                return "input";
            }
            if (a instanceof OutputAction) {
                return "output";
            }
            if (a instanceof InternalAction) {
                return "internal";
            }
            if (!(a instanceof CommunicationAction)) continue;
            return "communication";
        }
        return null;
    }

    public static State getStateByString(ModalIOAutomaton mio, String s) {
        for (State state : mio.getStates()) {
            if (!state.getLabel().equals(s)) continue;
            return state;
        }
        return null;
    }

    public static enum ActionType {
        INPUT,
        OUTPUT,
        INTERNAL,
        COMMUNICATION,
        ANY,
        EXTERNAL,
        NON_INTERNAL;

    }
}

