/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.common;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.miowb.common.SignatureHelper;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.MioFactory;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import org.eclipse.emf.common.util.EList;

public class MioHelpers {
    public static void renameStates(ModalIOAutomaton mio) {
        ArrayList<State> to_be_renamed = new ArrayList<State>();
        ArrayList<State> renamed = new ArrayList<State>();
        int counter = 0;
        to_be_renamed.add(mio.getStart());
        while (to_be_renamed.size() > 0) {
            State s = (State)to_be_renamed.remove(0);
            renamed.add(s);
            s.setLabel(Integer.toString(counter));
            ++counter;
            EList t = s.getOutgoing();
            for (Transition trans : t) {
                if (renamed.contains(trans.getTo()) || to_be_renamed.contains(trans.getTo())) continue;
                to_be_renamed.add(trans.getTo());
            }
        }
    }

    public static ModalIOAutomaton copy(ModalIOAutomaton orig) {
        ModalIOAutomaton copy = MioFactory.eINSTANCE.createModalIOAutomaton();
        copy.setName(orig.getName());
        Map<Action, Action> actionmap = SignatureHelper.copyActionAlphabet(orig, copy);
        Map<State, State> statemap = MioHelpers.copyStates(orig, copy);
        MioHelpers.copyMayTransition(orig, copy, actionmap, statemap);
        MioHelpers.copyMustTransition(orig, copy, actionmap, statemap);
        copy.setStart(statemap.get(orig.getStart()));
        return copy;
    }

    public static Map<State, State> copyStates(ModalIOAutomaton source, ModalIOAutomaton target) {
        LinkedHashMap<State, State> map = new LinkedHashMap<State, State>();
        for (State s : source.getStates()) {
            State newState = null;
            newState = MioFactory.eINSTANCE.createState();
            target.getStates().add((Object)newState);
            newState.setLabel(s.getLabel());
            map.put(s, newState);
        }
        return map;
    }

    public static void copyMustTransition(ModalIOAutomaton source, ModalIOAutomaton target, Map<Action, Action> actionmap, Map<State, State> statemap) {
        for (MustTransition t : source.getMustTransitions()) {
            MustTransition newTrans = MioFactory.eINSTANCE.createMustTransition();
            newTrans.setAction(actionmap.get(t.getAction()));
            newTrans.setFrom(statemap.get(t.getFrom()));
            newTrans.setTo(statemap.get(t.getTo()));
            target.getMustTransitions().add((Object)newTrans);
        }
    }

    public static void copyMayTransition(ModalIOAutomaton source, ModalIOAutomaton target, Map<Action, Action> actionmap, Map<State, State> statemap) {
        for (MayTransition t : source.getMayTransitions()) {
            MayTransition newTrans = MioFactory.eINSTANCE.createMayTransition();
            newTrans.setAction(actionmap.get(t.getAction()));
            newTrans.setFrom(statemap.get(t.getFrom()));
            newTrans.setTo(statemap.get(t.getTo()));
            target.getMayTransitions().add((Object)newTrans);
        }
    }
}

