/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.common;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import net.miowb.common.CommonPlugin;
import net.miowb.model.mio.MioPackage;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.miocontract.ModalIOContract;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLContentHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceFactoryImpl;

public class MioEMFHelper {
    public static void store(IFile file, ModalIOAutomaton prune, EObject diagram) throws Exception {
        URI inputURI = MioEMFHelper.convertToURI(file);
        MioEMFHelper.store(inputURI, prune, diagram);
    }

    public static void store(File file, ModalIOAutomaton prune, EObject diagram) throws Exception {
        URI inputURI = MioEMFHelper.convertToURI(file);
        MioEMFHelper.store(inputURI, prune, diagram);
    }

    public static void store(IFile file, ModalIOContract contract) throws Exception {
        URI outputURI = MioEMFHelper.convertToURI(file);
        MioEMFHelper.store(outputURI, contract);
    }

    public static ModalIOAutomaton load(File file) throws IOException {
        URI inputURI = MioEMFHelper.convertToURI(file);
        return MioEMFHelper.load(inputURI);
    }

    public static ModalIOAutomaton load(IFile file) throws IOException {
        URI inputURI = MioEMFHelper.convertToURI(file);
        return MioEMFHelper.load(inputURI);
    }

    public static ModalIOAutomaton load(URI inputURI) throws IOException {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        MioEMFHelper.handleHeadless((ResourceSet)resourceSet);
        XMIResource xmlResource = (XMIResource)resourceSet.getResource(inputURI, true);
        if (xmlResource == null) {
            throw new IOException("Could not read automaton from " + inputURI + ". Resource is null.");
        }
        EList contents = xmlResource.getContents();
        if (contents.isEmpty()) {
            throw new IOException("Could not read automaton from " + inputURI + ". Resource is empty.");
        }
        EObject eObject = (EObject)contents.get(0);
        if (!(eObject instanceof ModalIOAutomaton)) {
            throw new IOException("Could not read automaton from " + inputURI + ". Object in Resource is not of type ModalIOAutomaton.");
        }
        return (ModalIOAutomaton)eObject;
    }

    private static void store(URI inputURI, ModalIOAutomaton automaton, EObject diagram) throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        MioEMFHelper.handleHeadless((ResourceSet)resourceSet);
        XMIResource xmlResource = (XMIResource)resourceSet.createResource(inputURI);
        xmlResource.getContents().add((Object)automaton);
        xmlResource.getContents().add((Object)diagram);
        try {
            HashMap<String, String> options = new HashMap<String, String>(2);
            options.put("ENCODING", "ASCII");
            xmlResource.save(options);
        }
        catch (IOException e) {
            throw new Exception("Unable to write XMI file: " + e.getMessage(), e);
        }
    }

    private static void store(URI outputURI, ModalIOContract contract) throws Exception {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        MioEMFHelper.handleHeadless((ResourceSet)resourceSet);
        XMIResource xmlResource = (XMIResource)resourceSet.createResource(outputURI);
        xmlResource.getContents().add((Object)contract);
        try {
            HashMap<String, String> options = new HashMap<String, String>(2);
            options.put("ENCODING", "ASCII");
            xmlResource.save(options);
        }
        catch (IOException e) {
            throw new Exception("Unable to write XMI file: " + e.getMessage(), e);
        }
    }

    private static void handleHeadless(ResourceSet resourceSet) {
        if (CommonPlugin.getDefault() == null || CommonPlugin.getDefault().getBundle() == null) {
            resourceSet.getPackageRegistry().put((Object)"http://www.miowb.net/model", (Object)MioPackage.eINSTANCE);
            resourceSet.getResourceFactoryRegistry().getContentTypeToFactoryMap().put("org.eclipse.emf.ecore:contentType", new XMLContentHandlerImpl());
            Resource.Factory.Registry registry = resourceSet.getResourceFactoryRegistry();
            registry.getExtensionToFactoryMap().put("ecore", new EcoreResourceFactoryImpl());
            registry.getExtensionToFactoryMap().put("xml", new XMLResourceFactoryImpl());
            registry.getExtensionToFactoryMap().put("xmi", new XMIResourceFactoryImpl());
            registry.getExtensionToFactoryMap().put("mio", new XMIResourceFactoryImpl());
        }
    }

    protected static URI convertToURI(Object file) {
        URI fileURI = null;
        fileURI = file instanceof IFile ? URI.createFileURI((String)((IFile)file).getLocation().toString()) : URI.createFileURI((String)((File)file).getAbsolutePath());
        return fileURI;
    }
}

