/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.common;

import net.miowb.model.mio.Action;
import net.miowb.model.mio.CommunicationAction;
import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.InternalAction;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.MioFactory;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.OutputAction;
import net.miowb.model.mio.State;
import org.eclipse.emf.common.util.EList;

public class MioEMFFactory {
    public static final String LOOP_LABEL = "LOOP";
    private static final MioFactory FACTORY = MioFactory.eINSTANCE;

    public static State createState(ModalIOAutomaton t, String name) {
        State state = FACTORY.createState();
        state.setLabel(name);
        t.getStates().add((Object)state);
        return state;
    }

    public static InternalAction getLoop(ModalIOAutomaton t) {
        EList internals = t.getInternals();
        for (InternalAction internalAction : internals) {
            if (!internalAction.getLabel().equals(LOOP_LABEL)) continue;
            return internalAction;
        }
        InternalAction action = MioEMFFactory.createInternal(LOOP_LABEL);
        t.getInternals().add((Object)action);
        return action;
    }

    public static ModalIOAutomaton createAutomaton(String string) {
        ModalIOAutomaton mio = FACTORY.createModalIOAutomaton();
        mio.setName(string);
        return mio;
    }

    public static ModalIOAutomaton createSTOPAutomaton() {
        ModalIOAutomaton mio = FACTORY.createModalIOAutomaton();
        mio.setName("STOP");
        State s = MioEMFFactory.createState(mio, "STOP");
        mio.setStart(s);
        return mio;
    }

    public static void createTauTransition(ModalIOAutomaton automaton, State from, State to) {
        MustTransition t = FACTORY.createMustTransition();
        InternalAction tau = MioEMFFactory.createInternal("TAU");
        t.setAction((Action)tau);
        t.setFrom(from);
        t.setTo(to);
        automaton.getInternals().add((Object)tau);
        automaton.getMustTransitions().add((Object)t);
    }

    public static void createLoopBackTransition(ModalIOAutomaton automaton, State from, State to) {
        MustTransition t = FACTORY.createMustTransition();
        t.setAction((Action)MioEMFFactory.getLoop(automaton));
        t.setFrom(from);
        t.setTo(to);
        automaton.getMustTransitions().add((Object)t);
    }

    public static void createInternalMustTransition(ModalIOAutomaton automaton, String label, State from, State to) {
        InternalAction internalAction = FACTORY.createInternalAction();
        internalAction.setLabel(label);
        automaton.getInternals().add((Object)internalAction);
        MustTransition t = FACTORY.createMustTransition();
        t.setAction((Action)internalAction);
        t.setFrom(from);
        t.setTo(to);
        automaton.getMustTransitions().add((Object)t);
    }

    public static MustTransition createMustTransition() {
        return FACTORY.createMustTransition();
    }

    public static MustTransition createMustTransition(ModalIOAutomaton mio) {
        MustTransition t = FACTORY.createMustTransition();
        mio.getMustTransitions().add((Object)t);
        return t;
    }

    public static OutputAction createOutput(String name) {
        OutputAction action = FACTORY.createOutputAction();
        action.setLabel(name);
        return action;
    }

    public static InputAction createInput(String name) {
        InputAction action = FACTORY.createInputAction();
        action.setLabel(name);
        return action;
    }

    public static InternalAction createInternal(String string) {
        InternalAction action = FACTORY.createInternalAction();
        action.setLabel(string);
        return action;
    }

    public static CommunicationAction createCommunication(String string) {
        CommunicationAction action = FACTORY.createCommunicationAction();
        action.setLabel(string);
        return action;
    }

    public static MayTransition createMayTransition() {
        return FACTORY.createMayTransition();
    }

    public static MayTransition createMayTransition(ModalIOAutomaton mio) {
        MayTransition t = FACTORY.createMayTransition();
        mio.getMayTransitions().add((Object)t);
        return t;
    }

    public static InputAction createInput(ModalIOAutomaton newTom, String string) {
        InputAction in = MioEMFFactory.createInput(string);
        newTom.getInputs().add((Object)in);
        return in;
    }

    public static OutputAction createOutput(ModalIOAutomaton newTom, String string) {
        OutputAction out = MioEMFFactory.createOutput(string);
        newTom.getOutputs().add((Object)out);
        return out;
    }

    public static InternalAction createInternal(ModalIOAutomaton newTom, String string) {
        InternalAction intt = MioEMFFactory.createInternal(string);
        newTom.getInternals().add((Object)intt);
        return intt;
    }

    public static CommunicationAction createCommunication(ModalIOAutomaton newTom, String string) {
        CommunicationAction act = MioEMFFactory.createCommunication(string);
        newTom.getCommunications().add((Object)act);
        return act;
    }

    public static MustTransition createEpsilonTransition(State start, State start2) {
        MustTransition mustTransition = MioFactory.eINSTANCE.createMustTransition();
        InternalAction inte = MioFactory.eINSTANCE.createInternalAction();
        inte.setLabel("Epsilon");
        mustTransition.setAction((Action)inte);
        mustTransition.setFrom(start);
        mustTransition.setTo(start2);
        return mustTransition;
    }

    public static State createState(String string) {
        State s = FACTORY.createState();
        s.setLabel(string);
        return s;
    }
}

