/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.common;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class FileSaveDialog
extends ElementTreeSelectionDialog {
    private Text fFileNameText;
    private String fFileName;
    private boolean fCheckIfExists;
    private String fInitialText;
    private static IContainer SELECTEDCONTAINER = null;

    public FileSaveDialog(Shell parent, String title, String message) {
        this(parent, title, message, "", true, false);
    }

    public FileSaveDialog(Shell parent, String title, String message, String initialText, boolean checkIfExists, boolean allowDirectories) {
        super(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        this.setTitle(title);
        this.setMessage(message);
        this.setInput(ResourcesPlugin.getWorkspace().getRoot());
        this.setComparator((ViewerComparator)new ResourceComparator(1));
        this.setAllowMultiple(false);
        this.fCheckIfExists = checkIfExists;
        this.fInitialText = initialText;
        this.fFileName = "";
    }

    protected Control createDialogArea(Composite parent) {
        Composite result = (Composite)super.createDialogArea(parent);
        Composite c = new Composite(result, 0);
        GridData d = new GridData(4, 1, true, false);
        c.setLayoutData((Object)d);
        c.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(c, 0);
        label.setText("File Name:");
        this.fFileNameText = new Text(c, 2052);
        this.fFileNameText.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fFileNameText.setText(this.fInitialText);
        this.fFileName = this.fInitialText;
        this.fFileNameText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                FileSaveDialog.this.fFileName = FileSaveDialog.this.fFileNameText.getText();
                FileSaveDialog.this.updateOKStatus();
            }
        });
        if (SELECTEDCONTAINER != null) {
            this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)SELECTEDCONTAINER));
        }
        FileSaveDialog.applyDialogFont((Control)result);
        return result;
    }

    protected void okPressed() {
        if (this.fCheckIfExists && this.getFirstResult().exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)"File already exists!", (String)"This file already exists. Overwrite?")) {
            return;
        }
        super.okPressed();
    }

    public Object[] getResult() {
        Object[] result = super.getResult();
        if (result == null || result.length == 0) {
            return null;
        }
        if (result[0] instanceof IContainer) {
            SELECTEDCONTAINER = (IContainer)result[0];
            if (this.fFileName != null && !this.fFileName.isEmpty()) {
                IContainer container = (IContainer)result[0];
                try {
                    IFile file = container.getFile((IPath)new Path(this.fFileName));
                    return new Object[]{file};
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    return new Object[0];
                }
            }
        }
        if (result[0] instanceof IResource) {
            return result;
        }
        return null;
    }

    public IResource getFirstResult() {
        Object o = super.getFirstResult();
        return o == null ? null : (IResource)o;
    }
}

