/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.common;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class FileLoadDialog
extends ElementTreeSelectionDialog {
    public FileLoadDialog(Shell parent, String title, String message) {
        this(parent, title, message, Mode.FILE_ONLY);
    }

    public FileLoadDialog(Shell parent, String title, String message, final Mode mode) {
        super(parent, (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        this.setTitle(title);
        this.setMessage(message);
        this.setInput(ResourcesPlugin.getWorkspace().getRoot());
        this.setComparator((ViewerComparator)new ResourceComparator(1));
        this.setAllowMultiple(false);
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1 && FileLoadDialog.this.modeOK(selection[0], mode)) {
                    return new Status(0, "net.miowb.common", 0, "", null);
                }
                return new Status(4, "net.miowb.common", 0, "", null);
            }
        };
        this.setValidator(validator);
    }

    protected boolean modeOK(Object object, Mode mode) {
        switch (mode) {
            case FILE_ONLY: {
                return object instanceof IFile;
            }
            case DIR_ONLY: {
                return object instanceof IContainer;
            }
            case FILE_AND_DIR: {
                return object instanceof IFile || object instanceof IContainer;
            }
        }
        return false;
    }

    public IResource getFirstResult() {
        Object o = super.getFirstResult();
        if (o instanceof IResource) {
            return (IResource)o;
        }
        return null;
    }

    public static enum Mode {
        FILE_ONLY,
        FILE_AND_DIR,
        DIR_ONLY;

    }
}

