/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.weakening;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.miowb.common.MioEMFFactory;
import net.miowb.common.MioHelpers;
import net.miowb.common.SignatureHelper;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.operations.common.Helpers;
import net.miowb.operations.common.PathFinder;
import net.miowb.operations.common.TransitionBetweenWeakeningStates;
import net.miowb.operations.refinement.ModalRefinementImplementation;
import net.miowb.operations.utilities.MioStrongMinimization;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.model.WeakeningState;
import net.miowb.workbench.operations.result.WeakeningResult;

public class MioWeakening {
    public WeakeningResult weaken(ModalIOAutomaton env, ModalIOAutomaton spec) throws MioException {
        HashSet<WeakeningState> fNewStatePairs = new HashSet<WeakeningState>();
        HashSet<TransitionBetweenWeakeningStates> fNewTransitions = new HashSet<TransitionBetweenWeakeningStates>();
        HashSet<WeakeningState> fVisitedStatePairs = new HashSet<WeakeningState>();
        PathFinder.PathsFound information = PathFinder.getPossibleTauEmbeddedTransitions(env.getStart(), (Action)MioEMFFactory.createInternal((String)"tau"), new HashSet<Action>(), PathFinder.AllowedTransitions.BOTH, PathFinder.PassingMode.WITH_TAU_BEFORE_AND_AFTER, PathFinder.EpsilonMode.WITH_EPSILON, ModalRefinementImplementation.ActionComparisonType.SAME);
        WeakeningState initialstate = new WeakeningState(information.getTargetSet(), spec.getStart());
        fNewStatePairs.add(initialstate);
        State fUniversalState = MioEMFFactory.createState((String)"uni");
        WeakeningState fUniversalStatePair = new WeakeningState(new HashSet(), fUniversalState);
        boolean fUniversalStateReachable = false;
        while (!fNewStatePairs.isEmpty()) {
            Set<State> reach;
            TransitionBetweenWeakeningStates trans;
            WeakeningState fCurrentStatePair = (WeakeningState)fNewStatePairs.iterator().next();
            fNewStatePairs.remove(fCurrentStatePair);
            fVisitedStatePairs.add(fCurrentStatePair);
            State specState = fCurrentStatePair.getState();
            Set envStates = fCurrentStatePair.getEnvStates();
            for (Transition specTrans : specState.getOutgoing()) {
                if (!specTrans.getAction().isInternal()) continue;
                WeakeningState next = this.find(fVisitedStatePairs, fNewStatePairs, fCurrentStatePair.getEnvStates(), specTrans.getTo());
                trans = new TransitionBetweenWeakeningStates(fCurrentStatePair, next, specTrans.getAction(), specTrans.isMust());
                this.addTransition(fNewTransitions, trans);
            }
            for (Transition specTrans : specState.getOutgoing()) {
                if (!specTrans.getAction().isInput() && !specTrans.getAction().isOutput() || (reach = this.getReachableStates(envStates, Helpers.getAction(env, specTrans.getAction().getLabel()))).size() <= 0) continue;
                WeakeningState next = this.find(fVisitedStatePairs, fNewStatePairs, reach, specTrans.getTo());
                TransitionBetweenWeakeningStates trans2 = new TransitionBetweenWeakeningStates(fCurrentStatePair, next, specTrans.getAction(), specTrans.isMust());
                this.addTransition(fNewTransitions, trans2);
            }
            for (InputAction input : spec.getInputs()) {
                reach = this.getReachableStates(envStates, Helpers.getAction(env, input.getLabel()));
                if (reach.size() != 0) continue;
                fUniversalStateReachable = true;
                trans = new TransitionBetweenWeakeningStates(fCurrentStatePair, fUniversalStatePair, (Action)input, false);
                this.addTransition(fNewTransitions, trans);
            }
        }
        if (fUniversalStateReachable) {
            fVisitedStatePairs.add(fUniversalStatePair);
            for (Action act : spec.getActions()) {
                TransitionBetweenWeakeningStates newTrans = new TransitionBetweenWeakeningStates(fUniversalStatePair, fUniversalStatePair, act, false);
                this.addTransition(fNewTransitions, newTrans);
            }
        }
        ModalIOAutomaton finalResult = MioEMFFactory.createAutomaton((String)spec.getName());
        Map actionmap = SignatureHelper.copyActionAlphabet((ModalIOAutomaton)spec, (ModalIOAutomaton)finalResult);
        LinkedHashMap<WeakeningState, State> toFinalStates = new LinkedHashMap<WeakeningState, State>();
        for (WeakeningState sp : fVisitedStatePairs) {
            String label = sp.getLabel();
            if (sp == fUniversalStatePair) {
                label = "uni";
            }
            State st = MioEMFFactory.createState((ModalIOAutomaton)finalResult, (String)label);
            toFinalStates.put(sp, st);
        }
        for (TransitionBetweenWeakeningStates trans : fNewTransitions) {
            State from = (State)toFinalStates.get(trans.getFrom());
            State to = (State)toFinalStates.get(trans.getTo());
            MustTransition theNewOne = null;
            if (trans.isMust()) {
                MustTransition must = MioEMFFactory.createMustTransition();
                finalResult.getMustTransitions().add((Object)must);
                theNewOne = must;
            } else {
                MayTransition may = MioEMFFactory.createMayTransition();
                finalResult.getMayTransitions().add((Object)may);
                theNewOne = may;
            }
            theNewOne.setFrom(from);
            theNewOne.setTo(to);
            Action act = (Action)actionmap.get(trans.getAction());
            theNewOne.setAction(act);
        }
        finalResult.setStart((State)toFinalStates.get(initialstate));
        finalResult = new MioStrongMinimization().execute(finalResult).getAutomaton();
        MioHelpers.renameStates((ModalIOAutomaton)finalResult);
        return new WeakeningResult(WeakeningResult.ResultType.SUCCESS, finalResult);
    }

    private void addTransition(Set<TransitionBetweenWeakeningStates> fNewTransitions, TransitionBetweenWeakeningStates trans) {
        for (TransitionBetweenWeakeningStates t : fNewTransitions) {
            if (!trans.getFrom().matchWith(t.getFrom()) || !trans.getTo().matchWith(t.getTo()) || !trans.getAction().getLabel().equals(t.getAction().getLabel())) continue;
            if (trans.isMust()) {
                t.setMust(true);
            }
            return;
        }
        fNewTransitions.add(trans);
    }

    private WeakeningState find(Set<WeakeningState> fVisitedStatePairs, Set<WeakeningState> fNewStatePairs, Set<State> envStates, State to) {
        WeakeningState w2;
        for (WeakeningState w2 : fVisitedStatePairs) {
            if (!w2.matchWith(envStates, to)) continue;
            return w2;
        }
        for (WeakeningState w2 : fNewStatePairs) {
            if (!w2.matchWith(envStates, to)) continue;
            return w2;
        }
        w2 = new WeakeningState(envStates, to);
        fNewStatePairs.add(w2);
        return w2;
    }

    private Set<State> getReachableStates(Set<State> startStates, Action action) {
        HashSet<State> result = new HashSet<State>();
        for (State s : startStates) {
            PathFinder.PathsFound information = PathFinder.getPossibleTauEmbeddedTransitions(s, action, new HashSet<Action>(), PathFinder.AllowedTransitions.BOTH, PathFinder.PassingMode.WITH_TAU_BEFORE_AND_AFTER, PathFinder.EpsilonMode.NO_EPISLON, ModalRefinementImplementation.ActionComparisonType.SAME);
            result.addAll(information.getTargetStates());
        }
        return result;
    }
}

