/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.utilities;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.miowb.common.MioEMFFactory;
import net.miowb.common.MioHelpers;
import net.miowb.common.SignatureHelper;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.InternalAction;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.operations.common.Helpers;
import net.miowb.operations.common.TransitionBetweenListsOfStates;
import net.miowb.operations.refinement.MioWeakRefinement;
import net.miowb.workbench.common.PrettyPrinting;
import net.miowb.workbench.operations.result.OperationResult;
import net.miowb.workbench.operations.result.RefinementResult;
import net.miowb.workbench.shell.Message;

public class MioWeakMinimization {
    public OperationResult execute(ModalIOAutomaton mio) {
        ArrayList<Message> m = new ArrayList<Message>();
        ArrayList equiv_classes = new ArrayList();
        for (State state : mio.getStates()) {
            if (equiv_classes.isEmpty()) {
                ArrayList<State> l = new ArrayList<State>();
                l.add(state);
                equiv_classes.add(l);
                continue;
            }
            boolean added = false;
            for (List list : equiv_classes) {
                ModalIOAutomaton mio1 = MioHelpers.copy((ModalIOAutomaton)mio);
                mio1.setStart(Helpers.getState(mio1, state.getLabel()));
                ModalIOAutomaton modalIOAutomaton = MioHelpers.copy((ModalIOAutomaton)mio);
                modalIOAutomaton.setStart(Helpers.getState(modalIOAutomaton, ((State)list.get(0)).getLabel()));
                if (!new MioWeakRefinement().checkRefinement(mio1, modalIOAutomaton, false, false).getfResultType().equals((Object)RefinementResult.ResultType.SUCCESS) || !new MioWeakRefinement().checkRefinement(modalIOAutomaton, mio1, false, false).getfResultType().equals((Object)RefinementResult.ResultType.SUCCESS)) continue;
                list.add(state);
                added = true;
                m.add(new Message("State " + state.getLabel() + " is equivalent to " + "state " + ((State)list.get(0)).getLabel() + ".", Message.MessageType.VERBOSE));
                break;
            }
            if (added) continue;
            ArrayList<State> arrayList = new ArrayList<State>();
            arrayList.add(state);
            equiv_classes.add(arrayList);
        }
        m.add(new Message("States of the minimized automaton:", Message.MessageType.VERBOSE));
        for (List list : equiv_classes) {
            m.add(new Message("  " + PrettyPrinting.ppstates((List)list), Message.MessageType.VERBOSE));
        }
        ArrayList<TransitionBetweenListsOfStates> arrayList = new ArrayList<TransitionBetweenListsOfStates>();
        for (List list : equiv_classes) {
            for (State state : list) {
                for (Transition t : state.getOutgoing()) {
                    State target = t.getTo();
                    List target_class = null;
                    for (List list2 : equiv_classes) {
                        if (!list2.contains(target)) continue;
                        target_class = list2;
                        break;
                    }
                    if (t.getAction() instanceof InternalAction && list.equals(target_class)) continue;
                    TransitionBetweenListsOfStates transitionBetweenListsOfStates = new TransitionBetweenListsOfStates(list, target_class, t.getAction(), t.isMust());
                    Helpers.addTransition(arrayList, transitionBetweenListsOfStates);
                }
            }
        }
        ModalIOAutomaton modalIOAutomaton = MioEMFFactory.createAutomaton((String)"Minimized Automaton");
        Map actionmap = SignatureHelper.copyActionAlphabet((ModalIOAutomaton)mio, (ModalIOAutomaton)modalIOAutomaton);
        LinkedHashMap<List, State> linkedHashMap = new LinkedHashMap<List, State>();
        for (List list : equiv_classes) {
            State state = MioEMFFactory.createState((ModalIOAutomaton)modalIOAutomaton, (String)PrettyPrinting.ppstates((List)list));
            linkedHashMap.put(list, state);
        }
        for (TransitionBetweenListsOfStates transitionBetweenListsOfStates : arrayList) {
            State state = (State)linkedHashMap.get(transitionBetweenListsOfStates.getFrom());
            State to = (State)linkedHashMap.get(transitionBetweenListsOfStates.getTo());
            MustTransition theNewOne = null;
            if (transitionBetweenListsOfStates.isMust()) {
                MustTransition mustTransition = MioEMFFactory.createMustTransition();
                modalIOAutomaton.getMustTransitions().add((Object)mustTransition);
                theNewOne = mustTransition;
            } else {
                MayTransition mayTransition = MioEMFFactory.createMayTransition();
                modalIOAutomaton.getMayTransitions().add((Object)mayTransition);
                theNewOne = mayTransition;
            }
            theNewOne.setFrom(state);
            theNewOne.setTo(to);
            theNewOne.setAction((Action)actionmap.get(transitionBetweenListsOfStates.getAction()));
        }
        State state = mio.getStart();
        List ii = null;
        for (List list : equiv_classes) {
            if (!list.contains(state)) continue;
            ii = list;
            break;
        }
        modalIOAutomaton.setStart((State)linkedHashMap.get(ii));
        return new OperationResult(OperationResult.ResultType.SUCCESS, modalIOAutomaton, m);
    }
}

