/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.InternalAction;
import net.miowb.model.mio.MioFactory;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.OutputAction;
import net.miowb.operations.common.Helpers;
import net.miowb.workbench.common.PrettyPrinting;
import net.miowb.workbench.shell.MessageManager;

public class MioComposability {
    private List<ModalIOAutomaton> fMios;
    public Set<InputAction> fNewIns = new HashSet<InputAction>();
    public Set<OutputAction> fNewOuts = new HashSet<OutputAction>();
    public Set<InternalAction> fNewInternals = new HashSet<InternalAction>();
    public Set<Action> fChecked = new HashSet<Action>();
    public Map<Action, Action> fMap = new HashMap<Action, Action>();
    public Map<Action, Action> fShared = new HashMap<Action, Action>();
    public List<String> fConflictingActions = new ArrayList<String>();

    public boolean execute(List<ModalIOAutomaton> MIOs) {
        this.fMios = MIOs;
        int i = 0;
        while (i < this.fMios.size()) {
            InternalAction newAction;
            ModalIOAutomaton other_mio;
            Action found_act;
            boolean shared;
            ModalIOAutomaton mio = this.fMios.get(i);
            for (InputAction act : mio.getInputs()) {
                if (this.fChecked.contains(act)) continue;
                shared = false;
                int j = 0;
                while (j < this.fMios.size()) {
                    if (i != j && (found_act = Helpers.isInSetBasedOnLabel((other_mio = this.fMios.get(j)).getActions(), (Action)act)) != null) {
                        if (Helpers.isInSetBasedOnLabel((Collection<? extends Action>)other_mio.getInputs(), (Action)act) != null || Helpers.isInSetBasedOnLabel((Collection<? extends Action>)other_mio.getInternals(), (Action)act) != null) {
                            this.fConflictingActions.add(act.getLabel());
                            return false;
                        }
                        if (shared) {
                            this.fConflictingActions.add(act.getLabel());
                            return false;
                        }
                        shared = true;
                        newAction = MioFactory.eINSTANCE.createInternalAction();
                        newAction.setLabel(act.getLabel());
                        this.fNewInternals.add(newAction);
                        this.fChecked.add((Action)act);
                        this.fChecked.add(found_act);
                        this.fMap.put((Action)act, (Action)newAction);
                        this.fMap.put(found_act, (Action)newAction);
                        this.fShared.put((Action)act, found_act);
                        this.fShared.put(found_act, (Action)act);
                    }
                    ++j;
                }
                if (shared) continue;
                InputAction newAction2 = MioFactory.eINSTANCE.createInputAction();
                newAction2.setLabel(act.getLabel());
                this.fNewIns.add(newAction2);
                this.fChecked.add((Action)act);
                this.fMap.put((Action)act, (Action)newAction2);
            }
            for (InputAction act : mio.getOutputs()) {
                if (this.fChecked.contains(act)) continue;
                shared = false;
                int j = 0;
                while (j < this.fMios.size()) {
                    if (i != j) {
                        other_mio = this.fMios.get(j);
                        found_act = Helpers.isInSetBasedOnLabel(other_mio.getActions(), (Action)act);
                        if (this.fMios.indexOf(other_mio) != this.fMios.indexOf(mio) && found_act != null) {
                            if (Helpers.isInSetBasedOnLabel((Collection<? extends Action>)other_mio.getOutputs(), (Action)act) != null || Helpers.isInSetBasedOnLabel((Collection<? extends Action>)other_mio.getInternals(), (Action)act) != null) {
                                this.fConflictingActions.add(act.getLabel());
                                return false;
                            }
                            if (shared) {
                                this.fConflictingActions.add(act.getLabel());
                                return false;
                            }
                            shared = true;
                            newAction = MioFactory.eINSTANCE.createInternalAction();
                            newAction.setLabel(act.getLabel());
                            this.fNewInternals.add(newAction);
                            this.fChecked.add((Action)act);
                            this.fChecked.add(found_act);
                            this.fMap.put((Action)act, (Action)newAction);
                            this.fMap.put(found_act, (Action)newAction);
                            this.fShared.put((Action)act, found_act);
                            this.fShared.put(found_act, (Action)act);
                        }
                    }
                    ++j;
                }
                if (shared) continue;
                OutputAction newAction3 = MioFactory.eINSTANCE.createOutputAction();
                newAction3.setLabel(act.getLabel());
                this.fNewOuts.add(newAction3);
                this.fChecked.add((Action)act);
                this.fMap.put((Action)act, (Action)newAction3);
            }
            for (InputAction act : mio.getInternals()) {
                int j = 0;
                while (j < this.fMios.size()) {
                    ModalIOAutomaton other_mio2;
                    Action found_act2;
                    if (i != j && (found_act2 = Helpers.isInSetBasedOnLabel((other_mio2 = this.fMios.get(j)).getActions(), (Action)act)) != null) {
                        return false;
                    }
                    ++j;
                }
                InternalAction newAction4 = MioFactory.eINSTANCE.createInternalAction();
                newAction4.setLabel(act.getLabel());
                this.fNewInternals.add(newAction4);
                this.fChecked.add((Action)act);
                this.fMap.put((Action)act, (Action)newAction4);
            }
            ++i;
        }
        return true;
    }

    public void generateMsg() {
        MessageManager.addError((String)(String.valueOf(PrettyPrinting.ppMIOs(this.fMios)) + " is not composable."));
        for (String s : this.fConflictingActions) {
            MessageManager.addError((String)(String.valueOf(s) + " is a conflicting action."));
        }
    }
}

