/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.test;

import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.operations.refinement.ModalRefinementImplementation;
import net.miowb.operations.test.AbstractMioTestHelper;
import org.junit.Test;

public class TestRefinement
extends AbstractMioTestHelper {
    @Override
    protected String getStorageDir() {
        return "resources\\refinement";
    }

    @Test
    public void test1() throws Exception {
        ModalIOAutomaton protocol = this.load("01_prot");
        ModalIOAutomaton impl = this.load("01_impl");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRONG, protocol, impl, "pStart=iStart", "pEnd=iEnd");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.WEAK, protocol, impl, "pStart=iStart", "pEnd=iEnd");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, protocol, impl, "pStart=iStart", "pEnd=iEnd");
    }

    @Test
    public void test2() throws Exception {
        ModalIOAutomaton protocol = this.load("02_prot");
        ModalIOAutomaton impl = this.load("02_impl");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRONG, protocol, impl, "pStart=iStart", "p2=i2", "p3=i3");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.WEAK, protocol, impl, "pStart=iStart", "p2=i2", "p3=i3");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, protocol, impl, "pStart=iStart", "p2=i2", "p3=i3");
    }

    @Test
    public void testWrong() throws Exception {
        ModalIOAutomaton protocol = this.load("03_wrong_prot");
        ModalIOAutomaton impl = this.load("03_wrong_impl");
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRONG, protocol, impl);
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.WEAK, protocol, impl);
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, protocol, impl);
    }

    @Test
    public void testWithTau() throws Exception {
        ModalIOAutomaton protocol = this.load("04_tau_prot");
        ModalIOAutomaton impl = this.load("04_tau_impl");
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRONG, protocol, impl);
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.WEAK, protocol, impl, "pStart=iStart", "pStart=i2", "pEnd=iEnd");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, protocol, impl, "pStart=iStart", "pEnd=iEnd");
    }

    @Test
    public void testDoubleTau() throws Exception {
        ModalIOAutomaton protocol = this.load("05_doubletau_prot");
        ModalIOAutomaton impl = this.load("05_doubletau_impl");
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRONG, protocol, impl);
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.WEAK, protocol, impl, "pStart=iStart", "pStart=i2", "pStart=i3", "pStart=i4", "pStart=i5", "pEnd=i6");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, protocol, impl, "pStart=iStart", "pEnd=i6");
    }

    @Test
    public void testLoop() throws Exception {
        ModalIOAutomaton protocol = this.load("06_loop_prot");
        ModalIOAutomaton impl = this.load("06_loop_impl");
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRONG, protocol, impl);
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.WEAK, protocol, impl, "pStart=iStart", "pStart=i2", "pEnd=i3");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, protocol, impl, "pStart=iStart", "pEnd=i3");
    }

    @Test
    public void testDoubleLoopRolf() throws Exception {
        ModalIOAutomaton protocol = this.load("07_rolf_prot");
        ModalIOAutomaton impl = this.load("07_rolf_impl");
        ModalRefinementImplementation f = new ModalRefinementImplementation(ModalRefinementImplementation.RefinementType.WEAK, protocol, impl, false);
        f.execute();
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRONG, protocol, impl);
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.WEAK, protocol, impl, "pStart=iStart", "pStart=i2");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, protocol, impl, "pStart=iStart", "pStart=i2");
    }

    @Test
    public void testLoopNotOK() throws Exception {
        ModalIOAutomaton protocol = this.load("08_loop_wrong_prot");
        ModalIOAutomaton impl = this.load("08_loop_wrong_impl");
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRONG, protocol, impl);
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.WEAK, protocol, impl);
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, protocol, impl);
    }

    @Test
    public void testNotInAlphabet1() throws Exception {
        ModalIOAutomaton protocol = this.load("09_not_in_alph1_prot");
        ModalIOAutomaton impl = this.load("09_not_in_alph1_impl");
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRONG, protocol, impl);
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.WEAK, protocol, impl);
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, protocol, impl, "pStart=iStart", "p2=i2", "p3=i3");
    }

    @Test
    public void testNotInAlphabet2() throws Exception {
        ModalIOAutomaton protocol = this.load("10_not_in_alph2_prot");
        ModalIOAutomaton impl = this.load("10_not_in_alph2_impl");
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRONG, protocol, impl);
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.WEAK, protocol, impl);
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, protocol, impl, "pStart=iStart", "p2=i2", "p3=i3");
    }

    @Test
    public void testTwoOptionsRelations() throws Exception {
        ModalIOAutomaton protocol = this.load("11_two_opt_prot");
        ModalIOAutomaton impl = this.load("11_two_opt_impl");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRONG, protocol, impl, "pStart=iStart", "pEnd=iEnd1", "pEnd=iEnd2");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.WEAK, protocol, impl, "pStart=iStart", "pEnd=iEnd1", "pEnd=iEnd2");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, protocol, impl, "pStart=iStart", "pEnd=iEnd1", "pEnd=iEnd2");
    }

    @Test
    public void testMay() throws Exception {
        ModalIOAutomaton protocol = this.load("12_may_prot");
        ModalIOAutomaton impl = this.load("12_may_impl");
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRONG, protocol, impl);
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.WEAK, protocol, impl, "p0=i0", "p0=i1", "p1=i2", "p2=i3");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, protocol, impl, "p0=i0", "p2=i3", "p1=i2");
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRONG, impl, protocol);
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.WEAK, impl, protocol);
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, impl, protocol, "i0=p0", "i3=p2", "i2=p1");
    }

    @Test
    public void testWirsingYes() throws Exception {
        ModalIOAutomaton protocol = this.load("13_two_mays_prot");
        ModalIOAutomaton impl = this.load("13_two_mays_impl");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRONG, protocol, impl, "p0=i0", "p1=i1", "p2=i2");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.WEAK, protocol, impl, "p0=i0", "p1=i1", "p2=i2");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, protocol, impl, "p0=i0", "p1=i1", "p2=i2");
    }

    @Test
    public void testWirsingNo() throws Exception {
        ModalIOAutomaton protocol = this.load("14_may_wrong_prot");
        ModalIOAutomaton impl = this.load("14_may_wrong_impl");
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRONG, protocol, impl);
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.WEAK, protocol, impl);
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, protocol, impl, "p0=i0", "p1=i1", "p2=i2");
    }

    @Test
    public void testSebastianTauPath() throws Exception {
        ModalIOAutomaton protocol = this.load("15_SebastianTauPath_prot");
        ModalIOAutomaton impl = this.load("15_SebastianTauPath_impl");
        ModalRefinementImplementation f = new ModalRefinementImplementation(ModalRefinementImplementation.RefinementType.WEAK, protocol, impl, false);
        f.execute();
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRONG, protocol, impl);
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.WEAK, protocol, impl, "0=0", "0=1", "0=2", "1=1", "1=2", "3=3", "2=3");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, protocol, impl, "0=0", "3=3", "2=3");
    }

    @Test
    public void testCanoncialSOExample() throws Exception {
        ModalIOAutomaton protocol = this.load("16_canonical_so_prot");
        ModalIOAutomaton impl = this.load("16_canonical_so_impl");
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRONG, protocol, impl);
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.WEAK, protocol, impl);
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, protocol, impl, "0=0", "1=1", "2=2", "3=4");
    }
}

