/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.test;

import java.util.List;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.State;
import net.miowb.operations.common.PathFinder;
import net.miowb.operations.refinement.ModalRefinementImplementation;
import net.miowb.operations.test.AbstractMioTestHelper;
import org.junit.Test;

public class TestPathHelper
extends AbstractMioTestHelper {
    @Override
    protected String getStorageDir() {
        return "resources\\path";
    }

    @Test
    public void testPathHelperSimple() throws Exception {
        ModalIOAutomaton a = this.load("01_path_help_simple");
        List<State> ends = PathFinder.getPossibleTauEmbeddedTransitions(a.getStart(), TestPathHelper.getAction(a, "a"), null, PathFinder.AllowedTransitions.BOTH, PathFinder.PassingMode.WITH_TAU_BEFORE_AND_AFTER, PathFinder.EpsilonMode.WITH_EPSILON, ModalRefinementImplementation.ActionComparisonType.SAME).getTargetStates();
        this.checkContainsOnly(ends, "State2", "State3", "State4");
    }

    @Test
    public void testPathHelperForkStyle() throws Exception {
        ModalIOAutomaton b = this.load("02_path_help_fork_style");
        List<State> ends = PathFinder.getPossibleTauEmbeddedTransitions(b.getStart(), TestPathHelper.getAction(b, "a"), null, PathFinder.AllowedTransitions.BOTH, PathFinder.PassingMode.WITH_TAU_BEFORE_AND_AFTER, PathFinder.EpsilonMode.WITH_EPSILON, ModalRefinementImplementation.ActionComparisonType.SAME).getTargetStates();
        this.checkContainsOnly(ends, "State3", "State4", "State5", "State6");
    }

    @Test
    public void testPathHelperForkStyleWithMissing() throws Exception {
        ModalIOAutomaton b = this.load("03_path_help_fork_missing");
        List<State> ends = PathFinder.getPossibleTauEmbeddedTransitions(b.getStart(), TestPathHelper.getAction(b, "a"), null, PathFinder.AllowedTransitions.BOTH, PathFinder.PassingMode.WITH_TAU_BEFORE_AND_AFTER, PathFinder.EpsilonMode.WITH_EPSILON, ModalRefinementImplementation.ActionComparisonType.SAME).getTargetStates();
        this.checkContainsOnly(ends, "State3", "State5", "State6");
    }

    @Test
    public void testPathHelperSnapBackProblem() throws Exception {
        ModalIOAutomaton b = this.load("04_path_help_snap_back");
        List<State> ends = PathFinder.getPossibleTauEmbeddedTransitions(b.getStart(), TestPathHelper.getAction(b, "a"), null, PathFinder.AllowedTransitions.BOTH, PathFinder.PassingMode.WITH_TAU_BEFORE_AND_AFTER, PathFinder.EpsilonMode.WITH_EPSILON, ModalRefinementImplementation.ActionComparisonType.SAME).getTargetStates();
        this.checkContainsOnly(ends, "State2");
    }

    @Test
    public void testPathHelperLoop() throws Exception {
        ModalIOAutomaton b = this.load("05_path_help_loop");
        List<State> ends = PathFinder.getPossibleTauEmbeddedTransitions(b.getStart(), TestPathHelper.getAction(b, "a"), null, PathFinder.AllowedTransitions.BOTH, PathFinder.PassingMode.WITH_TAU_BEFORE_AND_AFTER, PathFinder.EpsilonMode.WITH_EPSILON, ModalRefinementImplementation.ActionComparisonType.SAME).getTargetStates();
        this.checkContainsOnly(ends, "State1", "State2", "State3");
    }
}

