/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.test;

import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.operations.test.AbstractMioTestHelper;
import net.miowb.workbench.operations.result.CompatibilityResult;
import net.miowb.workbench.shell.MioCommandLine;
import org.junit.Test;

public class TestCompatibility
extends AbstractMioTestHelper {
    private final String prefix = "FSP {";
    private final String postfix = "}";

    @Override
    protected String getStorageDir() {
        return "resources\\compatibility";
    }

    @Test
    public void test1() throws Exception {
        ModalIOAutomaton prot1 = this.load("01_prot1");
        ModalIOAutomaton prot2 = this.load("01_prot2");
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRONG, prot1, prot2, "p1Start=p2Start", "p1End=p2End");
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.WEAK, prot1, prot2, "p1Start=p2Start", "p1End=p2End");
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRICT_OBSERVATIONAL, prot1, prot2, "p1Start=p2Start", "p1End=p2End");
    }

    @Test
    public void testNoSharedLabels() throws Exception {
        ModalIOAutomaton prot1 = this.load("02_noshared_prot1");
        ModalIOAutomaton prot2 = this.load("02_noshared_prot2");
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRONG, prot1, prot2, "A=C", "A=D", "B=C", "B=D");
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.WEAK, prot1, prot2, "A=C", "A=D", "B=C", "B=D");
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRICT_OBSERVATIONAL, prot1, prot2, "A=C");
    }

    @Test
    public void testNyman() throws Exception {
        ModalIOAutomaton clientIf = this.load("03_nyman_client");
        ModalIOAutomaton dll = this.load("03_nyman_dll");
        this.checkAgainstCompatibility(CompatibilityResult.CompatibilityType.STRONG, clientIf, dll);
        this.checkAgainstCompatibility(CompatibilityResult.CompatibilityType.WEAK, clientIf, dll);
        this.checkAgainstCompatibility(CompatibilityResult.CompatibilityType.STRICT_OBSERVATIONAL, clientIf, dll);
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRONG_FRIENDLY, clientIf, dll, "2=14", "3=15", "3=16", "3=17", "3=18", "3=19", "3=20");
    }

    @Test
    public void testMayOnBothSidesWrong() throws Exception {
        ModalIOAutomaton prot1 = this.load("04_rolf_wrong_prot1");
        ModalIOAutomaton prot2 = this.load("04_rolf_wrong_prot2");
        this.checkAgainstCompatibility(CompatibilityResult.CompatibilityType.STRONG, prot1, prot2);
        this.checkAgainstCompatibility(CompatibilityResult.CompatibilityType.WEAK, prot1, prot2);
        this.checkAgainstCompatibility(CompatibilityResult.CompatibilityType.STRICT_OBSERVATIONAL, prot1, prot2);
    }

    @Test
    public void testMustOnBothSidesOK() throws Exception {
        ModalIOAutomaton prot1 = this.load("05_rolf_ok_prot1");
        ModalIOAutomaton prot2 = this.load("05_rolf_ok_prot2");
        this.checkAgainstCompatibility(CompatibilityResult.CompatibilityType.STRONG, prot1, prot2);
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.WEAK, prot1, prot2, "0=0", "1=0");
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRICT_OBSERVATIONAL, prot1, prot2, "0=0", "1=0");
    }

    @Test
    public void testSebastian() throws Exception {
        ModalIOAutomaton protS = this.parse("P = (a!->b?->STOP).");
        ModalIOAutomaton protT = this.parse("P = (a?->b!->STOP).");
        ModalIOAutomaton protTPrime = this.parse("P = (a?->STOP|tau->b!->STOP).");
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.WEAK, protS, protT, new String[0]);
        this.checkAgainstCompatibility(CompatibilityResult.CompatibilityType.WEAK, protS, protTPrime);
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRICT_OBSERVATIONAL, protS, protTPrime, new String[0]);
    }

    private ModalIOAutomaton parse(String s) {
        return (ModalIOAutomaton)MioCommandLine.getInstance().execute("FSP {" + s + "}");
    }
}

