/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.test;

import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.operations.refinement.ModalRefinementImplementation;
import net.miowb.operations.test.AbstractMioTestHelper;
import net.miowb.workbench.operations.result.CompatibilityResult;
import org.junit.Before;
import org.junit.Test;

public class TestCaseStudyFlightBooking
extends AbstractMioTestHelper {
    private ModalIOAutomaton fImplStrong;
    private ModalIOAutomaton fImplWeak;
    private ModalIOAutomaton fProt;
    private ModalIOAutomaton fPartnerProt;

    @Override
    protected String getStorageDir() {
        return "resources//flightbooking";
    }

    @Before
    public void setUp() throws Exception {
        this.fImplStrong = this.load("impl_strong");
        this.fImplWeak = this.load("impl_weak");
        this.fProt = this.load("prot");
        this.fPartnerProt = this.load("partnerProt");
    }

    @Test
    public void testFlightBookingStrongRefinement() throws Exception {
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRONG, this.fProt, this.fImplStrong, "0=0", "1=3", "2=1", "4=2");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.WEAK, this.fProt, this.fImplStrong, "0=0", "1=3", "2=1", "4=2");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, this.fProt, this.fImplStrong, "0=0", "1=3", "2=1", "4=2");
    }

    @Test
    public void testFlightBookingWeakRefinement() throws Exception {
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRONG, this.fProt, this.fImplWeak);
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.WEAK, this.fProt, this.fImplWeak, "0=0", "1=1", "1=5", "2=2", "4=3");
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, this.fProt, this.fImplWeak, "0=0", "1=5", "2=2", "4=3");
    }

    @Test
    public void testFlightBookingCompatPartnerProtocolAgainstProtocol() throws Exception {
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRONG, this.fProt, this.fPartnerProt, "0=0", "1=4", "2=1", "3=2", "4=3");
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.WEAK, this.fProt, this.fPartnerProt, "0=0", "1=4", "2=1", "3=2", "4=3");
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRICT_OBSERVATIONAL, this.fProt, this.fPartnerProt, "0=0", "1=4", "2=1", "3=2", "4=3");
    }

    @Test
    public void testFlightBookingCompatPartnerProtocolAgainstStrongImpl() throws Exception {
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRONG, this.fPartnerProt, this.fImplStrong, "0=0", "4=3", "1=1", "3=2");
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.WEAK, this.fPartnerProt, this.fImplStrong, "0=0", "4=3", "1=1", "3=2");
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRICT_OBSERVATIONAL, this.fPartnerProt, this.fImplStrong, "0=0", "4=3", "1=1", "3=2");
    }

    @Test
    public void testFlightBookingCompatPartnerProtocolAgainstWeakImpl() throws Exception {
        this.checkAgainstCompatibility(CompatibilityResult.CompatibilityType.STRONG, this.fPartnerProt, this.fImplWeak);
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.WEAK, this.fPartnerProt, this.fImplWeak, "0=0", "4=5", "4=1", "1=2", "3=3");
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRICT_OBSERVATIONAL, this.fPartnerProt, this.fImplWeak, "0=0", "4=5", "1=2", "3=3");
    }
}

