/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.test;

import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.operations.refinement.ModalRefinementImplementation;
import net.miowb.operations.test.AbstractMioTestHelper;
import net.miowb.workbench.operations.result.CompatibilityResult;
import org.junit.Before;
import org.junit.Test;

public class TestCaseStudyEUniversity
extends AbstractMioTestHelper {
    private ModalIOAutomaton fTMGood;
    private ModalIOAutomaton fTMBad;
    private ModalIOAutomaton fStudentProvided;
    private ModalIOAutomaton fTutorProvided;
    private ModalIOAutomaton fEOfficeRequired;
    private ModalIOAutomaton fStudentRequired;
    private ModalIOAutomaton fTutorRequired;
    private ModalIOAutomaton fEOfficeProvided;

    @Override
    protected String getStorageDir() {
        return "resources//eUniversity//";
    }

    @Before
    public void setUp() throws Exception {
        this.fTMGood = this.load("ThesisManagement_good");
        this.fTMBad = this.load("ThesisManagement_bad");
        this.fStudentProvided = this.load("Student_Provided(refines)");
        this.fTutorProvided = this.load("Tutor_Provided(refines)");
        this.fEOfficeRequired = this.load("EOffice_Required(refines)");
        this.fStudentRequired = this.load("Student_Required(arecompatible)");
        this.fTutorRequired = this.load("Tutor_Required(arecompatible)");
        this.fEOfficeProvided = this.load("EOffice_Provided(arecompatible)");
    }

    @Test
    public void testRefStudent() throws Exception {
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRONG, this.fStudentProvided, this.fTMGood);
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.WEAK, this.fStudentProvided, this.fTMGood);
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, this.fStudentProvided, this.fTMGood, "0=0", "1=1", "2=3");
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRONG, this.fStudentProvided, this.fTMBad);
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.WEAK, this.fStudentProvided, this.fTMBad);
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, this.fStudentProvided, this.fTMBad);
    }

    @Test
    public void testRefTutor() throws Exception {
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRONG, this.fTutorProvided, this.fTMGood);
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.WEAK, this.fTutorProvided, this.fTMGood);
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, this.fTutorProvided, this.fTMGood, "0=0", "1=4");
    }

    @Test
    public void testRefEOffice() throws Exception {
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.STRONG, this.fEOfficeRequired, this.fTMGood);
        this.checkAgainstRefinement(ModalRefinementImplementation.RefinementType.WEAK, this.fEOfficeRequired, this.fTMGood);
        this.checkForRefinement(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL, this.fEOfficeRequired, this.fTMGood, "0=0", "1=2");
    }

    @Test
    public void testCompatStudent() throws Exception {
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRONG, this.fStudentProvided, this.fStudentRequired, "0=0", "1=1", "2=2");
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.WEAK, this.fStudentProvided, this.fStudentRequired, "0=0", "1=1", "2=2");
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRICT_OBSERVATIONAL, this.fStudentProvided, this.fStudentRequired, "0=0", "1=1", "2=2");
        this.checkAgainstCompatibility(CompatibilityResult.CompatibilityType.STRONG, this.fStudentRequired, this.fTMGood);
        this.checkAgainstCompatibility(CompatibilityResult.CompatibilityType.WEAK, this.fStudentRequired, this.fTMGood);
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRICT_OBSERVATIONAL, this.fStudentRequired, this.fTMGood, "0=0", "1=1", "2=3");
    }

    @Test
    public void testCompatTutor() throws Exception {
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRICT_OBSERVATIONAL, this.fTutorProvided, this.fTutorRequired, "0=0", "1=1");
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRICT_OBSERVATIONAL, this.fTutorRequired, this.fTMGood, "0=0", "1=4");
    }

    @Test
    public void testCompatEOffice() throws Exception {
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRICT_OBSERVATIONAL, this.fEOfficeProvided, this.fEOfficeRequired, "0=0", "1=1");
        this.checkForCompatibility(CompatibilityResult.CompatibilityType.STRICT_OBSERVATIONAL, this.fEOfficeProvided, this.fTMGood, "0=0", "1=2");
    }
}

