/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.test;

import java.io.File;
import java.util.List;
import java.util.Set;
import net.miowb.common.MioEMFFactory;
import net.miowb.common.MioEMFHelper;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.State;
import net.miowb.operations.compatibility.VV_OutputCompatibilityImplementation;
import net.miowb.operations.refinement.ModalRefinementImplementation;
import net.miowb.workbench.operations.model.RefinementRelation;
import net.miowb.workbench.operations.model.StatePair;
import net.miowb.workbench.operations.result.CompatibilityResult;
import net.miowb.workbench.operations.result.RefinementResult;
import org.eclipse.emf.common.util.EList;
import org.junit.Assert;

public abstract class AbstractMioTestHelper {
    protected void checkAgainstRefinement(ModalRefinementImplementation.RefinementType type, ModalIOAutomaton prot, ModalIOAutomaton impl) {
        ModalRefinementImplementation f = new ModalRefinementImplementation(type, prot, impl, false);
        f.execute();
        RefinementResult runRefinement = f.getRefinementResult();
        Assert.assertFalse((String)"Refinement MUST NOT be found.", (boolean)runRefinement.isOkay());
    }

    protected void checkForRefinement(ModalRefinementImplementation.RefinementType type, ModalIOAutomaton prot, ModalIOAutomaton impl, String ... info) {
        ModalRefinementImplementation f = new ModalRefinementImplementation(type, prot, impl, false);
        f.execute();
        RefinementResult runRefinement = f.getRefinementResult();
        Assert.assertTrue((String)"Must have a refinement relation", (boolean)runRefinement.isOkay());
        RefinementRelation res = runRefinement.getPositiveResult();
        Set statePairs = res.getStatePairs();
        this.checkStatePairs(statePairs, info);
    }

    protected void checkAgainstCompatibility(CompatibilityResult.CompatibilityType type, ModalIOAutomaton s1, ModalIOAutomaton s2) {
        VV_OutputCompatibilityImplementation iocomp = new VV_OutputCompatibilityImplementation(type, s1, s2);
        CompatibilityResult runCompatibility = iocomp.checkCompatibility();
        Assert.assertFalse((String)"Must not be compatible", (boolean)runCompatibility.areCompatible());
    }

    protected void checkForCompatibility(CompatibilityResult.CompatibilityType type, ModalIOAutomaton s1, ModalIOAutomaton s2, String ... info) {
        VV_OutputCompatibilityImplementation iocomp = new VV_OutputCompatibilityImplementation(type, s1, s2);
        CompatibilityResult runCompatibility = type == CompatibilityResult.CompatibilityType.STRICT_OBSERVATIONAL ? iocomp.delegateToSOChecking() : iocomp.checkCompatibility();
        Assert.assertTrue((String)"Must be compatible", (boolean)runCompatibility.areCompatible());
    }

    private void checkStatePairs(Set<StatePair> statePairs, String ... toTest) {
        String[] stringArray = toTest;
        int n = toTest.length;
        int n2 = 0;
        while (n2 < n) {
            String match = stringArray[n2];
            String protocolState = match.substring(0, match.indexOf("="));
            String implState = match.substring(match.indexOf("=") + 1);
            boolean found = false;
            for (StatePair pair : statePairs) {
                if (!pair.getS1().getLabel().equals(protocolState) || !pair.getS2().getLabel().equals(implState)) continue;
                found = true;
                break;
            }
            Assert.assertTrue((String)("Match " + match + " is not in relation!"), (boolean)found);
            ++n2;
        }
        for (StatePair pair : statePairs) {
            boolean found = false;
            String[] stringArray2 = toTest;
            int n3 = toTest.length;
            int n4 = 0;
            while (n4 < n3) {
                String match = stringArray2[n4];
                String protocolState = match.substring(0, match.indexOf("="));
                String implState = match.substring(match.indexOf("=") + 1);
                if (pair.getS1().getLabel().equals(protocolState) && pair.getS2().getLabel().equals(implState)) {
                    found = true;
                    break;
                }
                ++n4;
            }
            Assert.assertTrue((String)("There is a match in the relation which should not be there: " + pair), (boolean)found);
        }
    }

    protected static Action getAction(ModalIOAutomaton a, String string) {
        List actions = a.getActions();
        for (Action action : actions) {
            if (!action.getLabel().equals(string)) continue;
            return action;
        }
        return null;
    }

    protected void checkContainsOnly(List<State> possibleEmbeddedTransitionsEnds, String ... stateNames) {
        String[] stringArray = stateNames;
        int n = stateNames.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            Assert.assertTrue((String)("Must contain state " + string), (boolean)AbstractMioTestHelper.containsState(possibleEmbeddedTransitionsEnds, string));
            ++n2;
        }
        for (State state : possibleEmbeddedTransitionsEnds) {
            boolean isOneOfOurStates = false;
            String[] stringArray2 = stateNames;
            int n3 = stateNames.length;
            int n4 = 0;
            while (n4 < n3) {
                String string = stringArray2[n4];
                if (state.getLabel().equals(string)) {
                    isOneOfOurStates = true;
                    break;
                }
                ++n4;
            }
            Assert.assertTrue((String)("State in list which should not: " + state.getLabel()), (boolean)isOneOfOurStates);
        }
    }

    protected static boolean containsState(List<State> possibleEmbeddedTransitionsEnds3, String string) {
        for (State state : possibleEmbeddedTransitionsEnds3) {
            if (!state.getLabel().equals(string)) continue;
            return true;
        }
        return false;
    }

    protected static void must(ModalIOAutomaton a, String state1Name, String state2Name, String actionName, Type t) {
        AbstractMioTestHelper.t(a, state1Name, state2Name, actionName, t, true);
    }

    protected static void may(ModalIOAutomaton a, String state1Name, String state2Name, String actionName, Type t) {
        AbstractMioTestHelper.t(a, state1Name, state2Name, actionName, t, false);
    }

    protected static void t(ModalIOAutomaton a, String state1Name, String state2Name, String actionName, Type t, boolean must) {
        State state1 = null;
        State state2 = null;
        EList states = a.getStates();
        for (State state : states) {
            if (state.getLabel().equals(state1Name)) {
                state1 = state;
            }
            if (!state.getLabel().equals(state2Name)) continue;
            state2 = state;
        }
        if (state1 == null) {
            state1 = MioEMFFactory.createState((ModalIOAutomaton)a, (String)state1Name);
        }
        if (state2 == null) {
            state2 = state1.getLabel().equals(state2Name) ? state1 : MioEMFFactory.createState((ModalIOAutomaton)a, (String)state2Name);
        }
        if (a.getStart() == null) {
            a.setStart(state1);
        }
        InputAction act = null;
        switch (t) {
            case IN: {
                act = MioEMFFactory.createInput((ModalIOAutomaton)a, (String)actionName);
                break;
            }
            case OUT: {
                act = MioEMFFactory.createOutput((ModalIOAutomaton)a, (String)actionName);
                break;
            }
            case TAU: {
                act = MioEMFFactory.createInternal((ModalIOAutomaton)a, (String)actionName);
            }
        }
        MustTransition tr = null;
        if (must) {
            tr = MioEMFFactory.createMustTransition();
            a.getMustTransitions().add((Object)tr);
        } else {
            tr = MioEMFFactory.createMayTransition();
            a.getMayTransitions().add((Object)((MayTransition)tr));
        }
        tr.setAction((Action)act);
        tr.setFrom(state1);
        tr.setTo(state2);
    }

    protected abstract String getStorageDir();

    protected ModalIOAutomaton load(String pathToFile) throws Exception {
        return MioEMFHelper.load((File)new File(String.valueOf(this.getStorageDir()) + "\\" + pathToFile + ".mio"));
    }

    protected void store(String string, ModalIOAutomaton protocol) throws Exception {
        MioEMFHelper.store((File)new File(String.valueOf(this.getStorageDir()) + "\\" + string + ".mio"), (ModalIOAutomaton)protocol, null);
    }

    public static void out(List<State> possibleEmbeddedTransitionsEnds) {
        System.out.println("-");
        for (State state : possibleEmbeddedTransitionsEnds) {
            System.out.println(state);
        }
        System.out.println("-");
    }

    protected static enum Type {
        IN,
        OUT,
        TAU;

    }
}

