/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.signature;

import java.util.List;
import java.util.Map;
import net.miowb.common.MioEMFFactory;
import net.miowb.common.SignatureHelper;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.State;

public class SignatureExtension {
    public static void extendSignature(ModalIOAutomaton mio, List<String> new_inputs, List<String> new_outputs, List<String> new_internals, List<String> new_communications, SignatureExtensionType type) {
        Map action_map = SignatureHelper.addNewActions((ModalIOAutomaton)mio, new_inputs, new_outputs, new_internals, new_communications);
        for (State s : mio.getStates()) {
            for (String new_a : action_map.keySet()) {
                switch (type) {
                    case WEAK: {
                        MayTransition mayloop = MioEMFFactory.createMayTransition();
                        mayloop.setAction((Action)action_map.get(new_a));
                        mayloop.setFrom(s);
                        mayloop.setTo(s);
                        mio.getMayTransitions().add((Object)mayloop);
                        break;
                    }
                    case STRONG: {
                        MustTransition mustloop = MioEMFFactory.createMustTransition();
                        mustloop.setAction((Action)action_map.get(new_a));
                        mustloop.setFrom(s);
                        mustloop.setTo(s);
                        mio.getMustTransitions().add((Object)mustloop);
                    }
                }
            }
        }
    }

    public static void extendSignature(ModalIOAutomaton mio, List<Action> actions, SignatureExtensionType type) {
        List inputactions = SignatureHelper.getLabels(actions, (SignatureHelper.ActionType)SignatureHelper.ActionType.INPUT);
        List outputactions = SignatureHelper.getLabels(actions, (SignatureHelper.ActionType)SignatureHelper.ActionType.OUTPUT);
        List internalactions = SignatureHelper.getLabels(actions, (SignatureHelper.ActionType)SignatureHelper.ActionType.INTERNAL);
        List communicationactions = SignatureHelper.getLabels(actions, (SignatureHelper.ActionType)SignatureHelper.ActionType.COMMUNICATION);
        SignatureExtension.extendSignature(mio, inputactions, outputactions, internalactions, communicationactions, type);
    }

    public static enum SignatureExtensionType {
        WEAK,
        STRONG;

    }
}

