/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.refinement;

import java.util.ArrayList;
import java.util.List;
import net.miowb.model.mio.State;
import net.miowb.operations.common.PathFinder;
import net.miowb.operations.refinement.IRefinementPathStep;
import net.miowb.operations.refinement.RefinementCheckState;
import net.miowb.operations.refinement.RefinementConstraint;
import net.miowb.workbench.operations.model.SingleActionPath;

public class RefinementStatePair
implements IRefinementPathStep {
    private State fProtocolState;
    private State fImplementationState;
    private List<RefinementConstraint> fConstraints;
    private RefinementCheckState fCheckState;

    protected RefinementStatePair(State prot, State impl) {
        this.fProtocolState = prot;
        this.fImplementationState = impl;
        this.fCheckState = RefinementCheckState.NOT_CHECKED;
        this.fConstraints = new ArrayList<RefinementConstraint>();
    }

    protected void addConstraint(RefinementConstraint constraint) {
        this.fConstraints.add(constraint);
    }

    protected void setCheckState(RefinementCheckState checkState) {
        this.fCheckState = checkState;
    }

    protected RefinementConstraint createOrRetrieveConstraint(SingleActionPath path, String direction) {
        RefinementConstraint c2;
        for (RefinementConstraint c2 : this.fConstraints) {
            if (!PathFinder.isSameAction2(c2.getAction(), path.getAction()) || !c2.getDirection().equals(direction) || !this.haveSameEndStates(c2.getRequiredPaths(), path)) continue;
            return c2;
        }
        c2 = new RefinementConstraint(this, path.getAction(), direction);
        this.addConstraint(c2);
        return c2;
    }

    private boolean haveSameEndStates(List<SingleActionPath> requiredPaths, SingleActionPath path) {
        for (SingleActionPath singleActionPath : requiredPaths) {
            if (!singleActionPath.getTo().equals(path.getTo())) continue;
            return true;
        }
        return false;
    }

    protected List<RefinementConstraint> getConstraints() {
        return this.fConstraints;
    }

    protected RefinementCheckState getCheckState() {
        return this.fCheckState;
    }

    public State getImplementationState() {
        return this.fImplementationState;
    }

    public State getProtocolState() {
        return this.fProtocolState;
    }

    public String toString() {
        return "Pair (" + this.fProtocolState.getLabel() + "," + this.fImplementationState.getLabel() + ")";
    }
}

