/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.refinement;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.miowb.model.mio.Action;
import net.miowb.operations.refinement.IRefinementPathStep;
import net.miowb.operations.refinement.RefinementCheckState;
import net.miowb.operations.refinement.RefinementStatePair;
import net.miowb.workbench.operations.model.SingleActionPath;

public class RefinementConstraint
implements IRefinementPathStep {
    private RefinementStatePair fBaseStatePair;
    private Action fAction;
    private Set<RefinementStatePair> fOptions;
    private RefinementCheckState fCheckState;
    private List<SingleActionPath> fRequiredPaths;
    private Map<RefinementStatePair, Map<SingleActionPath, List<SingleActionPath>>> fOptionPaths;
    private String fDir;

    public RefinementConstraint(RefinementStatePair statePair, Action action, String dir) {
        this.fBaseStatePair = statePair;
        this.fCheckState = RefinementCheckState.NOT_CHECKED;
        this.fAction = action;
        this.fRequiredPaths = new ArrayList<SingleActionPath>();
        this.fDir = dir;
        this.fOptions = new LinkedHashSet<RefinementStatePair>();
        this.fOptionPaths = new LinkedHashMap<RefinementStatePair, Map<SingleActionPath, List<SingleActionPath>>>();
    }

    public void addOption(RefinementStatePair theOption, SingleActionPath requiredPath, List<SingleActionPath> providedPath) {
        this.fOptions.add(theOption);
        Map<SingleActionPath, List<SingleActionPath>> map = this.fOptionPaths.get(theOption);
        if (map == null) {
            map = new LinkedHashMap<SingleActionPath, List<SingleActionPath>>();
            map.put(requiredPath, providedPath);
            this.fOptionPaths.put(theOption, map);
        } else {
            List<SingleActionPath> list = map.get(requiredPath);
            if (list == null) {
                map.put(requiredPath, providedPath);
            } else {
                for (SingleActionPath notYetIn : providedPath) {
                    boolean isIn = false;
                    for (SingleActionPath alreadyIn : list) {
                        if (!alreadyIn.isSameAs(notYetIn)) continue;
                        isIn = true;
                        break;
                    }
                    if (isIn) continue;
                    list.add(notYetIn);
                }
            }
        }
    }

    public void addDirection(String direction) {
    }

    public void addRequiredPath(SingleActionPath transition) {
        this.fRequiredPaths.add(transition);
    }

    public void setCheckState(RefinementCheckState checkState) {
        this.fCheckState = checkState;
    }

    public Set<RefinementStatePair> getOptions() {
        return this.fOptions;
    }

    public RefinementCheckState getCheckState() {
        return this.fCheckState;
    }

    public Action getAction() {
        return this.fAction;
    }

    public List<SingleActionPath> getRequiredPaths() {
        return this.fRequiredPaths;
    }

    public List<SingleActionPath> getOptionPaths(RefinementStatePair pair, SingleActionPath requiredPath) {
        return this.fOptionPaths.get(pair).get(requiredPath);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Constraint direction=(");
        b.append(this.fDir);
        b.append(") (" + this.fAction.getLabel() + ") on " + this.fBaseStatePair.toString() + " with " + this.fOptions.size() + " options: ");
        for (RefinementStatePair pair : this.fOptions) {
            b.append(pair + " ");
        }
        return b.toString();
    }

    public String getDirection() {
        return this.fDir;
    }
}

