/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.refinement;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.operations.common.PathFinder;
import net.miowb.operations.refinement.IRefinementPathStep;
import net.miowb.operations.refinement.RefinementCheckState;
import net.miowb.operations.refinement.RefinementConstraint;
import net.miowb.operations.refinement.RefinementStatePair;
import net.miowb.workbench.common.PrettyPrinting;
import net.miowb.workbench.operations.model.RefinementRelation;
import net.miowb.workbench.operations.model.SingleActionPath;
import net.miowb.workbench.operations.model.StatePair;
import net.miowb.workbench.operations.result.RefinementResult;
import net.miowb.workbench.shell.MessageManager;
import org.eclipse.emf.common.util.EList;

public class ModalRefinementImplementation {
    private ModalIOAutomaton fProtocol;
    private ModalIOAutomaton fImplementation;
    private Set<RefinementStatePair> fStatePairs;
    private RefinementType fRefinementType;
    private RefinementStatePair fInitialPair;
    private ActionComparisonType fActionComparisonType;
    private List<List<IRefinementPathStep>> fPaths;
    private RefinementResult fRefinementResult;
    private boolean fPrintToConsole;

    public ModalRefinementImplementation(RefinementType type, ModalIOAutomaton prot, ModalIOAutomaton impl, boolean printToConsole) {
        this.fProtocol = prot;
        this.fImplementation = impl;
        this.fRefinementType = type;
        this.fActionComparisonType = type == RefinementType.STRICTOBSERVATIONAL_COMPAT ? ActionComparisonType.COMPLEMENTARY : ActionComparisonType.SAME;
        this.fInitialPair = new RefinementStatePair(this.fProtocol.getStart(), this.fImplementation.getStart());
        this.fPrintToConsole = printToConsole;
    }

    public void execute() {
        this.fPaths = new ArrayList<List<IRefinementPathStep>>();
        this.fStatePairs = new LinkedHashSet<RefinementStatePair>();
        this.fStatePairs.add(this.fInitialPair);
        this.createTree(this.fInitialPair);
        this.checkOptions(this.fInitialPair, new LinkedHashSet<RefinementStatePair>(), new ArrayList<IRefinementPathStep>());
        if (this.fInitialPair.getCheckState() == RefinementCheckState.HANDLED_OKAY) {
            List<RefinementStatePair> refPairs = this.createRefinementRelation(this.fInitialPair, new LinkedHashSet<RefinementStatePair>());
            RefinementRelation res = new RefinementRelation();
            for (RefinementStatePair refinementStatePair : refPairs) {
                StatePair pair = new StatePair(refinementStatePair.getProtocolState(), refinementStatePair.getImplementationState());
                res.addPair(pair);
                List<RefinementConstraint> constraints = refinementStatePair.getConstraints();
                for (RefinementConstraint refinementConstraint : constraints) {
                    if (refinementConstraint.getCheckState() != RefinementCheckState.HANDLED_OKAY) continue;
                    for (SingleActionPath requiredPath : refinementConstraint.getRequiredPaths()) {
                        res.addRequired(pair, requiredPath);
                        Set<RefinementStatePair> options = refinementConstraint.getOptions();
                        for (RefinementStatePair refinementStatePair2 : options) {
                            if (refinementStatePair2.getCheckState() != RefinementCheckState.HANDLED_OKAY) continue;
                            res.addProvided(pair, requiredPath, refinementConstraint.getOptionPaths(refinementStatePair2, requiredPath));
                        }
                    }
                }
            }
            this.add("TRUE");
            this.fRefinementResult = new RefinementResult(res);
            this.fRefinementResult.setfResultType(RefinementResult.ResultType.SUCCESS);
        } else {
            this.addError("FALSE");
            this.fRefinementResult = new RefinementResult();
            this.fRefinementResult.setfResultType(RefinementResult.ResultType.REFINEMENT_ERROR);
            for (List<IRefinementPathStep> stepList : this.fPaths) {
                RefinementRelation res = new RefinementRelation();
                this.fRefinementResult.addNegativeResult(res);
                StatePair lastState = null;
                int i = 0;
                while (i < stepList.size()) {
                    IRefinementPathStep theStep = stepList.get(i);
                    if (theStep instanceof RefinementStatePair) {
                        RefinementStatePair statePair = (RefinementStatePair)theStep;
                        lastState = new StatePair(statePair.getProtocolState(), statePair.getImplementationState());
                        res.addPair(lastState);
                    }
                    if (theStep instanceof RefinementConstraint) {
                        for (SingleActionPath path : ((RefinementConstraint)theStep).getRequiredPaths()) {
                            res.addRequired(lastState, path);
                            if (i >= stepList.size() - 1) continue;
                            RefinementStatePair nextStatePair = (RefinementStatePair)stepList.get(i + 1);
                            List<SingleActionPath> optionPaths = ((RefinementConstraint)theStep).getOptionPaths(nextStatePair, path);
                            res.addProvided(lastState, path, optionPaths);
                        }
                    }
                    ++i;
                }
            }
        }
    }

    private void createTree(RefinementStatePair statePair) {
        List<SingleActionPath> protocolOutgoing = this.createOutgoingPathsFrom(statePair.getProtocolState(), PathLookup.FIND_IN_PROTOCOL);
        for (SingleActionPath path : protocolOutgoing) {
            if (this.isRefinementCheck() && path.isMay()) continue;
            RefinementConstraint protocolConstraint = statePair.createOrRetrieveConstraint(path, "Protocol");
            protocolConstraint.addRequiredPath(path);
            PathFinder.PathsFound implPaths = PathFinder.getPossibleTauEmbeddedTransitions(statePair.getImplementationState(), path.getAction(), this.getMostImportantNotToBePassedActions(PathLookup.FIND_IN_IMPLEMENTATION), this.getAllowedTransitionsForTarget(PathLookup.FIND_IN_IMPLEMENTATION, path.getRelevantTransition()), this.getTauModeBasedOnRefinementType(PathLookup.FIND_IN_IMPLEMENTATION), this.getEpsilonModeBasedOnRefinementType(PathLookup.FIND_IN_IMPLEMENTATION), this.fActionComparisonType);
            for (State implState : implPaths.getTargetStates()) {
                RefinementStatePair existingPair = this.getFromCache(path.getTo(), implState);
                if (existingPair == null) {
                    RefinementStatePair pair = new RefinementStatePair(path.getTo(), implState);
                    this.fStatePairs.add(pair);
                    protocolConstraint.addOption(pair, path, implPaths.getPathsTo(implState));
                    this.createTree(pair);
                    continue;
                }
                protocolConstraint.addOption(existingPair, path, implPaths.getPathsTo(implState));
            }
        }
        List<SingleActionPath> implementationOutgoing = this.createOutgoingPathsFrom(statePair.getImplementationState(), PathLookup.FIND_IN_IMPLEMENTATION);
        for (SingleActionPath path : implementationOutgoing) {
            RefinementConstraint implementationConstraint = statePair.createOrRetrieveConstraint(path, "Implementation");
            implementationConstraint.addRequiredPath(path);
            PathFinder.PathsFound protocolPaths = PathFinder.getPossibleTauEmbeddedTransitions(statePair.getProtocolState(), path.getAction(), this.getMostImportantNotToBePassedActions(PathLookup.FIND_IN_PROTOCOL), this.getAllowedTransitionsForTarget(PathLookup.FIND_IN_PROTOCOL, path.getRelevantTransition()), this.getTauModeBasedOnRefinementType(PathLookup.FIND_IN_PROTOCOL), this.getEpsilonModeBasedOnRefinementType(PathLookup.FIND_IN_PROTOCOL), this.fActionComparisonType);
            for (State protocolState : protocolPaths.getTargetStates()) {
                RefinementStatePair existingPair = this.getFromCache(protocolState, path.getTo());
                if (existingPair == null) {
                    RefinementStatePair pair = new RefinementStatePair(protocolState, path.getTo());
                    this.fStatePairs.add(pair);
                    implementationConstraint.addOption(pair, path, protocolPaths.getPathsTo(protocolState));
                    this.createTree(pair);
                    continue;
                }
                implementationConstraint.addOption(existingPair, path, protocolPaths.getPathsTo(protocolState));
            }
        }
    }

    private boolean isRefinementCheck() {
        return this.fRefinementType != RefinementType.STRICTOBSERVATIONAL_COMPAT;
    }

    private PathFinder.AllowedTransitions getAllowedTransitionsForTarget(PathLookup direction, Transition transition) {
        switch (this.fRefinementType) {
            case STRONG: 
            case WEAK: 
            case MAYWEAK: 
            case STRICTOBSERVATIONAL: {
                if (direction == PathLookup.FIND_IN_IMPLEMENTATION) {
                    return PathFinder.AllowedTransitions.MUSTONLY;
                }
                return PathFinder.AllowedTransitions.BOTH;
            }
            case STRICTOBSERVATIONAL_COMPAT: {
                return PathFinder.AllowedTransitions.MUSTONLY;
            }
        }
        throw new RuntimeException("Must not happen");
    }

    private List<SingleActionPath> createOutgoingPathsFrom(State someState, PathLookup where) {
        switch (this.fRefinementType) {
            case STRONG: 
            case WEAK: {
                return SingleActionPath.convertEach((EList)someState.getOutgoing());
            }
            case MAYWEAK: {
                if (where == PathLookup.FIND_IN_PROTOCOL) {
                    ArrayList<SingleActionPath> p = new ArrayList<SingleActionPath>();
                    EList outgoing = someState.getOutgoing();
                    for (Transition transition : outgoing) {
                        if (transition.getAction().isInternal()) continue;
                        p.add(SingleActionPath.convertOne((Transition)transition));
                    }
                    return p;
                }
                return SingleActionPath.convertEach((EList)someState.getOutgoing());
            }
            case STRICTOBSERVATIONAL: 
            case STRICTOBSERVATIONAL_COMPAT: {
                return this.returnStrictObservationalPaths(someState, where);
            }
        }
        return null;
    }

    private PathFinder.PassingMode getTauModeBasedOnRefinementType(PathLookup where) {
        switch (this.fRefinementType) {
            case STRONG: {
                return PathFinder.PassingMode.NO_PASSING;
            }
            case WEAK: {
                return PathFinder.PassingMode.WITH_TAU_BEFORE_AND_AFTER;
            }
            case MAYWEAK: {
                if (where == PathLookup.FIND_IN_PROTOCOL) {
                    return PathFinder.PassingMode.WITH_TAU_BEFORE;
                }
                return PathFinder.PassingMode.NO_PASSING;
            }
            case STRICTOBSERVATIONAL: {
                return PathFinder.PassingMode.WITH_NON_IMPORTANT_BEFORE;
            }
            case STRICTOBSERVATIONAL_COMPAT: {
                return PathFinder.PassingMode.WITH_NON_IMPORTANT_BEFORE;
            }
        }
        return null;
    }

    private PathFinder.EpsilonMode getEpsilonModeBasedOnRefinementType(PathLookup where) {
        switch (this.fRefinementType) {
            case STRONG: {
                return PathFinder.EpsilonMode.NO_EPISLON;
            }
            case WEAK: {
                return PathFinder.EpsilonMode.WITH_EPSILON;
            }
            case MAYWEAK: {
                if (where == PathLookup.FIND_IN_PROTOCOL) {
                    return PathFinder.EpsilonMode.WITH_EPSILON;
                }
                return PathFinder.EpsilonMode.NO_EPISLON;
            }
            case STRICTOBSERVATIONAL: 
            case STRICTOBSERVATIONAL_COMPAT: {
                return PathFinder.EpsilonMode.NO_EPISLON;
            }
        }
        return null;
    }

    private List<SingleActionPath> returnStrictObservationalPaths(State someState, PathLookup where) {
        ArrayList<SingleActionPath> paths = new ArrayList<SingleActionPath>();
        Set<Action> nonInternalActions = this.getMostImportantNotToBePassedActions(where);
        for (Action action : nonInternalActions) {
            if (!this.isRefinementCheck() && action.isInput()) continue;
            PathFinder.PathsFound transitions = PathFinder.getPossibleTauEmbeddedTransitions(someState, action, this.getMostImportantNotToBePassedActions(where), PathFinder.AllowedTransitions.BOTH, PathFinder.PassingMode.WITH_NON_IMPORTANT_BEFORE, PathFinder.EpsilonMode.NO_EPISLON, ActionComparisonType.SAME);
            List<State> targetStates = transitions.getTargetStates();
            for (State state : targetStates) {
                List<SingleActionPath> list = transitions.getTargetPaths().get(state);
                for (SingleActionPath path : list) {
                    paths.add(path);
                }
            }
        }
        return paths;
    }

    private Set<Action> getMostImportantNotToBePassedActions(PathLookup where) {
        HashSet<Action> mostImportantActionSet = new HashSet<Action>();
        switch (this.fRefinementType) {
            case STRICTOBSERVATIONAL_COMPAT: {
                List actions1 = null;
                List actions2 = null;
                if (where == PathLookup.FIND_IN_PROTOCOL) {
                    actions1 = this.fProtocol.getActions();
                    actions2 = this.fImplementation.getActions();
                } else {
                    actions1 = this.fImplementation.getActions();
                    actions2 = this.fProtocol.getActions();
                }
                for (Action action1 : actions1) {
                    if (action1.isInternal()) continue;
                    for (Action action2 : actions2) {
                        if (!action1.getLabel().equals(action2.getLabel()) || (!action1.isInput() || !action2.isOutput()) && (!action1.isOutput() || !action2.isInput())) continue;
                        mostImportantActionSet.add(action1);
                    }
                }
                break;
            }
            default: {
                List actions = this.fProtocol.getActions();
                for (Action action : actions) {
                    if (action.isInternal()) continue;
                    mostImportantActionSet.add(action);
                }
            }
        }
        return mostImportantActionSet;
    }

    private void checkOptions(RefinementStatePair statePair, Set<RefinementStatePair> alreadyChecked, List<IRefinementPathStep> path) {
        if (alreadyChecked.contains(statePair)) {
            if (statePair.getCheckState() == RefinementCheckState.HANDLED_ERROR) {
                return;
            }
            if (statePair.getCheckState() == RefinementCheckState.HANDLED_OKAY) {
                return;
            }
            statePair.setCheckState(RefinementCheckState.HANDLED_OKAY);
            return;
        }
        alreadyChecked.add(statePair);
        List<IRefinementPathStep> path2 = this.copyPath(path);
        path2.add(statePair);
        RefinementCheckState pairState = RefinementCheckState.HANDLED_OKAY;
        for (RefinementConstraint c : statePair.getConstraints()) {
            List<IRefinementPathStep> path3 = this.copyPath(path2);
            path3.add(c);
            if (c.getOptions().isEmpty()) {
                c.setCheckState(RefinementCheckState.HANDLED_ERROR);
                this.fPaths.add(this.copyPath(path3));
            } else {
                RefinementCheckState state = RefinementCheckState.HANDLED_ERROR;
                Set<RefinementStatePair> options = c.getOptions();
                for (RefinementStatePair currentOption : options) {
                    this.checkOptions(currentOption, alreadyChecked, path3);
                    if (currentOption.getCheckState() != RefinementCheckState.HANDLED_OKAY) continue;
                    state = RefinementCheckState.HANDLED_OKAY;
                }
                c.setCheckState(state);
            }
            if (c.getCheckState() != RefinementCheckState.HANDLED_ERROR) continue;
            pairState = RefinementCheckState.HANDLED_ERROR;
            break;
        }
        statePair.setCheckState(pairState);
    }

    private List<RefinementStatePair> createRefinementRelation(RefinementStatePair statePair, Set<RefinementStatePair> alreadyChecked) {
        if (alreadyChecked.contains(statePair)) {
            return null;
        }
        alreadyChecked.add(statePair);
        ArrayList<RefinementStatePair> localRefinement = new ArrayList<RefinementStatePair>();
        List<RefinementConstraint> constraints = statePair.getConstraints();
        for (RefinementConstraint constraint : constraints) {
            if (constraint.getCheckState() != RefinementCheckState.HANDLED_OKAY) continue;
            Set<RefinementStatePair> options = constraint.getOptions();
            ArrayList<RefinementStatePair> okays = new ArrayList<RefinementStatePair>();
            for (RefinementStatePair optionStatePair : options) {
                if (optionStatePair.getCheckState() != RefinementCheckState.HANDLED_OKAY) continue;
                okays.add(optionStatePair);
            }
            for (RefinementStatePair optionStatePair : okays) {
                List<RefinementStatePair> optionRelations = this.createRefinementRelation(optionStatePair, alreadyChecked);
                if (optionRelations == null) continue;
                for (RefinementStatePair list : optionRelations) {
                    localRefinement.add(list);
                }
            }
        }
        localRefinement.add(statePair);
        return localRefinement;
    }

    public RefinementResult getRefinementResult() {
        this.generateMessages();
        return this.fRefinementResult;
    }

    private void generateMessages() {
        String type = "";
        switch (this.fRefinementType) {
            case STRONG: {
                type = "strongly";
                break;
            }
            case WEAK: {
                type = "weakly";
            }
        }
        RefinementResult.ResultType restype = this.fRefinementResult.getfResultType();
        switch (restype) {
            case SUCCESS: {
                if (!this.fPrintToConsole) break;
                MessageManager.add((String)("Refinement Relation: " + PrettyPrinting.pp((RefinementRelation)this.fRefinementResult.getPositiveResult())));
                MessageManager.addVerbose((String)(String.valueOf(this.fImplementation.getName()) + " " + type + " modally refines " + this.fProtocol.getName() + "."));
                break;
            }
            case REFINEMENT_ERROR: {
                if (this.fRefinementResult.getNegativeResults() != null && this.fRefinementResult.getNegativeResults().size() > 0) {
                    HashSet<StatePair> set = new HashSet<StatePair>();
                    for (RefinementRelation rel : this.fRefinementResult.getNegativeResults()) {
                        if (rel.getPairWithoutProvided() == null) continue;
                        StatePair sp = rel.getPairWithoutProvided();
                        set.add(sp);
                    }
                    if (this.fPrintToConsole) {
                        MessageManager.addVerbose((String)("The set of problematic states is " + PrettyPrinting.ppSetOfSwitchedStatePairs(set) + "."));
                    }
                }
                if (!this.fPrintToConsole) break;
                MessageManager.addVerbose((String)(String.valueOf(this.fImplementation.getName()) + " does NOT " + type + " modally refine " + this.fProtocol.getName() + "."));
            }
        }
    }

    public boolean hasRefinementRelations() {
        return this.fInitialPair.getCheckState() == RefinementCheckState.HANDLED_OKAY;
    }

    private RefinementStatePair getFromCache(State protocol, State impl) {
        for (RefinementStatePair state : this.fStatePairs) {
            if (!state.getProtocolState().equals(protocol) || !state.getImplementationState().equals(impl)) continue;
            return state;
        }
        return null;
    }

    private List<IRefinementPathStep> copyPath(List<IRefinementPathStep> path) {
        ArrayList<IRefinementPathStep> newList = new ArrayList<IRefinementPathStep>();
        newList.addAll(path);
        return newList;
    }

    private void add(String s) {
        if (this.fPrintToConsole) {
            MessageManager.add((String)s);
        }
    }

    private void addError(String s) {
        if (this.fPrintToConsole) {
            MessageManager.addError((String)s);
        }
    }

    private void addVerbose(String s) {
        if (this.fPrintToConsole) {
            MessageManager.addVerbose((String)s);
        }
    }

    public static enum ActionComparisonType {
        SAME,
        COMPLEMENTARY;

    }

    private static enum PathLookup {
        FIND_IN_PROTOCOL,
        FIND_IN_IMPLEMENTATION;

    }

    public static enum RefinementType {
        STRONG,
        WEAK,
        MAYWEAK,
        STRICTOBSERVATIONAL,
        STRICTOBSERVATIONAL_COMPAT;

    }
}

