/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.refinement;

import java.util.List;
import net.miowb.common.MioHelpers;
import net.miowb.common.SignatureHelper;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.operations.refinement.ModalRefinementImplementation;
import net.miowb.operations.signature.SignatureExtension;
import net.miowb.workbench.common.PrettyPrinting;
import net.miowb.workbench.operations.IMioRefinementOperation;
import net.miowb.workbench.operations.result.RefinementResult;
import net.miowb.workbench.shell.MessageManager;

public class MioStrongRefinement
implements IMioRefinementOperation {
    public RefinementResult checkRefinement(ModalIOAutomaton protocol, ModalIOAutomaton implementation, boolean weakly_extend_protocol, boolean printToConsole) {
        if (printToConsole) {
            MessageManager.add((String)("Checking strong modal refinement " + implementation.getName() + " <= " + protocol.getName() + " ..."));
        }
        RefinementResult result = new RefinementResult();
        Action act = SignatureHelper.signature_isSupersetOf((ModalIOAutomaton)implementation, (ModalIOAutomaton)protocol);
        if (act != null) {
            MessageManager.addError((String)("There are conflicting actions.\nAction " + act.getLabel() + " is problematic."));
            result.setfResultType(RefinementResult.ResultType.MISMATCHING_ACTIONS);
            return result;
        }
        List actions_notInProtocol = SignatureHelper.actions_notInRHS((ModalIOAutomaton)implementation, (ModalIOAutomaton)protocol);
        if (!weakly_extend_protocol && actions_notInProtocol.size() > 0) {
            for (Action a : actions_notInProtocol) {
                MessageManager.addError((String)("Action " + PrettyPrinting.pp((Action)a) + " of " + implementation.getName() + " is not an action of " + protocol.getName()));
            }
            result.setfResultType(RefinementResult.ResultType.MISMATCHING_ACTIONS);
            return result;
        }
        List actions_notInImplementation = SignatureHelper.actions_notInRHS((ModalIOAutomaton)protocol, (ModalIOAutomaton)implementation);
        if (actions_notInImplementation.size() > 0) {
            for (Action a : actions_notInImplementation) {
                MessageManager.addError((String)("Action " + PrettyPrinting.pp((Action)a) + " of " + protocol.getName() + " is not an action of " + implementation.getName()));
            }
            result.setfResultType(RefinementResult.ResultType.MISMATCHING_ACTIONS);
            return result;
        }
        ModalIOAutomaton protocol_extended = protocol;
        if (actions_notInProtocol.size() > 0) {
            List inputactions_notInProtocol = SignatureHelper.getLabels((List)actions_notInProtocol, (SignatureHelper.ActionType)SignatureHelper.ActionType.INPUT);
            List outputactions_notInProtocol = SignatureHelper.getLabels((List)actions_notInProtocol, (SignatureHelper.ActionType)SignatureHelper.ActionType.OUTPUT);
            List internalactions_notInProtocol = SignatureHelper.getLabels((List)actions_notInProtocol, (SignatureHelper.ActionType)SignatureHelper.ActionType.INTERNAL);
            List comms_notInProtocol = SignatureHelper.getLabels((List)actions_notInProtocol, (SignatureHelper.ActionType)SignatureHelper.ActionType.COMMUNICATION);
            String s = "WARNING: " + protocol.getName() + " is weakly extended by actions: ";
            MessageManager.addWarning((String)(String.valueOf(s) + SignatureHelper.prettyPringActions((List)actions_notInProtocol)));
            protocol_extended = MioHelpers.copy((ModalIOAutomaton)protocol);
            SignatureExtension.extendSignature(protocol_extended, inputactions_notInProtocol, outputactions_notInProtocol, internalactions_notInProtocol, comms_notInProtocol, SignatureExtension.SignatureExtensionType.WEAK);
        }
        ModalRefinementImplementation internalChecker = new ModalRefinementImplementation(ModalRefinementImplementation.RefinementType.STRONG, protocol_extended, implementation, printToConsole);
        internalChecker.execute();
        result = internalChecker.getRefinementResult();
        return result;
    }

    public String getName() {
        return "Strong Modal Refinement";
    }
}

