/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.quotient;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.miowb.common.MioEMFFactory;
import net.miowb.common.MioHelpers;
import net.miowb.common.SignatureHelper;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.InternalAction;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.OutputAction;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.operations.common.Helpers;
import net.miowb.operations.common.PruningHelper;
import net.miowb.operations.common.TransitionBetweenSetsOfStatePairs;
import net.miowb.operations.common.TransitionBetweenStatePairs;
import net.miowb.operations.quotient.MioQuotientCommon;
import net.miowb.operations.signature.SignatureExtension;
import net.miowb.operations.utilities.MioStrongMinimization;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.model.SetOfStatePairs;
import net.miowb.workbench.operations.model.StatePair;
import net.miowb.workbench.operations.result.QuotientResult;
import net.miowb.workbench.shell.MessageManager;

public class MioQuotientWrtStrongCompatibility {
    public QuotientResult divide(ModalIOAutomaton t, ModalIOAutomaton s) throws MioException {
        QuotientResult result = new QuotientResult();
        MessageManager.addVerbose((String)"Checking for matching actions...");
        if (!Helpers.checkQuotientableAlphabets(t, s)) {
            result.setResultType(QuotientResult.ResultType.MISMATCHING_ACTIONS);
            return result;
        }
        MessageManager.addVerbose((String)" ... ok!");
        MessageManager.addVerbose((String)"Checking for non-determinism...");
        Helpers.StateAndAction sa1 = Helpers.getNextNonDeterministicStateAndAction(t);
        Helpers.StateAndAction sa2 = Helpers.getNextNonDeterministicStateAndAction(s);
        if (sa1 != null || sa2 != null) {
            result.setResultType(QuotientResult.ResultType.NON_DETERMINISTIC);
            return result;
        }
        MessageManager.addVerbose((String)" ... ok!");
        ModalIOAutomaton t_extended = MioHelpers.copy((ModalIOAutomaton)t);
        ArrayList<String> actionLabelsIn_S_NotIn_T = new ArrayList<String>();
        for (Action a : s.getActions()) {
            if (SignatureHelper.contains((ModalIOAutomaton)t_extended, (String)a.getLabel())) continue;
            actionLabelsIn_S_NotIn_T.add(a.getLabel());
        }
        MessageManager.addVerbose((String)("Weakly extending " + t.getName() + " by actions: " + ((Object)actionLabelsIn_S_NotIn_T).toString()));
        SignatureExtension.extendSignature(t_extended, new ArrayList<String>(), new ArrayList<String>(), actionLabelsIn_S_NotIn_T, new ArrayList<String>(), SignatureExtension.SignatureExtensionType.WEAK);
        MessageManager.addVerbose((String)"Result:");
        MessageManager.addVerbose((String)Helpers.MioToString(t_extended));
        ModalIOAutomaton finalResult = MioEMFFactory.createAutomaton((String)"Quotient");
        Map<String, Action> quot_signature_final = MioQuotientCommon.createActionAlphabetOfQuotient(t_extended, s, finalResult);
        String v = "Quotient has signature ";
        for (InputAction a : finalResult.getInputs()) {
            v = String.valueOf(v) + a.getLabel() + "? ";
        }
        for (InputAction a : finalResult.getOutputs()) {
            v = String.valueOf(v) + a.getLabel() + "! ";
        }
        for (InputAction a : finalResult.getInternals()) {
            v = String.valueOf(v) + a.getLabel() + "; ";
        }
        MessageManager.addVerbose((String)v);
        Map<String, Action> quot_actions_to_be_removed = MioQuotientCommon.createActionsOfQuotientToBeRemoved(s, finalResult);
        MessageManager.addVerbose((String)"Actions which are still there but will be removed: ");
        for (String a : quot_actions_to_be_removed.keySet()) {
            MessageManager.addVerbose((String)("  " + a));
        }
        HashMap<String, Action> quot_signature = new HashMap<String, Action>();
        quot_signature.putAll(quot_signature_final);
        quot_signature.putAll(quot_actions_to_be_removed);
        ModalIOAutomaton s_extended = MioHelpers.copy((ModalIOAutomaton)s);
        ArrayList<Action> actionsinTnotinS = new ArrayList<Action>();
        for (Action a : t_extended.getActions()) {
            if (SignatureHelper.contains((ModalIOAutomaton)s, (String)a.getLabel())) continue;
            actionsinTnotinS.add(a);
        }
        MessageManager.addVerbose((String)("Strongly extending " + s.getName() + " by actions: " + SignatureHelper.prettyPringActions(actionsinTnotinS)));
        SignatureExtension.extendSignature(s_extended, actionsinTnotinS, SignatureExtension.SignatureExtensionType.STRONG);
        MessageManager.addVerbose((String)Helpers.MioToString(s_extended));
        MessageManager.addVerbose((String)"Computing first step of quotient construction...");
        ArrayList<StatePair> fNewStatePairs = new ArrayList<StatePair>();
        ArrayList<StatePair> fVisitedStatePairs = new ArrayList<StatePair>();
        ArrayList<TransitionBetweenStatePairs> fNewTransitions = new ArrayList<TransitionBetweenStatePairs>();
        State fUniversalState = MioEMFFactory.createState((ModalIOAutomaton)s_extended, (String)"uni");
        StatePair fUniversalStatePair = new StatePair(fUniversalState, fUniversalState);
        boolean fUniversalStateReachable = false;
        fVisitedStatePairs.add(fUniversalStatePair);
        StatePair initialstate = new StatePair(t_extended.getStart(), s_extended.getStart());
        fNewStatePairs.add(initialstate);
        while (!fNewStatePairs.isEmpty()) {
            Transition trans_in_S;
            String label;
            StatePair fCurrentStatePair = (StatePair)fNewStatePairs.get(0);
            fNewStatePairs.remove(0);
            fVisitedStatePairs.add(fCurrentStatePair);
            State s1 = fCurrentStatePair.getS2();
            Iterator<Object> t1 = fCurrentStatePair.getS1();
            for (Transition trans_in_T : t1.getOutgoing()) {
                State s2;
                label = trans_in_T.getAction().getLabel();
                if (!SignatureHelper.contains((ModalIOAutomaton)s_extended, (String)label)) {
                    throw new MioException("Quotient: S is not correctly extended.");
                }
                if (!trans_in_T.isMust()) continue;
                trans_in_S = Helpers.getTransitionForLabel(s1, label);
                if (trans_in_S == null || !trans_in_S.isMust()) {
                    fCurrentStatePair.setIsProblem(true);
                    break;
                }
                State t2 = trans_in_T.getTo();
                StatePair targetState = Helpers.getPair(fVisitedStatePairs, t2, s2 = trans_in_S.getTo());
                if (targetState == null) {
                    targetState = Helpers.getPair(fNewStatePairs, t2, s2);
                }
                if (targetState == null) {
                    targetState = new StatePair(t2, s2);
                    fNewStatePairs.add(targetState);
                }
                TransitionBetweenStatePairs newTrans = new TransitionBetweenStatePairs(fCurrentStatePair, targetState, (Action)quot_signature.get(label), true);
                Helpers.addTransition(fNewTransitions, newTrans);
            }
            for (Transition trans_in_T : t1.getOutgoing()) {
                State s2;
                State t2;
                StatePair targetState;
                label = trans_in_T.getAction().getLabel();
                if (!SignatureHelper.contains((ModalIOAutomaton)s_extended, (String)label)) {
                    throw new MioException("Quotient: S is not correctly extended.");
                }
                if (!trans_in_T.isMay() || (trans_in_S = Helpers.getTransitionForLabel(s1, label)) == null) continue;
                Action actS = trans_in_S.getAction();
                boolean make_it_must = false;
                if (actS instanceof OutputAction && quot_signature_final.get(actS.getLabel()) != null && quot_signature_final.get(actS.getLabel()) instanceof InputAction) {
                    make_it_must = true;
                }
                if ((targetState = Helpers.getPair(fVisitedStatePairs, t2 = trans_in_T.getTo(), s2 = trans_in_S.getTo())) == null) {
                    targetState = Helpers.getPair(fNewStatePairs, t2, s2);
                }
                if (targetState == null) {
                    targetState = new StatePair(t2, s2);
                    fNewStatePairs.add(targetState);
                }
                TransitionBetweenStatePairs newTrans = new TransitionBetweenStatePairs(fCurrentStatePair, targetState, (Action)quot_signature.get(label), make_it_must);
                Helpers.addTransition(fNewTransitions, newTrans);
            }
            for (Action a : s_extended.getActions()) {
                Transition trans_in_S2 = Helpers.getTransitionForLabel(s1, a.getLabel());
                if (trans_in_S2 != null || a instanceof InputAction && quot_signature_final.get(a.getLabel()) != null && quot_signature_final.get(a.getLabel()) instanceof OutputAction) continue;
                TransitionBetweenStatePairs newTrans = new TransitionBetweenStatePairs(fCurrentStatePair, fUniversalStatePair, (Action)quot_signature.get(a.getLabel()), false);
                Helpers.addTransition(fNewTransitions, newTrans);
                fUniversalStateReachable = true;
            }
        }
        if (fUniversalStateReachable) {
            for (Action a : s_extended.getActions()) {
                TransitionBetweenStatePairs newTrans = new TransitionBetweenStatePairs(fUniversalStatePair, fUniversalStatePair, (Action)quot_signature.get(a.getLabel()), false);
                Helpers.addTransition(fNewTransitions, newTrans);
            }
        }
        MessageManager.addVerbose((String)" ... done!");
        MessageManager.addVerbose((String)Helpers.MioToString(fVisitedStatePairs, fNewTransitions));
        for (StatePair p : fVisitedStatePairs) {
            if (!p.isProblematic()) continue;
            MessageManager.addVerbose((String)(String.valueOf(p.getLabel()) + " is inconsistent."));
        }
        Helpers.prune(fVisitedStatePairs, fNewTransitions);
        MessageManager.addVerbose((String)"Pruning done");
        for (StatePair p : fVisitedStatePairs) {
            if (!p.isProblematic()) continue;
            throw new MioException("Inconsistent state after pruning");
        }
        if (!fVisitedStatePairs.contains(initialstate)) {
            result.setResultType(QuotientResult.ResultType.INCONSISTENT);
            return result;
        }
        MessageManager.addVerbose((String)"Consistent");
        MessageManager.addVerbose((String)Helpers.MioToString(fVisitedStatePairs, fNewTransitions));
        MessageManager.addVerbose((String)"Collapsing the quotient to remove unobservable actions of S.");
        ArrayList<TransitionBetweenSetsOfStatePairs> fNewSetTransitions = new ArrayList<TransitionBetweenSetsOfStatePairs>();
        ArrayList<SetOfStatePairs> fNewSetsOfStatePairs = new ArrayList<SetOfStatePairs>();
        ArrayList<SetOfStatePairs> fVisitedSetOfStatePairs = new ArrayList<SetOfStatePairs>();
        ArrayList<String> actions_to_be_removed = new ArrayList<String>();
        for (Action a : quot_actions_to_be_removed.values()) {
            actions_to_be_removed.add(a.getLabel());
        }
        SetOfStatePairs final_initial_state = MioQuotientCommon.getReachableSetOfStatePairs(actions_to_be_removed, fNewTransitions, fVisitedStatePairs, initialstate);
        fNewSetsOfStatePairs.add(final_initial_state);
        while (!fNewSetsOfStatePairs.isEmpty()) {
            SetOfStatePairs fCurrentSetOfStatePairs = (SetOfStatePairs)fNewSetsOfStatePairs.get(0);
            fNewSetsOfStatePairs.remove(0);
            fVisitedSetOfStatePairs.add(fCurrentSetOfStatePairs);
            for (Action a : quot_signature_final.values()) {
                boolean always_enabled = true;
                ArrayList nextStatePairs = new ArrayList();
                ArrayList<TransitionBetweenStatePairs> nextTransitions = new ArrayList<TransitionBetweenStatePairs>();
                for (StatePair p : fCurrentSetOfStatePairs.getStatePairs()) {
                    boolean transition_found = false;
                    for (TransitionBetweenStatePairs trans : fNewTransitions) {
                        if (!trans.getFrom().equals(p) || !trans.getAction().getLabel().equals(a.getLabel())) continue;
                        nextStatePairs.add(trans.getTo());
                        nextTransitions.add(trans);
                        transition_found = true;
                    }
                    if (transition_found) continue;
                    always_enabled = false;
                    break;
                }
                if (!always_enabled) continue;
                SetOfStatePairs nextState = new SetOfStatePairs();
                Iterator transition_found = nextStatePairs.iterator();
                while (transition_found.hasNext()) {
                    StatePair p = (StatePair)transition_found.next();
                    nextState.addall(MioQuotientCommon.getReachableSetOfStatePairs(actions_to_be_removed, fNewTransitions, fVisitedStatePairs, p));
                }
                SetOfStatePairs target = Helpers.findSetOfStates(fVisitedSetOfStatePairs, nextState);
                if (target == null && (target = Helpers.findSetOfStates(fNewSetsOfStatePairs, nextState)) == null) {
                    fNewSetsOfStatePairs.add(nextState);
                    target = nextState;
                }
                boolean must_present = false;
                for (TransitionBetweenStatePairs trans : nextTransitions) {
                    if (!trans.isMust()) continue;
                    must_present = true;
                    break;
                }
                TransitionBetweenSetsOfStatePairs newTrans = new TransitionBetweenSetsOfStatePairs(fCurrentSetOfStatePairs, target, quot_signature_final.get(a.getLabel()), must_present);
                Helpers.addSetTransition(fNewSetTransitions, newTrans);
            }
        }
        block20: for (SetOfStatePairs state : fVisitedSetOfStatePairs) {
            for (Action action : quot_signature_final.values()) {
                boolean must = false;
                StatePair must_enabled = null;
                for (StatePair p : state.getStatePairs()) {
                    for (TransitionBetweenStatePairs trans : fNewTransitions) {
                        if (!trans.getFrom().equals(p) || !trans.getAction().getLabel().equals(action.getLabel()) || !trans.isMust()) continue;
                        must = true;
                        must_enabled = p;
                    }
                }
                if (!must) continue;
                boolean always_may = true;
                StatePair not_may_enabled = null;
                for (StatePair p : state.getStatePairs()) {
                    boolean may = false;
                    for (TransitionBetweenStatePairs trans : fNewTransitions) {
                        if (!trans.getFrom().equals(p) || !trans.getAction().getLabel().equals(action.getLabel())) continue;
                        may = true;
                        break;
                    }
                    if (may) continue;
                    always_may = false;
                    not_may_enabled = p;
                    break;
                }
                if (always_may) continue;
                state.setIsProblem(true);
                MessageManager.addVerbose((String)(String.valueOf(state.toString()) + " is inconsistent, because there is a must transition with action " + action.getLabel() + " enabled in state " + must_enabled + " but in state " + not_may_enabled.getLabel() + " the action " + action.getLabel() + " is not may-enabled."));
                continue block20;
            }
        }
        block26: for (SetOfStatePairs state : fVisitedSetOfStatePairs) {
            boolean inconsistent = false;
            for (StatePair p : state.getStatePairs()) {
                for (String l : actions_to_be_removed) {
                    boolean found = false;
                    for (TransitionBetweenStatePairs trans : fNewTransitions) {
                        if (!trans.getFrom().equals(p) || !trans.getAction().getLabel().equals(l)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    inconsistent = true;
                    break;
                }
                if (!inconsistent) continue;
                state.setIsProblem(true);
                MessageManager.addVerbose((String)(String.valueOf(state.toString()) + " is inconsistent, because ... TODO"));
                continue block26;
            }
        }
        for (SetOfStatePairs p : fVisitedSetOfStatePairs) {
            if (!p.isProblematic()) continue;
            MessageManager.addVerbose((String)(String.valueOf(p.getLabel()) + " is inconsistent.\n"));
        }
        Helpers.prune_sets(fVisitedSetOfStatePairs, fNewSetTransitions);
        for (SetOfStatePairs p : fVisitedSetOfStatePairs) {
            if (!p.isProblematic()) continue;
            throw new MioException("Inconsistent state after pruning");
        }
        if (!fVisitedSetOfStatePairs.contains(final_initial_state)) {
            result.setResultType(QuotientResult.ResultType.INCONSISTENT);
            return result;
        }
        LinkedHashMap<SetOfStatePairs, State> toFinalStates = new LinkedHashMap<SetOfStatePairs, State>();
        for (SetOfStatePairs sp : fVisitedSetOfStatePairs) {
            State st = MioEMFFactory.createState((ModalIOAutomaton)finalResult, (String)sp.getLabel());
            toFinalStates.put(sp, st);
        }
        for (TransitionBetweenSetsOfStatePairs trans : fNewSetTransitions) {
            if (trans.getFrom() == null || trans.getTo() == null) {
                throw new MioException("state is null");
            }
            State from = (State)toFinalStates.get(trans.getFrom());
            State to = (State)toFinalStates.get(trans.getTo());
            if (to == null) {
                throw new MioException("state null");
            }
            MustTransition theNewOne = null;
            if (trans.isMust()) {
                MustTransition must = MioEMFFactory.createMustTransition();
                finalResult.getMustTransitions().add((Object)must);
                theNewOne = must;
            } else {
                MayTransition may = MioEMFFactory.createMayTransition();
                finalResult.getMayTransitions().add((Object)may);
                theNewOne = may;
            }
            theNewOne.setFrom(from);
            theNewOne.setTo(to);
            theNewOne.setAction(trans.getAction());
        }
        finalResult.setStart((State)toFinalStates.get(final_initial_state));
        for (Action a : quot_actions_to_be_removed.values()) {
            if (a instanceof InputAction) {
                finalResult.getInputs().remove((Object)a);
            }
            if (a instanceof OutputAction) {
                finalResult.getOutputs().remove((Object)a);
            }
            if (!(a instanceof InternalAction)) continue;
            finalResult.getInternals().remove((Object)a);
        }
        PruningHelper.removeUnreachableStatesAndTransitions(finalResult);
        finalResult = new MioStrongMinimization().execute(finalResult).getAutomaton();
        MioHelpers.renameStates((ModalIOAutomaton)finalResult);
        result.setResultType(QuotientResult.ResultType.SUCCESS);
        result.setAutomaton(finalResult);
        return result;
    }
}

