/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.mts.weakening;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.miowb.common.MioEMFFactory;
import net.miowb.common.MioHelpers;
import net.miowb.common.SignatureHelper;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.operations.common.Helpers;
import net.miowb.operations.common.TransitionBetweenStatePairs;
import net.miowb.operations.signature.SignatureExtension;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.model.StatePair;
import net.miowb.workbench.operations.result.WeakeningResult;

public class MTSWeakening {
    public WeakeningResult weaken(ModalIOAutomaton e, ModalIOAutomaton s) throws MioException {
        ArrayList fMessages = new ArrayList();
        Helpers.StateAndAction sa1 = Helpers.getNextNonDeterministicStateAndAction(e);
        Helpers.StateAndAction sa2 = Helpers.getNextNonDeterministicStateAndAction(s);
        if (sa1 != null || sa2 != null) {
            return new WeakeningResult(WeakeningResult.ResultType.NON_DETERMINISTIC, fMessages);
        }
        List conflicts = SignatureHelper.calculateConflictingActionsForConjunction((ModalIOAutomaton)e, (ModalIOAutomaton)s);
        if (!conflicts.isEmpty()) {
            return new WeakeningResult(WeakeningResult.ResultType.MISMATCHING_ACTIONS, fMessages);
        }
        ArrayList<Action> actionsSnotinE = new ArrayList<Action>();
        for (Action a1 : s.getActions()) {
            if (SignatureHelper.contains((ModalIOAutomaton)e, (Action)a1)) continue;
            actionsSnotinE.add(a1);
        }
        ArrayList<Action> actionsEnotinS = new ArrayList<Action>();
        for (Action a2 : e.getActions()) {
            if (SignatureHelper.contains((ModalIOAutomaton)s, (Action)a2)) continue;
            actionsEnotinS.add(a2);
        }
        ModalIOAutomaton s_extended = MioHelpers.copy((ModalIOAutomaton)s);
        ModalIOAutomaton e_extended = MioHelpers.copy((ModalIOAutomaton)e);
        SignatureExtension.extendSignature(s_extended, actionsEnotinS, SignatureExtension.SignatureExtensionType.WEAK);
        SignatureExtension.extendSignature(e_extended, actionsSnotinE, SignatureExtension.SignatureExtensionType.WEAK);
        if (!Helpers.sameActionAlphabet(s_extended, e_extended)) {
            throw new MioException("An error occurred during signature equalization.");
        }
        ArrayList<StatePair> fNewStatePairs = new ArrayList<StatePair>();
        ArrayList<StatePair> fVisitedStatePairs = new ArrayList<StatePair>();
        ArrayList<TransitionBetweenStatePairs> fNewTransitions = new ArrayList<TransitionBetweenStatePairs>();
        StatePair initialstate = new StatePair(e_extended.getStart(), s_extended.getStart());
        fNewStatePairs.add(initialstate);
        State fUniversalState = MioEMFFactory.createState((ModalIOAutomaton)s_extended, (String)"uni");
        StatePair fUniversalStatePair = new StatePair(fUniversalState, fUniversalState);
        boolean fUniversalStateReachable = false;
        while (!fNewStatePairs.isEmpty()) {
            StatePair fCurrentStatePair = (StatePair)fNewStatePairs.remove(0);
            fVisitedStatePairs.add(fCurrentStatePair);
            State e1 = fCurrentStatePair.getS1();
            State s1 = fCurrentStatePair.getS2();
            block3: for (Transition eTrans : e1.getOutgoing()) {
                State e2 = eTrans.getTo();
                for (Transition sTrans : s1.getOutgoing()) {
                    if (!eTrans.getAction().getLabel().equals(sTrans.getAction().getLabel())) continue;
                    State s2 = sTrans.getTo();
                    StatePair targetState = Helpers.getPair(fVisitedStatePairs, e2, s2);
                    if (targetState == null) {
                        targetState = Helpers.getPair(fNewStatePairs, e2, s2);
                    }
                    if (targetState == null) {
                        targetState = new StatePair(e2, s2);
                        fNewStatePairs.add(targetState);
                    }
                    TransitionBetweenStatePairs newTrans = new TransitionBetweenStatePairs(fCurrentStatePair, targetState, eTrans.getAction(), sTrans.isMust());
                    Helpers.addTransition(fNewTransitions, newTrans);
                    continue block3;
                }
            }
            for (Action act : e_extended.getActions()) {
                Transition trans_in_E = Helpers.getTransitionForLabel(e1, act.getLabel());
                if (trans_in_E != null) continue;
                TransitionBetweenStatePairs newTrans = new TransitionBetweenStatePairs(fCurrentStatePair, fUniversalStatePair, act, false);
                Helpers.addTransition(fNewTransitions, newTrans);
                fUniversalStateReachable = true;
            }
        }
        if (fUniversalStateReachable) {
            fVisitedStatePairs.add(fUniversalStatePair);
            for (Action act : e_extended.getActions()) {
                TransitionBetweenStatePairs newTrans = new TransitionBetweenStatePairs(fUniversalStatePair, fUniversalStatePair, act, false);
                Helpers.addTransition(fNewTransitions, newTrans);
            }
        }
        ModalIOAutomaton finalResult = MioEMFFactory.createAutomaton((String)("(" + e.getName() + " >> " + s.getName() + ")"));
        Map actionmap = SignatureHelper.copyActionAlphabet((ModalIOAutomaton)e_extended, (ModalIOAutomaton)finalResult);
        LinkedHashMap<StatePair, State> toFinalStates = new LinkedHashMap<StatePair, State>();
        for (StatePair sp : fVisitedStatePairs) {
            State st = MioEMFFactory.createState((ModalIOAutomaton)finalResult, (String)sp.getS2().getLabel());
            toFinalStates.put(sp, st);
        }
        for (TransitionBetweenStatePairs trans : fNewTransitions) {
            State from = (State)toFinalStates.get(trans.getFrom());
            State to = (State)toFinalStates.get(trans.getTo());
            MustTransition theNewOne = null;
            if (trans.isMust()) {
                MustTransition must = MioEMFFactory.createMustTransition();
                finalResult.getMustTransitions().add((Object)must);
                theNewOne = must;
            } else {
                MayTransition may = MioEMFFactory.createMayTransition();
                finalResult.getMayTransitions().add((Object)may);
                theNewOne = may;
            }
            theNewOne.setFrom(from);
            theNewOne.setTo(to);
            Action act = (Action)actionmap.get(trans.getAction());
            theNewOne.setAction(act);
        }
        finalResult.setStart((State)toFinalStates.get(initialstate));
        return new WeakeningResult(WeakeningResult.ResultType.SUCCESS, finalResult);
    }
}

