/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.mts.quotient;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.miowb.common.MioEMFFactory;
import net.miowb.common.MioHelpers;
import net.miowb.common.SignatureHelper;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.operations.common.Helpers;
import net.miowb.operations.common.TransitionBetweenStatePairs;
import net.miowb.operations.signature.SignatureExtension;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.model.StatePair;
import net.miowb.workbench.operations.result.QuotientResult;
import net.miowb.workbench.shell.Message;
import net.miowb.workbench.shell.MessageManager;

public class MTSQuotient {
    public QuotientResult divide(ModalIOAutomaton t, ModalIOAutomaton s) throws MioException {
        QuotientResult result = new QuotientResult();
        MessageManager.addVerbose((String)"Checking for matching actions...");
        List conflicts = SignatureHelper.calculateConflictingActionsForConjunction((ModalIOAutomaton)t, (ModalIOAutomaton)s);
        if (!conflicts.isEmpty()) {
            result.setResultType(QuotientResult.ResultType.MISMATCHING_ACTIONS);
            return result;
        }
        MessageManager.addVerbose((String)" ... ok!");
        MessageManager.addVerbose((String)"Checking for non-determinism...");
        Helpers.StateAndAction sa1 = Helpers.getNextNonDeterministicStateAndAction(t);
        Helpers.StateAndAction sa2 = Helpers.getNextNonDeterministicStateAndAction(s);
        if (sa1 != null || sa2 != null) {
            result.setResultType(QuotientResult.ResultType.NON_DETERMINISTIC);
            return result;
        }
        MessageManager.addVerbose((String)" ... ok!");
        ModalIOAutomaton t_extended = MioHelpers.copy((ModalIOAutomaton)t);
        ModalIOAutomaton s_extended = MioHelpers.copy((ModalIOAutomaton)s);
        ArrayList<Action> actionsIn_S_NotIn_T = new ArrayList<Action>();
        for (Action act : s.getActions()) {
            if (SignatureHelper.contains((ModalIOAutomaton)t_extended, (Action)act)) continue;
            actionsIn_S_NotIn_T.add(act);
        }
        ArrayList<Action> actionsIn_T_NotIn_S = new ArrayList<Action>();
        for (Action act : t.getActions()) {
            if (SignatureHelper.contains((ModalIOAutomaton)s_extended, (Action)act)) continue;
            actionsIn_T_NotIn_S.add(act);
        }
        MessageManager.addVerbose((String)("Weakly extending " + t.getName() + " by actions: " + ((Object)actionsIn_S_NotIn_T).toString()));
        SignatureExtension.extendSignature(t_extended, actionsIn_S_NotIn_T, SignatureExtension.SignatureExtensionType.WEAK);
        SignatureExtension.extendSignature(s_extended, actionsIn_T_NotIn_S, SignatureExtension.SignatureExtensionType.STRONG);
        MessageManager.addVerbose((String)"Result:");
        MessageManager.addVerbose((String)Helpers.MioToString(t_extended));
        MessageManager.addVerbose((String)Helpers.MioToString(s_extended));
        ModalIOAutomaton finalResult = MioEMFFactory.createAutomaton((String)("(" + t.getName() + " -- " + s.getName() + ")"));
        MessageManager.addVerbose((String)"Computing first step of quotient construction...");
        ArrayList<StatePair> fNewStatePairs = new ArrayList<StatePair>();
        ArrayList<StatePair> fVisitedStatePairs = new ArrayList<StatePair>();
        ArrayList<TransitionBetweenStatePairs> fNewTransitions = new ArrayList<TransitionBetweenStatePairs>();
        State fUniversalState = MioEMFFactory.createState((ModalIOAutomaton)s_extended, (String)"uni");
        StatePair fUniversalStatePair = new StatePair(fUniversalState, fUniversalState);
        boolean fUniversalStateReachable = false;
        StatePair initialstate = new StatePair(t_extended.getStart(), s_extended.getStart());
        fNewStatePairs.add(initialstate);
        while (!fNewStatePairs.isEmpty()) {
            StatePair fCurrentStatePair = (StatePair)fNewStatePairs.get(0);
            fNewStatePairs.remove(0);
            fVisitedStatePairs.add(fCurrentStatePair);
            State s1 = fCurrentStatePair.getS2();
            Iterator<Object> t1 = fCurrentStatePair.getS1();
            for (Transition trans_in_T : t1.getOutgoing()) {
                State s2;
                String label = trans_in_T.getAction().getLabel();
                if (!SignatureHelper.contains((ModalIOAutomaton)s_extended, (String)label)) {
                    throw new MioException("Quotient: S is not correctly extended.");
                }
                Transition trans_in_S = Helpers.getTransitionForLabel(s1, label);
                if (trans_in_T.isMust() && (trans_in_S == null || !trans_in_S.isMust())) {
                    fCurrentStatePair.setIsProblem(true);
                    break;
                }
                if (trans_in_S == null) continue;
                State t2 = trans_in_T.getTo();
                StatePair targetState = Helpers.getPair(fVisitedStatePairs, t2, s2 = trans_in_S.getTo());
                if (targetState == null) {
                    targetState = Helpers.getPair(fNewStatePairs, t2, s2);
                }
                if (targetState == null) {
                    targetState = new StatePair(t2, s2);
                    fNewStatePairs.add(targetState);
                }
                TransitionBetweenStatePairs newTrans = new TransitionBetweenStatePairs(fCurrentStatePair, targetState, trans_in_T.getAction(), trans_in_T.isMust() && trans_in_S.isMust());
                Helpers.addTransition(fNewTransitions, newTrans);
            }
            if (fCurrentStatePair.isProblematic()) continue;
            for (Action act : t_extended.getActions()) {
                Transition trans_in_S = Helpers.getTransitionForLabel(s1, act.getLabel());
                if (trans_in_S != null) continue;
                TransitionBetweenStatePairs newTrans = new TransitionBetweenStatePairs(fCurrentStatePair, fUniversalStatePair, act, false);
                Helpers.addTransition(fNewTransitions, newTrans);
                fUniversalStateReachable = true;
            }
        }
        if (fUniversalStateReachable) {
            fVisitedStatePairs.add(fUniversalStatePair);
            for (Action act : t_extended.getActions()) {
                TransitionBetweenStatePairs newTrans = new TransitionBetweenStatePairs(fUniversalStatePair, fUniversalStatePair, act, false);
                Helpers.addTransition(fNewTransitions, newTrans);
            }
        }
        MessageManager.addVerbose((String)" ... done!");
        MessageManager.addVerbose((String)Helpers.MioToString(fVisitedStatePairs, fNewTransitions));
        for (StatePair p : fVisitedStatePairs) {
            if (!p.isProblematic()) continue;
            MessageManager.addVerbose((String)(String.valueOf(p.getLabel()) + " is inconsistent."));
        }
        Helpers.prune(fVisitedStatePairs, fNewTransitions);
        MessageManager.addVerbose((String)"Pruning done");
        for (StatePair p : fVisitedStatePairs) {
            if (!p.isProblematic()) continue;
            throw new MioException("Inconsistent state after pruning");
        }
        if (!fVisitedStatePairs.contains(initialstate)) {
            result.setResultType(QuotientResult.ResultType.INCONSISTENT);
            return result;
        }
        MessageManager.addVerbose((String)"Consistent");
        MessageManager.addVerbose((String)Helpers.MioToString(fVisitedStatePairs, fNewTransitions));
        Map actionmap = SignatureHelper.copyActionAlphabet((ModalIOAutomaton)t_extended, (ModalIOAutomaton)finalResult);
        LinkedHashMap<StatePair, State> toFinalStates = new LinkedHashMap<StatePair, State>();
        for (StatePair sp : fVisitedStatePairs) {
            State st = MioEMFFactory.createState((ModalIOAutomaton)finalResult, (String)sp.getLabel());
            toFinalStates.put(sp, st);
        }
        for (TransitionBetweenStatePairs trans : fNewTransitions) {
            State from = (State)toFinalStates.get(trans.getFrom());
            State to = (State)toFinalStates.get(trans.getTo());
            MustTransition theNewOne = null;
            if (trans.isMust()) {
                MustTransition must = MioEMFFactory.createMustTransition();
                finalResult.getMustTransitions().add((Object)must);
                theNewOne = must;
            } else {
                MayTransition may = MioEMFFactory.createMayTransition();
                finalResult.getMayTransitions().add((Object)may);
                theNewOne = may;
            }
            theNewOne.setFrom(from);
            theNewOne.setTo(to);
            Action act = (Action)actionmap.get(trans.getAction());
            theNewOne.setAction(act);
        }
        finalResult.setStart((State)toFinalStates.get(initialstate));
        result.setResultType(QuotientResult.ResultType.SUCCESS);
        result.setAutomaton(finalResult);
        return result;
    }

    private void addVerbose(List<Message> l, String s) {
        l.add(new Message(s, Message.MessageType.VERBOSE));
    }
}

