/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.mts.composition;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import net.miowb.common.MioEMFFactory;
import net.miowb.common.MioHelpers;
import net.miowb.common.SignatureHelper;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.CommunicationAction;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.operations.common.Helpers;
import net.miowb.operations.common.PruningHelper;
import net.miowb.operations.composition.CompositionInternalPairTransition;
import net.miowb.operations.signature.SignatureExtension;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.model.StatePair;
import net.miowb.workbench.operations.result.CompositionResult;
import org.eclipse.emf.common.util.EList;

public class MTSComposition {
    private ModalIOAutomaton fS1;
    private ModalIOAutomaton fS2;
    private List<Action> fNewActions;
    private List<StatePair> fNewStates;
    private StatePair fNewStartPair;
    private List<CompositionInternalPairTransition> fNewTransitions;
    private Set<Action> fNewInternalNonSharedActions;

    public List<StatePair> getfNewStates() {
        return this.fNewStates;
    }

    public StatePair getfNewStartPair() {
        return this.fNewStartPair;
    }

    public List<CompositionInternalPairTransition> getfNewTransitions() {
        return this.fNewTransitions;
    }

    public CompositionResult combine(ModalIOAutomaton s1, ModalIOAutomaton s2) throws MioException {
        new ArrayList();
        ArrayList<Action> actionsIn1NotIn2 = new ArrayList<Action>();
        ArrayList<Action> actionsIn2NotIn1 = new ArrayList<Action>();
        for (Action a : s1.getActions()) {
            if (SignatureHelper.isActionOf((ModalIOAutomaton)s2, (String)a.getLabel())) continue;
            actionsIn1NotIn2.add(a);
        }
        for (Action a : s2.getActions()) {
            if (SignatureHelper.isActionOf((ModalIOAutomaton)s1, (String)a.getLabel())) continue;
            actionsIn2NotIn1.add(a);
        }
        this.fS1 = MioHelpers.copy((ModalIOAutomaton)s1);
        this.fS2 = MioHelpers.copy((ModalIOAutomaton)s2);
        SignatureExtension.extendSignature(this.fS1, actionsIn2NotIn1, SignatureExtension.SignatureExtensionType.STRONG);
        SignatureExtension.extendSignature(this.fS2, actionsIn1NotIn2, SignatureExtension.SignatureExtensionType.STRONG);
        this.fNewStates = new ArrayList<StatePair>();
        for (State stateInS1 : this.fS1.getStates()) {
            for (State stateInS2 : this.fS2.getStates()) {
                this.fNewStates.add(new StatePair(stateInS1, stateInS2));
            }
        }
        this.fNewStartPair = Helpers.getPair(this.fNewStates, this.fS1.getStart(), this.fS2.getStart());
        this.fNewActions = new ArrayList<Action>();
        this.fNewActions.addAll(Helpers.copy(this.fS1.getActions()));
        this.fNewTransitions = new ArrayList<CompositionInternalPairTransition>();
        for (StatePair currentPair : this.fNewStates) {
            EList outgoing = currentPair.getS1().getOutgoing();
            Iterator iterator = outgoing.iterator();
            while (iterator.hasNext()) {
                Transition currentTransition = (Transition)iterator.next();
                this.combine(currentPair, currentTransition, currentPair.getS2());
            }
            EList outgoing2 = currentPair.getS2().getOutgoing();
            for (Transition currentTransition : outgoing2) {
                this.combine(currentPair, currentTransition, currentPair.getS1());
            }
        }
        PruningHelper.removeUnreachableStatesAndTransitions(this.fNewStartPair, this.fNewStates, this.fNewTransitions);
        ModalIOAutomaton finalResult = MioEMFFactory.createAutomaton((String)("(" + s1.getName() + " || " + s2.getName() + ")"));
        for (Action act : this.fNewActions) {
            finalResult.getCommunications().add((Object)((CommunicationAction)act));
        }
        LinkedHashMap<StatePair, State> toFinalStates = new LinkedHashMap<StatePair, State>();
        for (StatePair sp : this.fNewStates) {
            State s = MioEMFFactory.createState((ModalIOAutomaton)finalResult, (String)sp.getLabel());
            toFinalStates.put(sp, s);
        }
        for (CompositionInternalPairTransition pt : this.fNewTransitions) {
            State from = (State)toFinalStates.get(pt.getFrom());
            State to = (State)toFinalStates.get(pt.getTo());
            MustTransition theNewOne = null;
            if (pt.isMust()) {
                MustTransition must = MioEMFFactory.createMustTransition();
                finalResult.getMustTransitions().add((Object)must);
                theNewOne = must;
            } else {
                MayTransition may = MioEMFFactory.createMayTransition();
                finalResult.getMayTransitions().add((Object)may);
                theNewOne = may;
            }
            theNewOne.setFrom(from);
            theNewOne.setTo(to);
            theNewOne.setAction(pt.getAction());
        }
        finalResult.setStart((State)toFinalStates.get(this.fNewStartPair));
        return new CompositionResult(finalResult);
    }

    private void combine(StatePair currentPair, Transition currentTransition, State otherState) {
        Transition matchingTransition = this.findTargetWithOpposite(otherState, currentTransition.getAction());
        if (matchingTransition != null) {
            State targetOnOtherSide = matchingTransition.getTo();
            boolean isMust = false;
            isMust = currentTransition.isMust() && matchingTransition.isMust();
            StatePair nextPair = Helpers.findPair(this.fNewStates, currentTransition.getTo(), targetOnOtherSide);
            CompositionInternalPairTransition newPair = new CompositionInternalPairTransition(currentPair, nextPair, SignatureHelper.getAction(this.fNewActions, (String)currentTransition.getAction().getLabel()), isMust);
            this.addIfNotExists(newPair);
        }
    }

    private void addIfNotExists(CompositionInternalPairTransition newPair) {
        if (!this.fNewTransitions.contains(newPair)) {
            this.fNewTransitions.add(newPair);
        }
    }

    private Transition findTargetWithOpposite(State s2, Action a1) {
        EList outgoing = s2.getOutgoing();
        for (Transition t2 : outgoing) {
            Action a2 = t2.getAction();
            if (!a1.getLabel().equals(a2.getLabel())) continue;
            return t2;
        }
        return null;
    }
}

