/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.maxenvop;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import net.miowb.common.MioEMFFactory;
import net.miowb.common.SignatureHelper;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.InternalAction;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.OutputAction;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.operations.common.Helpers;
import net.miowb.operations.common.PathFinder;
import net.miowb.operations.common.PruningHelper;
import net.miowb.operations.common.TransitionBetweenStateLists;
import net.miowb.operations.conjunction.MioConjunction;
import net.miowb.operations.refinement.ModalRefinementImplementation;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.model.StateList;
import net.miowb.workbench.operations.result.ConjunctionResult;
import net.miowb.workbench.shell.MessageManager;

public class MioMaximalEnvironmentOperation {
    private ModalIOAutomaton fSpec;
    private List<InputAction> fEnvInputs;
    private List<OutputAction> fEnvOutputs;
    private List<InternalAction> fEnvInternals;
    private ModalIOAutomaton fResult;

    public ModalIOAutomaton computeMaximalStrongEnvironment(ModalIOAutomaton spec, ModalIOAutomaton Env) throws MioException {
        this.fResult = MioEMFFactory.createAutomaton((String)"maxEnv");
        SignatureHelper.copyActionAlphabet((ModalIOAutomaton)Env, (ModalIOAutomaton)this.fResult);
        this.fEnvInputs = this.fResult.getInputs();
        this.fEnvOutputs = this.fResult.getOutputs();
        this.fEnvInternals = this.fResult.getInternals();
        this.fSpec = spec;
        this.computeMaximalStrongEnvironment();
        MioConjunction conj = new MioConjunction();
        ConjunctionResult conjresult = conj.conjoin(Env, this.fResult);
        ModalIOAutomaton mio = conjresult.getAutomaton();
        mio.setName("max(" + spec.getName() + "," + Env.getName() + ")");
        return mio;
    }

    private void computeMaximalStrongEnvironment() {
        ArrayList<Object> actlist = new ArrayList<Object>();
        actlist.addAll(this.fEnvInputs);
        actlist.addAll(this.fEnvOutputs);
        actlist.addAll(this.fEnvInternals);
        ArrayList<StateList> fNewStates = new ArrayList<StateList>();
        ArrayList<TransitionBetweenStateLists> fNewTransitions = new ArrayList<TransitionBetweenStateLists>();
        ArrayList<StateList> fVisitedStateLists = new ArrayList<StateList>();
        StateList fUniversalStateList = new StateList(new ArrayList());
        boolean fUniversalStateReachable = false;
        fVisitedStateLists.add(fUniversalStateList);
        StateList initialstate = this.getReachableStates(this.fSpec.getStart());
        fNewStates.add(initialstate);
        while (!fNewStates.isEmpty()) {
            TransitionBetweenStateLists maytrans;
            StateList next;
            StateList list;
            StateList fCurrentStateList = (StateList)fNewStates.get(0);
            fNewStates.remove(0);
            fVisitedStateLists.add(fCurrentStateList);
            for (OutputAction outputAction : this.fSpec.getOutputs()) {
                InputAction in = (InputAction)SignatureHelper.getAction(this.fEnvInputs, (String)outputAction.getLabel());
                if (this.existsMay(fCurrentStateList, (Action)outputAction)) {
                    list = this.getReachableStatesAfterAction(fCurrentStateList, (Action)outputAction);
                    next = Helpers.getStateList(fVisitedStateLists, list);
                    if (next == null && (next = Helpers.getStateList(fNewStates, list)) == null) {
                        fNewStates.add(list);
                        next = list;
                    }
                    TransitionBetweenStateLists maytrans2 = new TransitionBetweenStateLists(fCurrentStateList, next, (Action)in, false);
                    TransitionBetweenStateLists musttrans = new TransitionBetweenStateLists(fCurrentStateList, next, (Action)in, true);
                    fNewTransitions.add(maytrans2);
                    fNewTransitions.add(musttrans);
                    continue;
                }
                maytrans = new TransitionBetweenStateLists(fCurrentStateList, fUniversalStateList, (Action)in, false);
                fNewTransitions.add(maytrans);
                fUniversalStateReachable = true;
            }
            for (InputAction inputAction : this.fSpec.getInputs()) {
                OutputAction out = (OutputAction)SignatureHelper.getAction(this.fEnvOutputs, (String)inputAction.getLabel());
                if (this.existsMay(fCurrentStateList, (Action)inputAction)) {
                    list = this.getReachableStatesAfterAction(fCurrentStateList, (Action)inputAction);
                    next = Helpers.getStateList(fVisitedStateLists, list);
                    if (next == null && (next = Helpers.getStateList(fNewStates, list)) == null) {
                        fNewStates.add(list);
                        next = list;
                    }
                    TransitionBetweenStateLists maytrans2 = new TransitionBetweenStateLists(fCurrentStateList, next, (Action)out, false);
                    fNewTransitions.add(maytrans2);
                    continue;
                }
                maytrans = new TransitionBetweenStateLists(fCurrentStateList, fUniversalStateList, (Action)out, false);
                fNewTransitions.add(maytrans);
                fUniversalStateReachable = true;
            }
            for (Action action : actlist) {
                Action a = SignatureHelper.getAction((ModalIOAutomaton)this.fSpec, (String)action.getLabel());
                if (a != null) continue;
                maytrans = new TransitionBetweenStateLists(fCurrentStateList, fCurrentStateList, action, false);
                fNewTransitions.add(maytrans);
            }
        }
        if (fUniversalStateReachable) {
            for (Action action : actlist) {
                TransitionBetweenStateLists newTrans = new TransitionBetweenStateLists(fUniversalStateList, fUniversalStateList, action, false);
                fNewTransitions.add(newTrans);
            }
        }
        LinkedHashMap<StateList, State> linkedHashMap = new LinkedHashMap<StateList, State>();
        for (StateList sp : fVisitedStateLists) {
            State st = null;
            st = sp == fUniversalStateList ? MioEMFFactory.createState((ModalIOAutomaton)this.fResult, (String)"uni") : MioEMFFactory.createState((ModalIOAutomaton)this.fResult, (String)sp.getLabel());
            linkedHashMap.put(sp, st);
        }
        for (TransitionBetweenStateLists trans : fNewTransitions) {
            State from = (State)linkedHashMap.get(trans.getFrom());
            State to = (State)linkedHashMap.get(trans.getTo());
            MustTransition theNewOne = null;
            if (trans.isMust()) {
                MustTransition must = MioEMFFactory.createMustTransition();
                this.fResult.getMustTransitions().add((Object)must);
                theNewOne = must;
            } else {
                MayTransition may = MioEMFFactory.createMayTransition();
                this.fResult.getMayTransitions().add((Object)may);
                theNewOne = may;
            }
            theNewOne.setFrom(from);
            theNewOne.setTo(to);
            theNewOne.setAction(trans.getAction());
        }
        this.fResult.setStart((State)linkedHashMap.get(initialstate));
        PruningHelper.removeUnreachableStatesAndTransitions(this.fResult);
        MessageManager.addVerbose((String)" ... done!");
    }

    private boolean existsMay(StateList stateList, Action act) {
        for (State s : stateList.getStates()) {
            for (Transition t : s.getOutgoing()) {
                if (!act.getLabel().equals(t.getAction().getLabel())) continue;
                return true;
            }
        }
        return false;
    }

    private StateList getReachableStates(State start) {
        HashSet<Action> set = new HashSet<Action>();
        set.addAll(this.fEnvInputs);
        set.addAll(this.fEnvInternals);
        set.addAll(this.fEnvOutputs);
        InternalAction dummy = MioEMFFactory.createInternal((String)"");
        PathFinder.PathsFound pathsfound = PathFinder.getPossibleTauEmbeddedTransitions(start, (Action)dummy, set, PathFinder.AllowedTransitions.BOTH, PathFinder.PassingMode.WITH_NON_IMPORTANT_BEFORE, PathFinder.EpsilonMode.WITH_EPSILON, ModalRefinementImplementation.ActionComparisonType.SAME);
        StateList result = new StateList(pathsfound.getTargetStates());
        return result;
    }

    private StateList getReachableStatesAfterAction(StateList fCurrentStateList, Action act) {
        StateList result = new StateList();
        for (State s : fCurrentStateList.getStates()) {
            for (Transition t : s.getOutgoing()) {
                if (!t.getAction().getLabel().equals(act.getLabel())) continue;
                result.getStates().addAll(this.getReachableStates(t.getTo()).getStates());
            }
        }
        return result;
    }
}

