/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.environmentcorrectness;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.miowb.common.MioEMFFactory;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.OutputAction;
import net.miowb.model.mio.State;
import net.miowb.operations.common.Helpers;
import net.miowb.operations.common.PathFinder;
import net.miowb.operations.composition.MioSynchronousProduct;
import net.miowb.operations.refinement.ModalRefinementImplementation;
import net.miowb.operations.utilities.MioComposability;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.common.PrettyPrinting;
import net.miowb.workbench.operations.model.SingleActionPath;
import net.miowb.workbench.operations.model.StatePair;
import net.miowb.workbench.operations.result.CompatibilityResult;
import net.miowb.workbench.shell.MessageManager;
import org.eclipse.emf.common.util.EList;

public class EnvironmentCorrectnessImplementation {
    private ModalIOAutomaton fMioSpec;
    private ModalIOAutomaton fMioEnv;
    private MioSynchronousProduct fProd;
    private OutputAction fProblematicOutputAction;
    private StatePair fProblematicStatePair;
    private CompatibilityResult.CompatibilityType fCompType;

    public MioSynchronousProduct getfProd() {
        return this.fProd;
    }

    public OutputAction getfProblematicOutputAction() {
        return this.fProblematicOutputAction;
    }

    public StatePair getfProblematicStatePair() {
        return this.fProblematicStatePair;
    }

    public EnvironmentCorrectnessImplementation(CompatibilityResult.CompatibilityType type, ModalIOAutomaton specification, ModalIOAutomaton environment) throws MioException {
        if (!type.equals((Object)CompatibilityResult.CompatibilityType.STRONG) && !type.equals((Object)CompatibilityResult.CompatibilityType.WEAK)) {
            throw new MioException("Unknown type of environment correctness encountered!");
        }
        this.fMioSpec = specification;
        this.fMioEnv = environment;
        this.fCompType = type;
    }

    public CompatibilityResult checkEnvironmentCorrectness() {
        String compatibilityString = this.fCompType.equals((Object)CompatibilityResult.CompatibilityType.STRONG) ? " -> " : " ->* ";
        MessageManager.add((String)("Checking " + this.fMioSpec.getName() + compatibilityString + this.fMioEnv.getName() + " ..."));
        CompatibilityResult result = new CompatibilityResult(CompatibilityResult.ResultType.SUCCESS, this.fCompType, this.fMioSpec, this.fMioEnv);
        MessageManager.addVerbose((String)"Checking for conflicting actions");
        MioComposability composable = new MioComposability();
        ArrayList<ModalIOAutomaton> list = new ArrayList<ModalIOAutomaton>();
        list.add(this.fMioSpec);
        list.add(this.fMioEnv);
        if (!composable.execute(list)) {
            MessageManager.addError((String)("MIOs are not composable, a conflicting action is " + composable.fConflictingActions.get(0)));
            result.setfType(CompatibilityResult.ResultType.MISMATCHING_ACTIONS);
            return result;
        }
        this.execute();
        if (this.fProblematicStatePair != null) {
            result.setfType(CompatibilityResult.ResultType.ERROR);
            result.setProblematicStatePair(this.fProblematicStatePair);
            result.setProblemPath(this.fProblematicStatePair.getProblematicPath());
            MessageManager.addError((String)"FALSE");
            MessageManager.addError((String)("State " + this.fProblematicStatePair.toString() + " is reachable in (" + this.fMioSpec.getName() + " || " + this.fMioEnv.getName() + "),"));
            MessageManager.addError((String)("in state " + this.fProblematicStatePair.getS1().getLabel() + " the output " + PrettyPrinting.pp((Action)this.fProblematicOutputAction) + " is possible,\nbut in state " + this.fProblematicStatePair.getS2().getLabel() + " the input " + PrettyPrinting.pp((Action)Helpers.getAction(this.fMioEnv, this.fProblematicOutputAction.getLabel())) + " is not required" + (this.fCompType == CompatibilityResult.CompatibilityType.WEAK ? " in any state reachable by internal must-transitions." : ".")));
        } else {
            MessageManager.add((String)"TRUE");
            result.setfType(CompatibilityResult.ResultType.SUCCESS);
        }
        return result;
    }

    private void execute() {
        MessageManager.addVerbose((String)"Composing the two MIOs");
        this.fProd = new MioSynchronousProduct();
        this.fProd.syncProduct(this.fMioSpec, this.fMioEnv);
        MessageManager.addVerbose((String)("Considering any outputs reachable in " + this.fMioSpec.getName() + "."));
        Set<Action> sharedActions = Helpers.createSharedActions(this.fMioSpec, this.fMioEnv);
        for (StatePair currentPair : this.fProd.getfNewStates()) {
            List<SingleActionPath> s1outgoing = this.createOutgoingPathsFrom(currentPair.getS1());
            for (SingleActionPath thePathToCheck : s1outgoing) {
                this.analyzeThis(currentPair, thePathToCheck, currentPair.getS2(), this.fProd.getfNewStates(), sharedActions);
            }
        }
    }

    private List<SingleActionPath> createOutgoingPathsFrom(State someState) {
        return SingleActionPath.convertEach((EList)someState.getOutgoing());
    }

    private void analyzeThis(StatePair currentPair, SingleActionPath thePathToCheck, State currentOtherState, List<StatePair> allNewStates, Set<Action> allNewSharedActions) {
        InputAction input;
        PathFinder.PathsFound information;
        if (Helpers.isInSetBasedOnLabel(allNewSharedActions, thePathToCheck.getAction()) != null && thePathToCheck.getAction().isOutput() && (information = PathFinder.getPossibleTauEmbeddedTransitions(currentOtherState, (Action)(input = MioEMFFactory.createInput((String)thePathToCheck.getAction().getLabel())), allNewSharedActions, PathFinder.AllowedTransitions.MUSTONLY, this.getTauMode(), PathFinder.EpsilonMode.NO_EPISLON, ModalRefinementImplementation.ActionComparisonType.SAME)).getTargetStates().isEmpty()) {
            currentPair.setIsProblem(true);
            this.fProblematicStatePair = currentPair;
            this.fProblematicOutputAction = (OutputAction)thePathToCheck.getAction();
            currentPair.setProblematicPath(thePathToCheck);
        }
    }

    private PathFinder.PassingMode getTauMode() {
        switch (this.fCompType) {
            case STRONG: {
                return PathFinder.PassingMode.NO_PASSING;
            }
            case WEAK: {
                return PathFinder.PassingMode.WITH_TAU_BEFORE;
            }
        }
        return null;
    }
}

