/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.disjunction;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.miowb.common.MioEMFFactory;
import net.miowb.common.MioHelpers;
import net.miowb.common.SignatureHelper;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.operations.common.Helpers;
import net.miowb.operations.common.TransitionBetweenStatePairs;
import net.miowb.operations.signature.SignatureExtension;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.model.StatePair;
import net.miowb.workbench.operations.result.DisjunctionResult;

public class MioDisjunction {
    public DisjunctionResult disjoin(ModalIOAutomaton mio1, ModalIOAutomaton mio2) throws MioException {
        ArrayList fMessages = new ArrayList();
        Helpers.StateAndAction sa1 = Helpers.getNextNonDeterministicStateAndAction(mio1);
        Helpers.StateAndAction sa2 = Helpers.getNextNonDeterministicStateAndAction(mio2);
        if (sa1 != null || sa2 != null) {
            return new DisjunctionResult(DisjunctionResult.ResultType.NON_DETERMINISTIC, fMessages);
        }
        List conflicts = SignatureHelper.calculateConflictingActionsForConjunction((ModalIOAutomaton)mio1, (ModalIOAutomaton)mio2);
        if (!conflicts.isEmpty()) {
            return new DisjunctionResult(DisjunctionResult.ResultType.MISMATCHING_ACTIONS, fMessages);
        }
        ArrayList<Action> actions1notin2 = new ArrayList<Action>();
        for (Action a1 : mio1.getActions()) {
            if (SignatureHelper.contains((ModalIOAutomaton)mio2, (Action)a1)) continue;
            actions1notin2.add(a1);
        }
        ArrayList<Action> actions2notin1 = new ArrayList<Action>();
        for (Action a2 : mio2.getActions()) {
            if (SignatureHelper.contains((ModalIOAutomaton)mio1, (Action)a2)) continue;
            actions2notin1.add(a2);
        }
        ModalIOAutomaton mio1_extended = MioHelpers.copy((ModalIOAutomaton)mio1);
        ModalIOAutomaton mio2_extended = MioHelpers.copy((ModalIOAutomaton)mio2);
        SignatureExtension.extendSignature(mio1_extended, actions2notin1, SignatureExtension.SignatureExtensionType.WEAK);
        SignatureExtension.extendSignature(mio2_extended, actions1notin2, SignatureExtension.SignatureExtensionType.WEAK);
        if (!Helpers.sameActionAlphabet(mio1_extended, mio2_extended)) {
            throw new MioException("An error occurred during signature equalization.");
        }
        ArrayList<StatePair> fNewStatePairs = new ArrayList<StatePair>();
        ArrayList<StatePair> fVisitedStatePairs = new ArrayList<StatePair>();
        ArrayList<TransitionBetweenStatePairs> fNewTransitions = new ArrayList<TransitionBetweenStatePairs>();
        StatePair initialstate = new StatePair(mio1_extended.getStart(), mio2_extended.getStart());
        fNewStatePairs.add(initialstate);
        State dummyState = MioEMFFactory.createState((ModalIOAutomaton)mio1_extended, (String)"");
        while (!fNewStatePairs.isEmpty()) {
            StatePair fCurrentStatePair = (StatePair)fNewStatePairs.remove(0);
            fVisitedStatePairs.add(fCurrentStatePair);
            State s1 = fCurrentStatePair.getS1();
            State t1 = fCurrentStatePair.getS2();
            ArrayList<Transition> matchedTransitionsInT = new ArrayList<Transition>();
            for (Transition sTrans : s1.getOutgoing()) {
                State s2 = sTrans.getTo();
                State t2 = dummyState;
                boolean isMust = false;
                for (Transition tTrans : t1.getOutgoing()) {
                    if (!sTrans.getAction().getLabel().equals(tTrans.getAction().getLabel())) continue;
                    matchedTransitionsInT.add(tTrans);
                    t2 = tTrans.getTo();
                    isMust = sTrans.isMust() && tTrans.isMust();
                    break;
                }
                StatePair targetState = Helpers.getPair(fVisitedStatePairs, s2, t2);
                if (targetState == null) {
                    targetState = Helpers.getPair(fNewStatePairs, s2, t2);
                }
                if (targetState == null) {
                    targetState = new StatePair(s2, t2);
                    fNewStatePairs.add(targetState);
                }
                TransitionBetweenStatePairs newTrans = new TransitionBetweenStatePairs(fCurrentStatePair, targetState, sTrans.getAction(), isMust);
                Helpers.addTransition(fNewTransitions, newTrans);
            }
            for (Transition tTrans : t1.getOutgoing()) {
                if (matchedTransitionsInT.contains(tTrans)) continue;
                StatePair targetState = Helpers.getPair(fVisitedStatePairs, dummyState, tTrans.getTo());
                if (targetState == null) {
                    targetState = Helpers.getPair(fNewStatePairs, dummyState, tTrans.getTo());
                }
                if (targetState == null) {
                    targetState = new StatePair(dummyState, tTrans.getTo());
                    fNewStatePairs.add(targetState);
                }
                TransitionBetweenStatePairs newTrans = new TransitionBetweenStatePairs(fCurrentStatePair, targetState, tTrans.getAction(), false);
                Helpers.addTransition(fNewTransitions, newTrans);
            }
        }
        ModalIOAutomaton finalResult = MioEMFFactory.createAutomaton((String)("(" + mio1.getName() + " or " + mio2.getName() + ")"));
        Map actionmap = SignatureHelper.copyActionAlphabet((ModalIOAutomaton)mio1_extended, (ModalIOAutomaton)finalResult);
        block6: for (Action action : mio2_extended.getActions()) {
            for (Action mappedAction : actionmap.values()) {
                if (!action.getLabel().equals(mappedAction.getLabel()) || action.getClass() != mappedAction.getClass()) continue;
                actionmap.put(action, mappedAction);
                continue block6;
            }
        }
        LinkedHashMap<StatePair, State> toFinalStates = new LinkedHashMap<StatePair, State>();
        for (StatePair sp : fVisitedStatePairs) {
            State s = MioEMFFactory.createState((ModalIOAutomaton)finalResult, (String)sp.getLabel());
            toFinalStates.put(sp, s);
        }
        for (TransitionBetweenStatePairs trans : fNewTransitions) {
            State from = (State)toFinalStates.get(trans.getFrom());
            State to = (State)toFinalStates.get(trans.getTo());
            MustTransition theNewOne = null;
            if (trans.isMust()) {
                MustTransition must = MioEMFFactory.createMustTransition();
                finalResult.getMustTransitions().add((Object)must);
                theNewOne = must;
            } else {
                MayTransition may = MioEMFFactory.createMayTransition();
                finalResult.getMayTransitions().add((Object)may);
                theNewOne = may;
            }
            theNewOne.setFrom(from);
            theNewOne.setTo(to);
            Action act = (Action)actionmap.get(trans.getAction());
            theNewOne.setAction(act);
        }
        finalResult.setStart((State)toFinalStates.get(initialstate));
        return new DisjunctionResult(DisjunctionResult.ResultType.SUCCESS, finalResult, fMessages);
    }
}

