/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.contracts.mts.disjunction;

import java.util.ArrayList;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.miocontract.MiocontractFactory;
import net.miowb.model.miocontract.ModalIOContract;
import net.miowb.operations.conjunction.MioConjunction;
import net.miowb.operations.disjunction.MioDisjunction;
import net.miowb.operations.weakening.MioWeakening;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.contracts.IMioContractDisjunctionOperation;
import net.miowb.workbench.operations.contracts.results.ContractDisjunctionResult;
import net.miowb.workbench.operations.result.ConjunctionResult;
import net.miowb.workbench.operations.result.DisjunctionResult;
import net.miowb.workbench.operations.result.WeakeningResult;
import net.miowb.workbench.shell.Message;

public class MTSContractDisjunction
implements IMioContractDisjunctionOperation {
    public String getName() {
        return "Contract Conjunction";
    }

    public ContractDisjunctionResult disjoin(ModalIOContract c1, ModalIOContract c2) throws MioException {
        ArrayList<Message> fMessages = new ArrayList<Message>();
        ContractDisjunctionResult cdr = new ContractDisjunctionResult(fMessages);
        ModalIOAutomaton spec_c1 = (ModalIOAutomaton)c1.getSpecifications().get(0);
        ModalIOAutomaton env_c1 = (ModalIOAutomaton)c1.getEnvironments().get(0);
        ModalIOAutomaton spec_c2 = (ModalIOAutomaton)c2.getSpecifications().get(0);
        ModalIOAutomaton env_c2 = (ModalIOAutomaton)c2.getEnvironments().get(0);
        ConjunctionResult envConjResult = new MioConjunction().conjoin(env_c1, env_c2);
        if (!envConjResult.getResultType().equals((Object)ConjunctionResult.ResultType.SUCCESS)) {
            cdr.setResultType(ContractDisjunctionResult.ResultType.CONJUNCTION_ERROR);
            fMessages.add(new Message("Error during environment conjunction", Message.MessageType.ERROR));
            return cdr;
        }
        DisjunctionResult specDisjResult = new MioDisjunction().disjoin(spec_c1, spec_c2);
        if (!specDisjResult.getResultType().equals((Object)DisjunctionResult.ResultType.SUCCESS)) {
            cdr.setResultType(ContractDisjunctionResult.ResultType.CONJUNCTION_ERROR);
            fMessages.add(new Message("Error during specification disjunction", Message.MessageType.ERROR));
            return cdr;
        }
        WeakeningResult specWeakenResult = new MioWeakening().weaken(envConjResult.getAutomaton(), specDisjResult.getAutomaton());
        if (!specWeakenResult.getResultType().equals((Object)WeakeningResult.ResultType.SUCCESS)) {
            cdr.setResultType(ContractDisjunctionResult.ResultType.CONJUNCTION_ERROR);
            fMessages.add(new Message("Error during normalization", Message.MessageType.ERROR));
            return cdr;
        }
        cdr.setSpecDisjunctionResult(specDisjResult);
        cdr.setEnvConjunctionResult(envConjResult);
        ModalIOContract newContract = MiocontractFactory.eINSTANCE.createModalIOContract();
        newContract.setName("(" + c1.getName() + " or " + c2.getName() + ")");
        envConjResult.getAutomaton().setName(String.valueOf(newContract.getName()) + " (env)");
        specWeakenResult.getAutomaton().setName(String.valueOf(newContract.getName()) + " (spec)");
        newContract.getEnvironments().add((Object)envConjResult.getAutomaton());
        newContract.getSpecifications().add((Object)specWeakenResult.getAutomaton());
        cdr.setResultType(ContractDisjunctionResult.ResultType.SUCCESS);
        cdr.setContract(newContract);
        return cdr;
    }
}

