/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.contracts.mts.conjunction;

import java.util.ArrayList;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.miocontract.MiocontractFactory;
import net.miowb.model.miocontract.ModalIOContract;
import net.miowb.operations.conjunction.MioConjunction;
import net.miowb.operations.disjunction.MioDisjunction;
import net.miowb.operations.weakening.MioWeakening;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.contracts.results.ContractConjunctionResult;
import net.miowb.workbench.operations.result.ConjunctionResult;
import net.miowb.workbench.operations.result.DisjunctionResult;
import net.miowb.workbench.operations.result.WeakeningResult;
import net.miowb.workbench.shell.Message;

public class MTSContractConjunction {
    public ContractConjunctionResult conjoin(ModalIOContract c1, ModalIOContract c2) throws MioException {
        ArrayList<Message> fMessages = new ArrayList<Message>();
        ContractConjunctionResult ccr = new ContractConjunctionResult(fMessages);
        ModalIOAutomaton spec_c1 = (ModalIOAutomaton)c1.getSpecifications().get(0);
        ModalIOAutomaton env_c1 = (ModalIOAutomaton)c1.getEnvironments().get(0);
        ModalIOAutomaton spec_c2 = (ModalIOAutomaton)c2.getSpecifications().get(0);
        ModalIOAutomaton env_c2 = (ModalIOAutomaton)c2.getEnvironments().get(0);
        ConjunctionResult specConjResult = new MioConjunction().conjoin(spec_c1, spec_c2);
        if (!specConjResult.getResultType().equals((Object)ConjunctionResult.ResultType.SUCCESS)) {
            ccr.setResultType(ContractConjunctionResult.ResultType.CONJUNCTION_ERROR);
            fMessages.add(new Message("Error during specification conjunction", Message.MessageType.ERROR));
            return ccr;
        }
        DisjunctionResult envDisjResult = new MioDisjunction().disjoin(env_c1, env_c2);
        if (!envDisjResult.getResultType().equals((Object)DisjunctionResult.ResultType.SUCCESS)) {
            ccr.setResultType(ContractConjunctionResult.ResultType.CONJUNCTION_ERROR);
            fMessages.add(new Message("Error during environment disjunction", Message.MessageType.ERROR));
            return ccr;
        }
        WeakeningResult specWeakenResult = new MioWeakening().weaken(envDisjResult.getAutomaton(), specConjResult.getAutomaton());
        if (!specWeakenResult.getResultType().equals((Object)WeakeningResult.ResultType.SUCCESS)) {
            ccr.setResultType(ContractConjunctionResult.ResultType.CONJUNCTION_ERROR);
            fMessages.add(new Message("Error during normalization", Message.MessageType.ERROR));
            return ccr;
        }
        ccr.setEnvDisjunctionResult(envDisjResult);
        ccr.setSpecConjunctionResult(specConjResult);
        ModalIOContract newContract = MiocontractFactory.eINSTANCE.createModalIOContract();
        newContract.setName("(" + c1.getName() + " && " + c2.getName() + ")");
        envDisjResult.getAutomaton().setName(String.valueOf(newContract.getName()) + " (env)");
        specWeakenResult.getAutomaton().setName(String.valueOf(newContract.getName()) + " (spec)");
        newContract.getEnvironments().add((Object)envDisjResult.getAutomaton());
        newContract.getSpecifications().add((Object)specWeakenResult.getAutomaton());
        ccr.setResultType(ContractConjunctionResult.ResultType.SUCCESS);
        ccr.setContract(newContract);
        return ccr;
    }
}

