/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.contracts.mts.composition;

import java.util.ArrayList;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.miocontract.MiocontractFactory;
import net.miowb.model.miocontract.ModalIOContract;
import net.miowb.operations.conjunction.MioConjunction;
import net.miowb.operations.mts.composition.MTSComposition;
import net.miowb.operations.mts.quotient.MTSQuotient;
import net.miowb.operations.weakening.MioWeakening;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.contracts.results.ContractCompositionResult;
import net.miowb.workbench.operations.result.CompositionResult;
import net.miowb.workbench.operations.result.ConjunctionResult;
import net.miowb.workbench.operations.result.QuotientResult;
import net.miowb.workbench.operations.result.WeakeningResult;
import net.miowb.workbench.shell.Message;

public class MTSContractComposition {
    public ContractCompositionResult combine(ModalIOContract c1, ModalIOContract c2) throws MioException {
        ArrayList<Message> fMessages = new ArrayList<Message>();
        ContractCompositionResult ccr = new ContractCompositionResult();
        ModalIOAutomaton spec_c1 = (ModalIOAutomaton)c1.getSpecifications().get(0);
        ModalIOAutomaton env_c1 = (ModalIOAutomaton)c1.getEnvironments().get(0);
        ModalIOAutomaton spec_c2 = (ModalIOAutomaton)c2.getSpecifications().get(0);
        ModalIOAutomaton env_c2 = (ModalIOAutomaton)c2.getEnvironments().get(0);
        CompositionResult specCompResult = new MTSComposition().combine(spec_c1, spec_c2);
        if (!specCompResult.getResultType().equals((Object)CompositionResult.ResultType.SUCCESS)) {
            ccr.setResultType(ContractCompositionResult.ResultType.COMPOSITION_ERROR);
            fMessages.add(new Message("Error during specification composition", Message.MessageType.ERROR));
            return ccr;
        }
        QuotientResult leftQuotResult = new MTSQuotient().divide(env_c1, spec_c2);
        if (!leftQuotResult.getResultType().equals((Object)QuotientResult.ResultType.SUCCESS)) {
            ccr.setResultType(ContractCompositionResult.ResultType.COMPOSITION_ERROR);
            fMessages.add(new Message("Error during left side environment quotient", Message.MessageType.ERROR));
            return ccr;
        }
        QuotientResult rightQuotResult = new MTSQuotient().divide(env_c2, spec_c1);
        if (!rightQuotResult.getResultType().equals((Object)QuotientResult.ResultType.SUCCESS)) {
            ccr.setResultType(ContractCompositionResult.ResultType.COMPOSITION_ERROR);
            fMessages.add(new Message("Error during right side environment quotient", Message.MessageType.ERROR));
            return ccr;
        }
        ConjunctionResult envConjResult = new MioConjunction().conjoin(leftQuotResult.getAutomaton(), rightQuotResult.getAutomaton());
        if (!envConjResult.getResultType().equals((Object)ConjunctionResult.ResultType.SUCCESS)) {
            ccr.setResultType(ContractCompositionResult.ResultType.COMPOSITION_ERROR);
            fMessages.add(new Message("Error during environment conjunction", Message.MessageType.ERROR));
            return ccr;
        }
        WeakeningResult specWeakenResult = new MioWeakening().weaken(envConjResult.getAutomaton(), specCompResult.getAutomaton());
        if (!specWeakenResult.getResultType().equals((Object)WeakeningResult.ResultType.SUCCESS)) {
            ccr.setResultType(ContractCompositionResult.ResultType.COMPOSITION_ERROR);
            fMessages.add(new Message("Error during normalization", Message.MessageType.ERROR));
            return ccr;
        }
        ccr.setSpecCompResult(specCompResult);
        ccr.setLeftQuotResult(leftQuotResult);
        ccr.setRightQuotResult(rightQuotResult);
        ccr.setEnvConjResult(envConjResult);
        ModalIOContract newContract = MiocontractFactory.eINSTANCE.createModalIOContract();
        newContract.setName("(" + c1.getName() + " || " + c2.getName() + ")");
        envConjResult.getAutomaton().setName(String.valueOf(newContract.getName()) + " (env)");
        specWeakenResult.getAutomaton().setName(String.valueOf(newContract.getName()) + " (spec)");
        newContract.getEnvironments().add((Object)envConjResult.getAutomaton());
        newContract.getSpecifications().add((Object)specWeakenResult.getAutomaton());
        ccr.setResultType(ContractCompositionResult.ResultType.SUCCESS);
        ccr.setContract(newContract);
        return ccr;
    }
}

