/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.contracts.composition;

import net.miowb.common.MioHelpers;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.miocontract.MiocontractFactory;
import net.miowb.model.miocontract.ModalIOContract;
import net.miowb.operations.composition.MioSynchronousProduct;
import net.miowb.operations.conjunction.MioConjunction;
import net.miowb.operations.maxenvop.MioMaximalEnvironmentOperation;
import net.miowb.operations.quotient.MioQuotient;
import net.miowb.operations.utilities.MioStrongMinimization;
import net.miowb.operations.weakening.MioWeakening;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.contracts.results.ContractCompositionResult;
import net.miowb.workbench.operations.result.ConjunctionResult;
import net.miowb.workbench.operations.result.QuotientResult;
import net.miowb.workbench.shell.MessageManager;

public class MioContractComposition {
    public ContractCompositionResult combine(ModalIOContract c1, ModalIOContract c2) throws MioException {
        ContractCompositionResult ccr = new ContractCompositionResult();
        MessageManager.addVerbose((String)("Composing the two contracts " + c1.getName() + " and " + c2.getName()));
        ModalIOAutomaton spec_c1 = (ModalIOAutomaton)c1.getSpecifications().get(0);
        ModalIOAutomaton env_c1 = (ModalIOAutomaton)c1.getEnvironments().get(0);
        ModalIOAutomaton spec_c2 = (ModalIOAutomaton)c2.getSpecifications().get(0);
        ModalIOAutomaton env_c2 = (ModalIOAutomaton)c2.getEnvironments().get(0);
        MessageManager.addVerbose((String)"Normalizing the contracts");
        ModalIOAutomaton spec_1_nf = new MioWeakening().weaken(env_c1, spec_c1).getAutomaton();
        ModalIOAutomaton spec_2_nf = new MioWeakening().weaken(env_c2, spec_c2).getAutomaton();
        MioSynchronousProduct specCompResult = new MioSynchronousProduct();
        specCompResult.syncProduct(spec_1_nf, spec_2_nf);
        ModalIOAutomaton newGuarantee = specCompResult.assemble();
        if (newGuarantee == null) {
            ccr.setResultType(ContractCompositionResult.ResultType.COMPOSITION_ERROR);
            MessageManager.addError((String)"Error during specification composition");
            return ccr;
        }
        QuotientResult leftQuotResult = new MioQuotient().divide(env_c1, spec_2_nf);
        if (!leftQuotResult.getResultType().equals((Object)QuotientResult.ResultType.SUCCESS)) {
            ccr.setResultType(ContractCompositionResult.ResultType.COMPOSITION_ERROR);
            MessageManager.addError((String)("Error during quotienting:\n" + env_c1.getName() + " / " + spec_2_nf.getName()));
            return ccr;
        }
        QuotientResult rightQuotResult = new MioQuotient().divide(env_c2, spec_1_nf);
        if (!rightQuotResult.getResultType().equals((Object)QuotientResult.ResultType.SUCCESS)) {
            ccr.setResultType(ContractCompositionResult.ResultType.COMPOSITION_ERROR);
            MessageManager.addError((String)("Error during quotienting:\n" + env_c2.getName() + " / " + spec_1_nf.getName()));
            return ccr;
        }
        ConjunctionResult envConjResult = new MioConjunction().conjoin(leftQuotResult.getAutomaton(), rightQuotResult.getAutomaton());
        if (!envConjResult.getResultType().equals((Object)ConjunctionResult.ResultType.SUCCESS)) {
            ccr.setResultType(ContractCompositionResult.ResultType.COMPOSITION_ERROR);
            MessageManager.addError((String)("Error during conjoining:\n" + leftQuotResult.getAutomaton().getName() + " / " + rightQuotResult.getAutomaton().getName()));
            return ccr;
        }
        MioMaximalEnvironmentOperation env = new MioMaximalEnvironmentOperation();
        ModalIOAutomaton newAssumption = env.computeMaximalStrongEnvironment(newGuarantee, envConjResult.getAutomaton());
        newGuarantee = new MioStrongMinimization().execute(newGuarantee).getAutomaton();
        newAssumption = new MioStrongMinimization().execute(newAssumption).getAutomaton();
        MioHelpers.renameStates((ModalIOAutomaton)newGuarantee);
        MioHelpers.renameStates((ModalIOAutomaton)newAssumption);
        ccr.setLeftQuotResult(leftQuotResult);
        ccr.setRightQuotResult(rightQuotResult);
        ccr.setEnvConjResult(envConjResult);
        ModalIOContract newContract = MiocontractFactory.eINSTANCE.createModalIOContract();
        newContract.setName("(" + c1.getName() + " || " + c2.getName() + ")");
        newAssumption.setName(String.valueOf(newContract.getName()) + " (env)");
        newGuarantee.setName(String.valueOf(newContract.getName()) + " (spec)");
        newContract.getEnvironments().add((Object)newAssumption);
        newContract.getSpecifications().add((Object)newGuarantee);
        ccr.setResultType(ContractCompositionResult.ResultType.SUCCESS);
        ccr.setContract(newContract);
        return ccr;
    }
}

