/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.composition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.miowb.common.MioEMFFactory;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.InternalAction;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.OutputAction;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.operations.common.Helpers;
import net.miowb.operations.common.PruningHelper;
import net.miowb.operations.composition.CompositionInternalPairTransition;
import net.miowb.operations.utilities.MioComposability;
import net.miowb.workbench.operations.model.StatePair;
import net.miowb.workbench.operations.result.CompositionResult;
import net.miowb.workbench.shell.MessageManager;
import org.eclipse.emf.common.util.EList;

public class MioSynchronousProduct {
    private ModalIOAutomaton fS1;
    private ModalIOAutomaton fS2;
    private Set<Action> fNewIns;
    private Set<Action> fNewOuts;
    private Set<Action> fNewInternals;
    private Set<Action> fNewInternalSharedActions;
    private List<StatePair> fNewStates;
    private StatePair fNewStartPair;
    private List<CompositionInternalPairTransition> fNewTransitions;
    private Set<Action> fNewInternalNonSharedActions;

    public ModalIOAutomaton getfS1() {
        return this.fS1;
    }

    public ModalIOAutomaton getfS2() {
        return this.fS2;
    }

    public Set<Action> getfNewIns() {
        return this.fNewIns;
    }

    public Set<Action> getfNewOuts() {
        return this.fNewOuts;
    }

    public Set<Action> getfNewInternals() {
        return this.fNewInternals;
    }

    public List<StatePair> getfNewStates() {
        return this.fNewStates;
    }

    public StatePair getfNewStartPair() {
        return this.fNewStartPair;
    }

    public List<CompositionInternalPairTransition> getfNewTransitions() {
        return this.fNewTransitions;
    }

    public CompositionResult syncProduct(ModalIOAutomaton s1, ModalIOAutomaton s2) {
        MessageManager.addVerbose((String)("Constructing the synchronous product of " + s1.getName() + " and " + s2.getName()));
        this.fS1 = s1;
        this.fS2 = s2;
        MioComposability composable = new MioComposability();
        ArrayList<ModalIOAutomaton> list = new ArrayList<ModalIOAutomaton>();
        list.add(this.fS1);
        list.add(this.fS2);
        if (!composable.execute(list)) {
            return new CompositionResult(CompositionResult.ResultType.PROBLEM_ACTIONS);
        }
        this.fNewStates = new ArrayList<StatePair>();
        for (State stateInS1 : this.fS1.getStates()) {
            for (State stateInS2 : this.fS2.getStates()) {
                this.fNewStates.add(new StatePair(stateInS1, stateInS2));
            }
        }
        this.fNewStartPair = Helpers.getPair(this.fNewStates, this.fS1.getStart(), this.fS2.getStart());
        this.fNewIns = new LinkedHashSet<Action>();
        this.fNewIns.addAll(Helpers.copy(Helpers.withoutBasedOnLabel((List<? extends Action>)this.fS1.getInputs(), (List<? extends Action>)this.fS2.getOutputs())));
        this.fNewIns.addAll(Helpers.copy(Helpers.withoutBasedOnLabel((List<? extends Action>)this.fS2.getInputs(), (List<? extends Action>)this.fS1.getOutputs())));
        this.fNewOuts = new LinkedHashSet<Action>();
        this.fNewOuts.addAll(Helpers.copy(Helpers.withoutBasedOnLabel((List<? extends Action>)this.fS1.getOutputs(), (List<? extends Action>)this.fS2.getInputs())));
        this.fNewOuts.addAll(Helpers.copy(Helpers.withoutBasedOnLabel((List<? extends Action>)this.fS2.getOutputs(), (List<? extends Action>)this.fS1.getInputs())));
        this.fNewInternalNonSharedActions = new LinkedHashSet<Action>();
        this.fNewInternalNonSharedActions.addAll(Helpers.copy((Collection<? extends Action>)this.fS1.getInternals()));
        this.fNewInternalNonSharedActions.addAll(Helpers.copy((Collection<? extends Action>)this.fS2.getInternals()));
        this.fNewInternalSharedActions = new LinkedHashSet<Action>();
        this.fNewInternalSharedActions.addAll(Helpers.copy(Helpers.intersectionBasedOnLabel((List<? extends Action>)this.fS1.getInputs(), (List<? extends Action>)this.fS2.getOutputs()), Helpers.NewType.INTERNAL));
        this.fNewInternalSharedActions.addAll(Helpers.copy(Helpers.intersectionBasedOnLabel((List<? extends Action>)this.fS1.getOutputs(), (List<? extends Action>)this.fS2.getInputs()), Helpers.NewType.INTERNAL));
        this.fNewInternals = new LinkedHashSet<Action>();
        this.fNewInternals.addAll(this.fNewInternalSharedActions);
        this.fNewInternals.addAll(this.fNewInternalNonSharedActions);
        this.fNewTransitions = new ArrayList<CompositionInternalPairTransition>();
        for (StatePair currentPair : this.fNewStates) {
            EList outgoing = currentPair.getS1().getOutgoing();
            for (Transition currentTransition : outgoing) {
                this.combine(currentPair, currentTransition, currentPair.getS2());
            }
            EList outgoing2 = currentPair.getS2().getOutgoing();
            for (Transition currentTransition : outgoing2) {
                this.combine(currentPair, currentTransition, currentPair.getS1());
            }
        }
        PruningHelper.removeUnreachableStatesAndTransitions(this.fNewStartPair, this.fNewStates, this.fNewTransitions);
        return new CompositionResult(CompositionResult.ResultType.SUCCESS);
    }

    private void combine(StatePair currentPair, Transition currentTransition, State otherState) {
        if (Helpers.isInSetBasedOnLabel(this.fNewInternalSharedActions, currentTransition.getAction()) != null) {
            Transition matchingTransition = this.findTargetWithOpposite(otherState, currentTransition);
            if (matchingTransition != null) {
                State targetOnOtherSide = matchingTransition.getTo();
                boolean isMust = false;
                isMust = currentTransition.isMust() && matchingTransition.isMust();
                StatePair nextPair = Helpers.findPair(this.fNewStates, currentTransition.getTo(), targetOnOtherSide);
                CompositionInternalPairTransition newPair = new CompositionInternalPairTransition(currentPair, nextPair, this.toNewShared(this.fNewInternalSharedActions, currentTransition.getAction()), isMust);
                this.addIfNotExists(newPair);
            }
        } else {
            StatePair nextPair = Helpers.findPair(this.fNewStates, currentTransition.getTo(), otherState);
            CompositionInternalPairTransition newPair = new CompositionInternalPairTransition(currentPair, nextPair, this.toNewNonShared(currentTransition.getAction()), currentTransition.isMust());
            this.addIfNotExists(newPair);
        }
    }

    private void addIfNotExists(CompositionInternalPairTransition newPair) {
        if (!this.fNewTransitions.contains(newPair)) {
            this.fNewTransitions.add(newPair);
        }
    }

    private Action toNewNonShared(Action action) {
        Set<Action> newActionsToSearch = null;
        if (action.isInput()) {
            newActionsToSearch = this.fNewIns;
        } else if (action.isOutput()) {
            newActionsToSearch = this.fNewOuts;
        } else if (action.isInternal()) {
            newActionsToSearch = this.fNewInternalNonSharedActions;
        }
        for (Action theNewAction : newActionsToSearch) {
            if (!theNewAction.getLabel().equals(action.getLabel())) continue;
            return theNewAction;
        }
        return null;
    }

    private Action toNewShared(Set<Action> newSharedActions, Action givenAction) {
        for (Action action : newSharedActions) {
            if (!action.getLabel().equals(givenAction.getLabel())) continue;
            return action;
        }
        return null;
    }

    private Transition findTargetWithOpposite(State s2, Transition t1) {
        EList outgoing = s2.getOutgoing();
        for (Transition t2 : outgoing) {
            Action a1 = t1.getAction();
            Action a2 = t2.getAction();
            if (!a1.getLabel().equals(a2.getLabel())) continue;
            if (a1.isInput() && a2.isOutput()) {
                return t2;
            }
            if (!a1.isOutput() || !a2.isInput()) continue;
            return t2;
        }
        return null;
    }

    public ModalIOAutomaton assemble() {
        ModalIOAutomaton finalResult = MioEMFFactory.createAutomaton((String)"");
        for (Action in : this.fNewIns) {
            finalResult.getInputs().add((Object)((InputAction)in));
        }
        for (Action out : this.fNewOuts) {
            finalResult.getOutputs().add((Object)((OutputAction)out));
        }
        for (Action intn : this.fNewInternals) {
            finalResult.getInternals().add((Object)((InternalAction)intn));
        }
        LinkedHashMap<StatePair, State> toFinalStates = new LinkedHashMap<StatePair, State>();
        for (StatePair sp : this.fNewStates) {
            State s = MioEMFFactory.createState((ModalIOAutomaton)finalResult, (String)sp.getLabel());
            toFinalStates.put(sp, s);
        }
        for (CompositionInternalPairTransition pt : this.fNewTransitions) {
            State from = (State)toFinalStates.get(pt.getFrom());
            State to = (State)toFinalStates.get(pt.getTo());
            MustTransition theNewOne = null;
            if (pt.isMust()) {
                MustTransition must = MioEMFFactory.createMustTransition();
                finalResult.getMustTransitions().add((Object)must);
                theNewOne = must;
            } else {
                MayTransition may = MioEMFFactory.createMayTransition();
                finalResult.getMayTransitions().add((Object)may);
                theNewOne = may;
            }
            theNewOne.setFrom(from);
            theNewOne.setTo(to);
            theNewOne.setAction(pt.getAction());
        }
        finalResult.setStart((State)toFinalStates.get(this.fNewStartPair));
        return finalResult;
    }
}

