/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.composition;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.miowb.common.MioEMFFactory;
import net.miowb.common.MioHelpers;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.MayTransition;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.MustTransition;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.operations.common.TransitionBetweenStateLists;
import net.miowb.operations.utilities.MioComposability;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.model.StateList;
import net.miowb.workbench.operations.result.CompositionResult;

public class MioProductOfList {
    public List<ModalIOAutomaton> fMios;
    public StateList fNewStartList;
    public List<StateList> fNewStates = new ArrayList<StateList>();
    public List<TransitionBetweenStateLists> fNewTransitions = new ArrayList<TransitionBetweenStateLists>();
    public MioComposability fNewActionAlphabet;
    private List<StateList> to_be_checked = new ArrayList<StateList>();

    public CompositionResult syncProduct(List<ModalIOAutomaton> mios) throws MioException {
        this.fMios = mios;
        MioComposability composable = new MioComposability();
        if (!composable.execute(mios)) {
            composable.generateMsg();
            return new CompositionResult(CompositionResult.ResultType.PROBLEM_ACTIONS);
        }
        ArrayList<State> startlist = new ArrayList<State>();
        for (ModalIOAutomaton mio : mios) {
            startlist.add(mio.getStart());
        }
        StateList start = new StateList(startlist);
        this.to_be_checked.add(start);
        while (this.to_be_checked.size() > 0) {
            StateList s = this.to_be_checked.remove(0);
            this.fNewStates.add(s);
            int i = 0;
            while (i < s.getSize()) {
                State state = s.get(i);
                for (Transition t : state.getOutgoing()) {
                    Action act = t.getAction();
                    Action newAction = composable.fMap.get(act);
                    if (!composable.fShared.containsKey(act)) {
                        StateList to = this.addState(s.exchange(i, t.getTo()));
                        this.addTransition(new TransitionBetweenStateLists(s, to, newAction, t.isMust()));
                        continue;
                    }
                    Action matchAction = composable.fShared.get(act);
                    int j = mios.indexOf(matchAction.getAutomaton());
                    if (j == -1) {
                        throw new MioException("Internal error in composition (could not compute index).");
                    }
                    for (Transition t2 : s.get(j).getOutgoing()) {
                        if (!t2.getAction().getLabel().equals(matchAction.getLabel())) continue;
                        StateList to = this.addState(s.exchange(i, t.getTo()).exchange(j, t2.getTo()));
                        this.addTransition(new TransitionBetweenStateLists(s, to, newAction, t.isMust() && t2.isMust()));
                    }
                }
                ++i;
            }
        }
        this.fNewActionAlphabet = composable;
        String name = "( ";
        for (ModalIOAutomaton m : mios) {
            name = String.valueOf(name) + m.getName() + " || ";
        }
        name = String.valueOf(name.substring(0, name.length() - 3)) + ")";
        ModalIOAutomaton finalResult = MioEMFFactory.createAutomaton((String)name);
        finalResult.getInputs().addAll(this.fNewActionAlphabet.fNewIns);
        finalResult.getOutputs().addAll(this.fNewActionAlphabet.fNewOuts);
        finalResult.getInternals().addAll(this.fNewActionAlphabet.fNewInternals);
        LinkedHashMap<StateList, State> toFinalStates = new LinkedHashMap<StateList, State>();
        for (StateList sl : this.fNewStates) {
            State s = MioEMFFactory.createState((ModalIOAutomaton)finalResult, (String)sl.getLabel());
            toFinalStates.put(sl, s);
        }
        finalResult.setStart((State)toFinalStates.get(start));
        for (TransitionBetweenStateLists pt : this.fNewTransitions) {
            State from = (State)toFinalStates.get(pt.getFrom());
            State to = (State)toFinalStates.get(pt.getTo());
            if (from == null || to == null) {
                to = (State)toFinalStates.get(pt.getTo());
                ((StateList)toFinalStates.keySet().iterator().next()).equals(pt.getTo());
                toFinalStates.keySet().contains(pt.getTo());
                throw new MioException("Internal error in composition.");
            }
            MustTransition theNewOne = null;
            if (pt.isMust()) {
                MustTransition must = MioEMFFactory.createMustTransition();
                finalResult.getMustTransitions().add((Object)must);
                theNewOne = must;
            } else {
                MayTransition may = MioEMFFactory.createMayTransition();
                finalResult.getMayTransitions().add((Object)may);
                theNewOne = may;
            }
            theNewOne.setFrom(from);
            theNewOne.setTo(to);
            theNewOne.setAction(pt.getAction());
        }
        MioHelpers.renameStates((ModalIOAutomaton)finalResult);
        return new CompositionResult(finalResult);
    }

    private void addTransition(TransitionBetweenStateLists newTrans) {
        for (TransitionBetweenStateLists t : this.fNewTransitions) {
            if (!t.getFrom().matches(newTrans.getFrom()) || !t.getTo().matches(newTrans.getTo()) || !t.getAction().getLabel().equals(newTrans.getAction().getLabel())) continue;
            if (newTrans.isMust() && !t.isMust()) {
                t.setMust(true);
            }
            return;
        }
        this.fNewTransitions.add(newTrans);
    }

    private StateList addState(StateList s) {
        for (StateList l : this.to_be_checked) {
            if (!s.matches(l)) continue;
            return l;
        }
        for (StateList l : this.fNewStates) {
            if (!s.matches(l)) continue;
            return l;
        }
        this.to_be_checked.add(s);
        return s;
    }
}

