/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.compatibility;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.miowb.common.MioEMFFactory;
import net.miowb.common.SignatureHelper;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.State;
import net.miowb.operations.common.Helpers;
import net.miowb.operations.common.PathFinder;
import net.miowb.operations.common.PruningHelper;
import net.miowb.operations.composition.CompositionInternalPairTransition;
import net.miowb.operations.composition.MioSynchronousProduct;
import net.miowb.operations.refinement.ModalRefinementImplementation;
import net.miowb.operations.utilities.MioComposability;
import net.miowb.workbench.operations.model.RefinementRelation;
import net.miowb.workbench.operations.model.SingleActionPath;
import net.miowb.workbench.operations.model.StatePair;
import net.miowb.workbench.operations.result.CompatibilityResult;
import net.miowb.workbench.operations.result.RefinementResult;
import net.miowb.workbench.shell.Message;
import net.miowb.workbench.shell.MessageManager;
import org.eclipse.emf.common.util.EList;

public class VV_OutputCompatibilityImplementation {
    private ModalIOAutomaton fS1;
    private ModalIOAutomaton fS2;
    private MioSynchronousProduct fProd;
    private List<String> fProblemActions = new ArrayList<String>();
    private List<StatePair> fProblemPairs = new ArrayList<StatePair>();
    private CompatibilityResult.CompatibilityType fCompType;
    private List<Message> fMessages = new ArrayList<Message>();

    public MioSynchronousProduct getfProd() {
        return this.fProd;
    }

    public List<String> getfProblemActions() {
        return this.fProblemActions;
    }

    public List<StatePair> getfProblemPairs() {
        return this.fProblemPairs;
    }

    public List<Message> getfMessages() {
        return this.fMessages;
    }

    public VV_OutputCompatibilityImplementation(CompatibilityResult.CompatibilityType type, ModalIOAutomaton s1, ModalIOAutomaton s2) {
        this.fS1 = s1;
        this.fS2 = s2;
        this.fCompType = type;
    }

    public CompatibilityResult checkCompatibility() {
        this.execute();
        CompatibilityResult result = new CompatibilityResult(CompatibilityResult.ResultType.SUCCESS, this.fMessages, this.fCompType, this.fS1, this.fS2);
        if (this.fProblemActions != null && !this.fProblemActions.isEmpty()) {
            result.setfType(CompatibilityResult.ResultType.MISMATCHING_ACTIONS);
            MessageManager.addError((String)("The involved MIOs are not composable.\nConflicting action: " + this.fProblemActions.get(0)));
            return result;
        }
        if (this.fCompType != CompatibilityResult.CompatibilityType.STRONG_FRIENDLY) {
            if (!this.fProblemPairs.isEmpty()) {
                result.setfType(CompatibilityResult.ResultType.ERROR);
                result.setProblematicStatePair(this.fProblemPairs.get(0));
                result.setProblemPath(this.fProblemPairs.get(0).getProblematicPath());
                MessageManager.addError((String)("false: problematic state pair is " + this.fProblemPairs.toString()));
            } else {
                MessageManager.add((String)"true");
                result.setfType(CompatibilityResult.ResultType.SUCCESS);
            }
        } else {
            ArrayList<CompositionInternalPairTransition> input_trans = new ArrayList<CompositionInternalPairTransition>();
            for (CompositionInternalPairTransition t : this.fProd.getfNewTransitions()) {
                if (!t.getAction().isInput()) continue;
                input_trans.add(t);
            }
            this.fProd.getfNewTransitions().removeAll(input_trans);
            PruningHelper.removeUnreachableStatesAndTransitions(this.fProd.getfNewStartPair(), this.fProd.getfNewStates(), this.fProd.getfNewTransitions());
            List<StatePair> problematicStates = this.fProblemPairs;
            ArrayList<StatePair> final_problematicStates = new ArrayList<StatePair>();
            for (StatePair sp : this.fProd.getfNewStates()) {
                if (!problematicStates.contains(sp)) continue;
                final_problematicStates.add(sp);
            }
            if (!final_problematicStates.isEmpty()) {
                result.setfType(CompatibilityResult.ResultType.ERROR);
                result.setProblematicStatePair((StatePair)final_problematicStates.get(0));
                result.setProblemPath(((StatePair)final_problematicStates.get(0)).getProblematicPath());
            } else {
                result.setfType(CompatibilityResult.ResultType.SUCCESS);
            }
        }
        return result;
    }

    public CompatibilityResult delegateToSOChecking() {
        ArrayList fMessages = new ArrayList();
        List conflicts = SignatureHelper.calculateConflictingActionsForComposition((ModalIOAutomaton)this.fS1, (ModalIOAutomaton)this.fS2);
        if (!conflicts.isEmpty()) {
            CompatibilityResult checkResult = new CompatibilityResult(CompatibilityResult.ResultType.MISMATCHING_ACTIONS, fMessages, this.fCompType, this.fS1, this.fS2);
            return checkResult;
        }
        ModalRefinementImplementation internalChecker = new ModalRefinementImplementation(ModalRefinementImplementation.RefinementType.STRICTOBSERVATIONAL_COMPAT, this.fS1, this.fS2, false);
        internalChecker.execute();
        RefinementResult refinementResult = internalChecker.getRefinementResult();
        CompatibilityResult res = null;
        if (refinementResult.isOkay()) {
            res = new CompatibilityResult(CompatibilityResult.ResultType.SUCCESS, fMessages, this.fCompType, this.fS1, this.fS2);
            res.setResultingStates(new ArrayList(refinementResult.getPositiveResult().getStatePairs()));
        } else {
            res = new CompatibilityResult(CompatibilityResult.ResultType.ERROR, fMessages, this.fCompType, this.fS1, this.fS2);
            List negativeResults = refinementResult.getNegativeResults();
            RefinementRelation refinementRelation2 = (RefinementRelation)negativeResults.get(0);
            res.setProblematicStatePair(refinementRelation2.getPairWithoutProvided());
            List requiredWithoutProvided = refinementRelation2.getRequiredWithoutProvided();
            res.setProblemPath((SingleActionPath)requiredWithoutProvided.get(0));
        }
        return res;
    }

    private void execute() {
        this.addVerbose("Checking for conflicting actions");
        MioComposability composable = new MioComposability();
        ArrayList<ModalIOAutomaton> list = new ArrayList<ModalIOAutomaton>();
        list.add(this.fS1);
        list.add(this.fS2);
        if (!composable.execute(list)) {
            this.fProblemActions.add(composable.fConflictingActions.get(0));
            return;
        }
        this.addVerbose("Composing the two MIOs");
        this.fProd = new MioSynchronousProduct();
        this.fProd.syncProduct(this.fS1, this.fS2);
        Set<Action> sharedActions = Helpers.createSharedActions(this.fS1, this.fS2);
        for (StatePair currentPair : this.fProd.getfNewStates()) {
            List<SingleActionPath> s1outgoing = this.createOutgoingPathsFrom(currentPair.getS1());
            for (SingleActionPath thePathToCheck : s1outgoing) {
                this.analyzeThis(currentPair, thePathToCheck, currentPair.getS2(), this.fProd.getfNewStates(), sharedActions);
            }
            List<SingleActionPath> s2outgoing = this.createOutgoingPathsFrom(currentPair.getS2());
            for (SingleActionPath thePathToCheck : s2outgoing) {
                this.analyzeThis(currentPair, thePathToCheck, currentPair.getS1(), this.fProd.getfNewStates(), sharedActions);
            }
        }
    }

    private void addVerbose(String string) {
        this.fMessages.add(new Message(string, Message.MessageType.VERBOSE));
    }

    private List<SingleActionPath> createOutgoingPathsFrom(State someState) {
        return SingleActionPath.convertEach((EList)someState.getOutgoing());
    }

    private void analyzeThis(StatePair currentPair, SingleActionPath thePathToCheck, State currentOtherState, List<StatePair> allNewStates, Set<Action> allNewSharedActions) {
        InputAction input;
        PathFinder.PathsFound information;
        if (Helpers.isInSetBasedOnLabel(allNewSharedActions, thePathToCheck.getAction()) != null && thePathToCheck.getAction().isOutput() && (information = PathFinder.getPossibleTauEmbeddedTransitions(currentOtherState, (Action)(input = MioEMFFactory.createInput((String)thePathToCheck.getAction().getLabel())), allNewSharedActions, PathFinder.AllowedTransitions.MUSTONLY, this.getTauMode(), PathFinder.EpsilonMode.NO_EPISLON, ModalRefinementImplementation.ActionComparisonType.SAME)).getTargetStates().isEmpty()) {
            currentPair.setIsProblem(true);
            this.fProblemPairs.add(currentPair);
            currentPair.setProblematicPath(thePathToCheck);
        }
    }

    private PathFinder.PassingMode getTauMode() {
        switch (this.fCompType) {
            case STRONG: 
            case STRONG_FRIENDLY: {
                return PathFinder.PassingMode.NO_PASSING;
            }
            case WEAK: {
                return PathFinder.PassingMode.WITH_TAU_BEFORE;
            }
            case ULTRAWEAK: {
                return PathFinder.PassingMode.WITH_TAU_AND_NONSHARED_OUTPUTS_BEFORE;
            }
        }
        return null;
    }
}

