/*
 * Decompiled with CFR 0.152.
 */
package net.miowb.operations.compatibility;

import java.util.List;
import net.miowb.model.mio.Action;
import net.miowb.model.mio.InputAction;
import net.miowb.model.mio.ModalIOAutomaton;
import net.miowb.model.mio.OutputAction;
import net.miowb.model.mio.State;
import net.miowb.model.mio.Transition;
import net.miowb.operations.common.PathFinder;
import net.miowb.operations.composition.MioProductOfList;
import net.miowb.operations.refinement.ModalRefinementImplementation;
import net.miowb.workbench.common.MioException;
import net.miowb.workbench.operations.model.StateList;
import net.miowb.workbench.operations.result.CompatibilityResult;
import net.miowb.workbench.operations.result.CompositionResult;
import net.miowb.workbench.shell.MessageManager;

public class RevisedOutputCompatibilityImplementation {
    private List<ModalIOAutomaton> fMIOs;
    private CompatibilityResult.CompatibilityType fCompType;

    public RevisedOutputCompatibilityImplementation(List<ModalIOAutomaton> fMIOs, CompatibilityResult.CompatibilityType fCompType) {
        this.fMIOs = fMIOs;
        this.fCompType = fCompType;
    }

    public CompatibilityResult execute() throws MioException {
        MioProductOfList product = new MioProductOfList();
        CompositionResult result = product.syncProduct(this.fMIOs);
        if (result.getResultType().equals((Object)CompositionResult.ResultType.PROBLEM_ACTIONS)) {
            return new CompatibilityResult(CompatibilityResult.ResultType.MISMATCHING_ACTIONS, null, this.fCompType, null, null);
        }
        for (StateList l : product.fNewStates) {
            for (State s : l.getStates()) {
                for (OutputAction out : s.getAutomaton().getOutputs()) {
                    for (Transition t : s.getOutgoing()) {
                        State other_state;
                        PathFinder.PathsFound information;
                        InputAction in = (InputAction)product.fNewActionAlphabet.fShared.get(out);
                        if (!t.getAction().equals(out) || in == null || !(information = PathFinder.getPossibleTauEmbeddedTransitions(other_state = l.get(l.getIndex(in.getAutomaton())), (Action)in, product.fNewActionAlphabet.fShared.keySet(), PathFinder.AllowedTransitions.MUSTONLY, this.getTauMode(), PathFinder.EpsilonMode.NO_EPISLON, ModalRefinementImplementation.ActionComparisonType.SAME)).getTargetStates().isEmpty()) continue;
                        MessageManager.addError((String)"FALSE");
                        MessageManager.addError((String)(String.valueOf(l.toString()) + " is a problematic state: " + s.getAutomaton().getName() + " can send out " + out.toNiceString() + " but " + in.getAutomaton().getName() + " cannot receive it."));
                        return new CompatibilityResult(CompatibilityResult.ResultType.ERROR, null, this.fCompType, null, null);
                    }
                }
            }
        }
        MessageManager.add((String)"TRUE");
        return new CompatibilityResult(CompatibilityResult.ResultType.SUCCESS, null, this.fCompType, null, null);
    }

    private PathFinder.PassingMode getTauMode() {
        switch (this.fCompType) {
            case STRONG: 
            case STRONG_FRIENDLY: {
                return PathFinder.PassingMode.NO_PASSING;
            }
            case WEAK: {
                return PathFinder.PassingMode.WITH_TAU_BEFORE;
            }
            case ULTRAWEAK: {
                return PathFinder.PassingMode.WITH_TAU_AND_NONSHARED_OUTPUTS_BEFORE;
            }
        }
        return null;
    }
}

